/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.nativeruntime.BitmapShaderNatives;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.shadows.GraphicsShadowPicker;

@Implements(value=BitmapShader.class, minSdk=26, shadowPicker=Picker.class)
public class ShadowNativeBitmapShader {
    @Implementation(minSdk=26, maxSdk=28)
    protected static long nativeCreate(long nativeMatrix, Bitmap bitmap, int shaderTileModeX, int shaderTileModeY) {
        return ShadowNativeBitmapShader.nativeCreate(nativeMatrix, bitmap != null ? bitmap.getNativeInstance() : 0L, shaderTileModeX, shaderTileModeY, false);
    }

    @Implementation(minSdk=29, maxSdk=30)
    protected static long nativeCreate(long nativeMatrix, long bitmapHandle, int shaderTileModeX, int shaderTileModeY) {
        return ShadowNativeBitmapShader.nativeCreate(nativeMatrix, bitmapHandle, shaderTileModeX, shaderTileModeY, false);
    }

    @Implementation(minSdk=31, maxSdk=32)
    protected static long nativeCreate(long nativeMatrix, long bitmapHandle, int shaderTileModeX, int shaderTileModeY, boolean filter) {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return BitmapShaderNatives.nativeCreate((long)nativeMatrix, (long)bitmapHandle, (int)shaderTileModeX, (int)shaderTileModeY, (boolean)filter);
    }

    @Implementation(minSdk=33)
    protected static long nativeCreate(long nativeMatrix, long bitmapHandle, int shaderTileModeX, int shaderTileModeY, boolean filter, boolean isDirectSampled) {
        return ShadowNativeBitmapShader.nativeCreate(nativeMatrix, bitmapHandle, shaderTileModeX, shaderTileModeY, filter);
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(null, ShadowNativeBitmapShader.class);
        }
    }
}

