/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=VelocityTracker.class)
public class ShadowVelocityTracker {
    private static final int ACTIVE_POINTER_ID = -1;
    private static final int HISTORY_SIZE = 20;
    private static final long HORIZON_MS = 200L;
    private static final long MIN_DURATION = 10L;
    private boolean initialized = false;
    private int activePointerId = -1;
    private final Movement[] movements = new Movement[20];
    private int curIndex = 0;
    private SparseArray<Float> computedVelocityX = new SparseArray();
    private SparseArray<Float> computedVelocityY = new SparseArray();

    private void maybeInitialize() {
        if (this.initialized) {
            return;
        }
        for (int i = 0; i < this.movements.length; ++i) {
            this.movements[i] = new Movement();
        }
        this.initialized = true;
    }

    @Implementation
    protected void clear() {
        this.maybeInitialize();
        this.curIndex = 0;
        this.computedVelocityX.clear();
        this.computedVelocityY.clear();
        for (Movement movement : this.movements) {
            movement.clear();
        }
    }

    @Implementation
    protected void addMovement(MotionEvent event) {
        this.maybeInitialize();
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        if (event.getActionMasked() == 0) {
            this.clear();
        } else if (event.getActionMasked() != 2) {
            return;
        }
        this.curIndex = (this.curIndex + 1) % 20;
        this.movements[this.curIndex].set(event);
    }

    @Implementation
    protected void computeCurrentVelocity(int units) {
        this.computeCurrentVelocity(units, Float.MAX_VALUE);
    }

    @Implementation
    protected void computeCurrentVelocity(int units, float maxVelocity) {
        this.maybeInitialize();
        Movement newestMovement = this.movements[this.curIndex];
        if (!newestMovement.isSet()) {
            return;
        }
        for (int pointerId : newestMovement.pointerIds) {
            int nextOldestIndex;
            Movement nextOldestMovement;
            long minTime = newestMovement.eventTime - 200L;
            int oldestIndex = this.curIndex;
            int numTouches = 1;
            while ((nextOldestMovement = this.movements[nextOldestIndex = (oldestIndex == 0 ? 20 : oldestIndex) - 1]).hasPointer(pointerId) && nextOldestMovement.eventTime >= minTime) {
                oldestIndex = nextOldestIndex;
                if (++numTouches < 20) continue;
            }
            float accumVx = 0.0f;
            float accumVy = 0.0f;
            int index = oldestIndex;
            Movement oldestMovement = this.movements[oldestIndex];
            long lastDuration = 0L;
            while (numTouches-- > 1) {
                if (++index == 20) {
                    index = 0;
                }
                Movement movement = this.movements[index];
                long duration = movement.eventTime - oldestMovement.eventTime;
                if (duration < 10L) continue;
                float scale = 1000.0f / (float)duration;
                float vx = (((Float)movement.x.get(pointerId)).floatValue() - ((Float)oldestMovement.x.get(pointerId)).floatValue()) * scale;
                float vy = (((Float)movement.y.get(pointerId)).floatValue() - ((Float)oldestMovement.y.get(pointerId)).floatValue()) * scale;
                accumVx = (accumVx * (float)lastDuration + vx * (float)duration) / (float)(duration + lastDuration);
                accumVy = (accumVy * (float)lastDuration + vy * (float)duration) / (float)(duration + lastDuration);
                lastDuration = duration;
            }
            this.computedVelocityX.put(pointerId, (Object)Float.valueOf(this.windowed(accumVx * (float)units / 1000.0f, maxVelocity)));
            this.computedVelocityY.put(pointerId, (Object)Float.valueOf(this.windowed(accumVy * (float)units / 1000.0f, maxVelocity)));
        }
        this.activePointerId = newestMovement.activePointerId;
    }

    private float windowed(float value, float max) {
        return Math.min(max, Math.max(-max, value));
    }

    @Implementation
    protected float getXVelocity() {
        return this.getXVelocity(-1);
    }

    @Implementation
    protected float getYVelocity() {
        return this.getYVelocity(-1);
    }

    @Implementation
    protected float getXVelocity(int id2) {
        if (id2 == -1) {
            id2 = this.activePointerId;
        }
        return ((Float)this.computedVelocityX.get(id2, (Object)Float.valueOf(0.0f))).floatValue();
    }

    @Implementation
    protected float getYVelocity(int id2) {
        if (id2 == -1) {
            id2 = this.activePointerId;
        }
        return ((Float)this.computedVelocityY.get(id2, (Object)Float.valueOf(0.0f))).floatValue();
    }

    private static class Movement {
        public int pointerCount = 0;
        public int[] pointerIds = new int[0];
        public int activePointerId = -1;
        public long eventTime;
        public SparseArray<Float> x = new SparseArray();
        public SparseArray<Float> y = new SparseArray();

        private Movement() {
        }

        public void set(MotionEvent event) {
            this.pointerCount = event.getPointerCount();
            this.pointerIds = new int[this.pointerCount];
            this.x.clear();
            this.y.clear();
            for (int i = 0; i < this.pointerCount; ++i) {
                this.pointerIds[i] = event.getPointerId(i);
                this.x.put(this.pointerIds[i], (Object)Float.valueOf(event.getX(i)));
                this.y.put(this.pointerIds[i], (Object)Float.valueOf(event.getY(i)));
            }
            this.activePointerId = event.getPointerId(0);
            this.eventTime = event.getEventTime();
        }

        public void clear() {
            this.pointerCount = 0;
            this.activePointerId = -1;
        }

        public boolean isSet() {
            return this.pointerCount != 0;
        }

        public boolean hasPointer(int pointerId) {
            return this.x.get(pointerId) != null;
        }
    }
}

