/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Intent;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.hardware.usb.UsbPort;
import android.hardware.usb.UsbPortStatus;
import android.os.ParcelFileDescriptor;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=UsbManager.class, looseSignatures=true)
public class ShadowUsbManager {
    private final HashMap<String, List<UsbDevice>> grantedPermissions = new HashMap();
    private final HashMap<String, UsbDevice> usbDevices = new HashMap();
    private final HashMap<UsbPort, UsbPortStatus> usbPorts = new HashMap();
    private UsbAccessory attachedUsbAccessory = null;

    @Implementation
    protected boolean hasPermission(UsbDevice device) {
        return this.hasPermissionForPackage(device, RuntimeEnvironment.application.getPackageName());
    }

    public boolean hasPermissionForPackage(UsbDevice device, String packageName) {
        List<UsbDevice> usbDevices = this.grantedPermissions.get(packageName);
        return usbDevices != null && usbDevices.contains(device);
    }

    @Implementation(minSdk=24)
    @HiddenApi
    protected void grantPermission(UsbDevice device) {
        this.grantPermission(device, RuntimeEnvironment.application.getPackageName());
    }

    @Implementation(minSdk=25)
    @HiddenApi
    protected void grantPermission(UsbDevice device, String packageName) {
        List<UsbDevice> usbDevices = this.grantedPermissions.get(packageName);
        if (usbDevices == null) {
            usbDevices = new ArrayList<UsbDevice>();
            this.grantedPermissions.put(packageName, usbDevices);
        }
        usbDevices.add(device);
    }

    public void revokePermission(UsbDevice device, String packageName) {
        List<UsbDevice> usbDevices = this.grantedPermissions.get(packageName);
        if (usbDevices != null) {
            usbDevices.remove(device);
        }
    }

    @Implementation
    protected HashMap<String, UsbDevice> getDeviceList() {
        return new HashMap<String, UsbDevice>(this.usbDevices);
    }

    @Implementation
    protected UsbAccessory[] getAccessoryList() {
        if (this.attachedUsbAccessory == null) {
            return null;
        }
        return new UsbAccessory[]{this.attachedUsbAccessory};
    }

    public void setAttachedUsbAccessory(UsbAccessory usbAccessory) {
        this.attachedUsbAccessory = usbAccessory;
    }

    public void addOrUpdateUsbDevice(UsbDevice usbDevice, boolean hasPermission) {
        Preconditions.checkNotNull((Object)usbDevice);
        Preconditions.checkNotNull((Object)usbDevice.getDeviceName());
        this.usbDevices.put(usbDevice.getDeviceName(), usbDevice);
        if (hasPermission) {
            this.grantPermission(usbDevice);
        } else {
            this.revokePermission(usbDevice, RuntimeEnvironment.application.getPackageName());
        }
    }

    public void removeUsbDevice(UsbDevice usbDevice) {
        Preconditions.checkNotNull((Object)usbDevice);
        this.usbDevices.remove(usbDevice.getDeviceName());
        this.revokePermission(usbDevice, RuntimeEnvironment.application.getPackageName());
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected Object[] getPorts() {
        return this.usbPorts.keySet().toArray(new UsbPort[this.usbPorts.size()]);
    }

    public void clearPorts() {
        this.usbPorts.clear();
    }

    public void addPort(String portId) {
        this.usbPorts.put(new UsbPort(portId, 3), new UsbPortStatus(3, 2, 2, 0));
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected Object getPortStatus(Object port) {
        return this.usbPorts.get(port);
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected void setPortRoles(Object port, Object powerRole, Object dataRole) {
        UsbPortStatus status = this.usbPorts.get(port);
        this.usbPorts.put((UsbPort)port, new UsbPortStatus(status.getCurrentMode(), ((Integer)powerRole).intValue(), ((Integer)dataRole).intValue(), status.getSupportedRoleCombinations()));
        RuntimeEnvironment.application.sendBroadcast(new Intent("android.hardware.usb.action.USB_PORT_CHANGED"));
    }

    @Implementation
    protected ParcelFileDescriptor openAccessory(UsbAccessory accessory) {
        try {
            File tmpUsbDir = RuntimeEnvironment.getTempDirectory().createIfNotExists("usb-accessory").toFile();
            return ParcelFileDescriptor.open((File)new File(tmpUsbDir, "usb-accessory-file"), (int)0x30000000);
        }
        catch (FileNotFoundException error) {
            throw new RuntimeException("Error shadowing openAccessory", error);
        }
    }
}

