/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ComponentName;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.telecom.PhoneAccount;
import android.telecom.PhoneAccountHandle;
import android.telecom.TelecomManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=TelecomManager.class, minSdk=21)
public class ShadowTelecomManager {
    @RealObject
    private TelecomManager realObject;
    private PhoneAccountHandle simCallManager;
    private LinkedHashMap<PhoneAccountHandle, PhoneAccount> accounts = new LinkedHashMap();
    private List<CallRecord> incomingCalls = new ArrayList<CallRecord>();
    private List<CallRecord> unknownCalls = new ArrayList<CallRecord>();
    private String defaultDialerPackageName;

    @Implementation
    protected PhoneAccountHandle getDefaultOutgoingPhoneAccount(String uriScheme) {
        return null;
    }

    @Implementation
    @HiddenApi
    public PhoneAccountHandle getUserSelectedOutgoingPhoneAccount() {
        return null;
    }

    @Implementation
    @HiddenApi
    public void setUserSelectedOutgoingPhoneAccount(PhoneAccountHandle accountHandle) {
    }

    @Implementation
    protected PhoneAccountHandle getSimCallManager() {
        return this.simCallManager;
    }

    @Implementation(minSdk=23)
    @HiddenApi
    public PhoneAccountHandle getSimCallManager(int userId) {
        return null;
    }

    @Implementation
    @HiddenApi
    public PhoneAccountHandle getConnectionManager() {
        return this.getSimCallManager();
    }

    @Implementation
    @HiddenApi
    public List<PhoneAccountHandle> getPhoneAccountsSupportingScheme(String uriScheme) {
        ArrayList<PhoneAccountHandle> result = new ArrayList<PhoneAccountHandle>();
        for (PhoneAccountHandle handle : this.accounts.keySet()) {
            PhoneAccount phoneAccount = this.accounts.get(handle);
            if (!phoneAccount.getSupportedUriSchemes().contains(uriScheme)) continue;
            result.add(handle);
        }
        return result;
    }

    @Implementation(minSdk=23)
    protected List<PhoneAccountHandle> getCallCapablePhoneAccounts() {
        return this.getCallCapablePhoneAccounts(false);
    }

    @Implementation(minSdk=23)
    @HiddenApi
    public List<PhoneAccountHandle> getCallCapablePhoneAccounts(boolean includeDisabledAccounts) {
        ArrayList<PhoneAccountHandle> result = new ArrayList<PhoneAccountHandle>();
        for (PhoneAccountHandle handle : this.accounts.keySet()) {
            PhoneAccount phoneAccount = this.accounts.get(handle);
            if (!phoneAccount.isEnabled() && !includeDisabledAccounts) continue;
            result.add(handle);
        }
        return result;
    }

    @Implementation
    @HiddenApi
    public List<PhoneAccountHandle> getPhoneAccountsForPackage() {
        Context context = (Context)ReflectionHelpers.getField((Object)this.realObject, (String)"mContext");
        ArrayList<PhoneAccountHandle> results = new ArrayList<PhoneAccountHandle>();
        for (PhoneAccountHandle handle : this.accounts.keySet()) {
            if (!handle.getComponentName().getPackageName().equals(context.getPackageName())) continue;
            results.add(handle);
        }
        return results;
    }

    @Implementation
    protected PhoneAccount getPhoneAccount(PhoneAccountHandle account) {
        return this.accounts.get(account);
    }

    @Implementation
    @HiddenApi
    public int getAllPhoneAccountsCount() {
        return this.accounts.size();
    }

    @Implementation
    @HiddenApi
    public List<PhoneAccount> getAllPhoneAccounts() {
        return ImmutableList.copyOf(this.accounts.values());
    }

    @Implementation
    @HiddenApi
    public List<PhoneAccountHandle> getAllPhoneAccountHandles() {
        return ImmutableList.copyOf(this.accounts.keySet());
    }

    @Implementation
    protected void registerPhoneAccount(PhoneAccount account) {
        this.accounts.put(account.getAccountHandle(), account);
    }

    @Implementation
    protected void unregisterPhoneAccount(PhoneAccountHandle accountHandle) {
        this.accounts.remove(accountHandle);
    }

    @Deprecated
    @Implementation
    @HiddenApi
    public void clearAccounts() {
        this.accounts.clear();
    }

    @Implementation(minSdk=22)
    @HiddenApi
    public void clearAccountsForPackage(String packageName) {
        HashSet<PhoneAccountHandle> phoneAccountHandlesInPackage = new HashSet<PhoneAccountHandle>();
        for (PhoneAccountHandle handle : this.accounts.keySet()) {
            if (!handle.getComponentName().getPackageName().equals(packageName)) continue;
            phoneAccountHandlesInPackage.add(handle);
        }
        for (PhoneAccountHandle handle : phoneAccountHandlesInPackage) {
            this.accounts.remove(handle);
        }
    }

    @Deprecated
    @Implementation
    @HiddenApi
    public ComponentName getDefaultPhoneApp() {
        return null;
    }

    @Implementation(minSdk=23)
    protected String getDefaultDialerPackage() {
        return this.defaultDialerPackageName;
    }

    @Implementation(minSdk=23)
    @HiddenApi
    public boolean setDefaultDialer(String packageName) {
        this.defaultDialerPackageName = packageName;
        return true;
    }

    @Implementation(minSdk=23)
    @HiddenApi
    public String getSystemDialerPackage() {
        return null;
    }

    @Implementation(minSdk=22)
    protected boolean isVoiceMailNumber(PhoneAccountHandle accountHandle, String number) {
        return false;
    }

    @Implementation(minSdk=23)
    protected String getVoiceMailNumber(PhoneAccountHandle accountHandle) {
        return null;
    }

    @Implementation(minSdk=22)
    protected String getLine1Number(PhoneAccountHandle accountHandle) {
        return null;
    }

    @Implementation
    protected boolean isInCall() {
        return false;
    }

    @Implementation
    @HiddenApi
    public int getCallState() {
        return 0;
    }

    @Implementation
    @HiddenApi
    public boolean isRinging() {
        for (CallRecord callRecord : this.incomingCalls) {
            if (!callRecord.isRinging) continue;
            return true;
        }
        for (CallRecord callRecord : this.unknownCalls) {
            if (!callRecord.isRinging) continue;
            return true;
        }
        return false;
    }

    @Implementation
    @HiddenApi
    public boolean endCall() {
        return false;
    }

    @Implementation
    protected void acceptRingingCall() {
    }

    @Implementation
    protected void silenceRinger() {
        for (CallRecord callRecord : this.incomingCalls) {
            callRecord.isRinging = false;
        }
        for (CallRecord callRecord : this.unknownCalls) {
            callRecord.isRinging = false;
        }
    }

    @Implementation
    protected boolean isTtySupported() {
        return false;
    }

    @Implementation
    @HiddenApi
    public int getCurrentTtyMode() {
        return 0;
    }

    @Implementation
    protected void addNewIncomingCall(PhoneAccountHandle phoneAccount, Bundle extras) {
        this.incomingCalls.add(new CallRecord(phoneAccount, extras));
    }

    public List<CallRecord> getAllIncomingCalls() {
        return this.incomingCalls;
    }

    @Implementation
    @HiddenApi
    public void addNewUnknownCall(PhoneAccountHandle phoneAccount, Bundle extras) {
        this.unknownCalls.add(new CallRecord(phoneAccount, extras));
    }

    public List<CallRecord> getAllUnknownCalls() {
        return this.unknownCalls;
    }

    @Implementation
    protected boolean handleMmi(String dialString) {
        return false;
    }

    @Implementation(minSdk=23)
    protected boolean handleMmi(String dialString, PhoneAccountHandle accountHandle) {
        return false;
    }

    @Implementation(minSdk=22)
    protected Uri getAdnUriForPhoneAccount(PhoneAccountHandle accountHandle) {
        return Uri.parse((String)"content://icc/adn");
    }

    @Implementation
    protected void cancelMissedCallsNotification() {
    }

    @Implementation
    protected void showInCallScreen(boolean showDialpad) {
    }

    @Implementation(minSdk=23)
    protected void placeCall(Uri address, Bundle extras) {
    }

    @Implementation(minSdk=23)
    @HiddenApi
    public void enablePhoneAccount(PhoneAccountHandle handle, boolean isEnabled) {
    }

    public void setSimCallManager(PhoneAccountHandle simCallManager) {
        this.simCallManager = simCallManager;
    }

    public static class CallRecord {
        public final PhoneAccountHandle phoneAccount;
        public final Bundle bundle;
        private boolean isRinging = true;

        public CallRecord(PhoneAccountHandle phoneAccount, Bundle extras) {
            this.phoneAccount = phoneAccount;
            this.bundle = extras;
        }
    }
}

