/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.AudioAttributes;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemVibrator;
import android.os.VibrationEffect;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowVibrator;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=SystemVibrator.class, isInAndroidSdk=false)
public class ShadowSystemVibrator
extends ShadowVibrator {
    private Handler handler = new Handler(Looper.myLooper());
    private Runnable stopVibratingRunnable = () -> {
        this.vibrating = false;
    };

    @Implementation
    protected boolean hasVibrator() {
        return this.hasVibrator;
    }

    @Implementation(minSdk=26)
    protected boolean hasAmplitudeControl() {
        return this.hasAmplitudeControl;
    }

    @Implementation(maxSdk=17)
    protected void vibrate(long[] pattern, int repeat) {
        this.recordVibratePattern(pattern, repeat);
    }

    @Implementation(minSdk=18, maxSdk=20)
    protected void vibrate(int owningUid, String owningPackage, long[] pattern, int repeat) {
        this.recordVibratePattern(pattern, repeat);
    }

    @Implementation(minSdk=21, maxSdk=25)
    protected void vibrate(int uid, String opPkg, long[] pattern, int repeat, AudioAttributes attributes) {
        this.recordVibratePattern(pattern, repeat);
    }

    @Implementation(maxSdk=17)
    public void vibrate(long milliseconds) {
        this.recordVibrate(milliseconds);
    }

    @Implementation(minSdk=18, maxSdk=20)
    public void vibrate(int owningUid, String owningPackage, long milliseconds) {
        this.recordVibrate(milliseconds);
    }

    @Implementation(minSdk=21, maxSdk=25)
    protected void vibrate(int uid, String opPkg, long milliseconds, AudioAttributes attributes) {
        this.recordVibrate(milliseconds);
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected void vibrate(int uid, String opPkg, VibrationEffect effect, AudioAttributes attributes) {
        this.vibrate(uid, opPkg, effect, null, attributes);
    }

    @Implementation(minSdk=10000)
    protected void vibrate(int uid, String opPkg, VibrationEffect effect, String reason, AudioAttributes attributes) {
        if (effect instanceof VibrationEffect.Waveform) {
            VibrationEffect.Waveform waveform = (VibrationEffect.Waveform)effect;
            this.recordVibratePattern(waveform.getTimings(), waveform.getRepeatIndex());
        } else {
            VibrationEffect.OneShot oneShot = (VibrationEffect.OneShot)effect;
            long timing = RuntimeEnvironment.getApiLevel() >= 28 ? oneShot.getDuration() : ((Long)ReflectionHelpers.callInstanceMethod((Object)oneShot, (String)"getTiming", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0])).longValue();
            this.recordVibrate(timing);
        }
    }

    private void recordVibrate(long milliseconds) {
        this.vibrating = true;
        this.milliseconds = milliseconds;
        this.handler.removeCallbacks(this.stopVibratingRunnable);
        this.handler.postDelayed(this.stopVibratingRunnable, this.milliseconds);
    }

    private void recordVibratePattern(long[] pattern, int repeat) {
        this.vibrating = true;
        this.pattern = pattern;
        this.repeat = repeat;
        this.handler.removeCallbacks(this.stopVibratingRunnable);
        if (repeat < 0) {
            long endDelayMillis = 0L;
            for (long t : pattern) {
                endDelayMillis += t;
            }
            this.handler.postDelayed(this.stopVibratingRunnable, endDelayMillis);
        }
    }

    @Implementation
    protected void cancel() {
        this.cancelled = true;
        this.vibrating = false;
        this.handler.removeCallbacks(this.stopVibratingRunnable);
    }
}

