/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=KeyCharacterMap.class)
public class ShadowKeyCharacterMap {
    private static final Map<Character, Integer> CHAR_TO_KEY_CODE = new HashMap<Character, Integer>();
    private static final Map<Integer, Character> KEY_CODE_TO_CHAR = new HashMap<Integer, Character>();

    @Implementation
    protected static KeyCharacterMap load(int deviceId) {
        return (KeyCharacterMap)ReflectionHelpers.callConstructor(KeyCharacterMap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    @Implementation
    protected KeyEvent[] getEvents(char[] charArray) {
        int eventsPerChar = 2;
        KeyEvent[] events = new KeyEvent[charArray.length * eventsPerChar];
        for (int i = 0; i < charArray.length; ++i) {
            events[eventsPerChar * i] = this.getDownEvent(charArray[i]);
            events[eventsPerChar * i + 1] = this.getUpEvent(charArray[i]);
        }
        return events;
    }

    @Implementation
    protected int getKeyboardType() {
        return 4;
    }

    @Implementation
    protected int get(int keyCode, int metaState) {
        return Character.toLowerCase(KEY_CODE_TO_CHAR.get(keyCode).charValue());
    }

    public KeyEvent getDownEvent(char a) {
        return new KeyEvent(0, CHAR_TO_KEY_CODE.get(Character.valueOf(Character.toUpperCase(a))).intValue());
    }

    public KeyEvent getUpEvent(char a) {
        return new KeyEvent(1, CHAR_TO_KEY_CODE.get(Character.valueOf(Character.toUpperCase(a))).intValue());
    }

    static {
        CHAR_TO_KEY_CODE.put(Character.valueOf('0'), 7);
        CHAR_TO_KEY_CODE.put(Character.valueOf('1'), 8);
        CHAR_TO_KEY_CODE.put(Character.valueOf('2'), 9);
        CHAR_TO_KEY_CODE.put(Character.valueOf('3'), 10);
        CHAR_TO_KEY_CODE.put(Character.valueOf('4'), 11);
        CHAR_TO_KEY_CODE.put(Character.valueOf('5'), 12);
        CHAR_TO_KEY_CODE.put(Character.valueOf('6'), 13);
        CHAR_TO_KEY_CODE.put(Character.valueOf('7'), 14);
        CHAR_TO_KEY_CODE.put(Character.valueOf('8'), 15);
        CHAR_TO_KEY_CODE.put(Character.valueOf('9'), 16);
        CHAR_TO_KEY_CODE.put(Character.valueOf('A'), 29);
        CHAR_TO_KEY_CODE.put(Character.valueOf('B'), 30);
        CHAR_TO_KEY_CODE.put(Character.valueOf('C'), 31);
        CHAR_TO_KEY_CODE.put(Character.valueOf('D'), 32);
        CHAR_TO_KEY_CODE.put(Character.valueOf('E'), 33);
        CHAR_TO_KEY_CODE.put(Character.valueOf('F'), 34);
        CHAR_TO_KEY_CODE.put(Character.valueOf('G'), 35);
        CHAR_TO_KEY_CODE.put(Character.valueOf('H'), 36);
        CHAR_TO_KEY_CODE.put(Character.valueOf('I'), 37);
        CHAR_TO_KEY_CODE.put(Character.valueOf('J'), 38);
        CHAR_TO_KEY_CODE.put(Character.valueOf('K'), 39);
        CHAR_TO_KEY_CODE.put(Character.valueOf('L'), 40);
        CHAR_TO_KEY_CODE.put(Character.valueOf('M'), 41);
        CHAR_TO_KEY_CODE.put(Character.valueOf('N'), 42);
        CHAR_TO_KEY_CODE.put(Character.valueOf('O'), 43);
        CHAR_TO_KEY_CODE.put(Character.valueOf('P'), 44);
        CHAR_TO_KEY_CODE.put(Character.valueOf('Q'), 45);
        CHAR_TO_KEY_CODE.put(Character.valueOf('R'), 46);
        CHAR_TO_KEY_CODE.put(Character.valueOf('S'), 47);
        CHAR_TO_KEY_CODE.put(Character.valueOf('T'), 48);
        CHAR_TO_KEY_CODE.put(Character.valueOf('U'), 49);
        CHAR_TO_KEY_CODE.put(Character.valueOf('V'), 50);
        CHAR_TO_KEY_CODE.put(Character.valueOf('W'), 51);
        CHAR_TO_KEY_CODE.put(Character.valueOf('X'), 52);
        CHAR_TO_KEY_CODE.put(Character.valueOf('Y'), 53);
        CHAR_TO_KEY_CODE.put(Character.valueOf('Z'), 54);
        CHAR_TO_KEY_CODE.put(Character.valueOf(' '), 62);
        KEY_CODE_TO_CHAR.put(7, Character.valueOf('0'));
        KEY_CODE_TO_CHAR.put(8, Character.valueOf('1'));
        KEY_CODE_TO_CHAR.put(9, Character.valueOf('2'));
        KEY_CODE_TO_CHAR.put(10, Character.valueOf('3'));
        KEY_CODE_TO_CHAR.put(11, Character.valueOf('4'));
        KEY_CODE_TO_CHAR.put(12, Character.valueOf('5'));
        KEY_CODE_TO_CHAR.put(13, Character.valueOf('6'));
        KEY_CODE_TO_CHAR.put(14, Character.valueOf('7'));
        KEY_CODE_TO_CHAR.put(15, Character.valueOf('8'));
        KEY_CODE_TO_CHAR.put(16, Character.valueOf('9'));
        KEY_CODE_TO_CHAR.put(29, Character.valueOf('A'));
        KEY_CODE_TO_CHAR.put(30, Character.valueOf('B'));
        KEY_CODE_TO_CHAR.put(31, Character.valueOf('C'));
        KEY_CODE_TO_CHAR.put(32, Character.valueOf('D'));
        KEY_CODE_TO_CHAR.put(33, Character.valueOf('E'));
        KEY_CODE_TO_CHAR.put(34, Character.valueOf('F'));
        KEY_CODE_TO_CHAR.put(35, Character.valueOf('G'));
        KEY_CODE_TO_CHAR.put(36, Character.valueOf('H'));
        KEY_CODE_TO_CHAR.put(37, Character.valueOf('I'));
        KEY_CODE_TO_CHAR.put(38, Character.valueOf('J'));
        KEY_CODE_TO_CHAR.put(39, Character.valueOf('K'));
        KEY_CODE_TO_CHAR.put(40, Character.valueOf('L'));
        KEY_CODE_TO_CHAR.put(41, Character.valueOf('M'));
        KEY_CODE_TO_CHAR.put(42, Character.valueOf('N'));
        KEY_CODE_TO_CHAR.put(43, Character.valueOf('O'));
        KEY_CODE_TO_CHAR.put(44, Character.valueOf('P'));
        KEY_CODE_TO_CHAR.put(45, Character.valueOf('Q'));
        KEY_CODE_TO_CHAR.put(46, Character.valueOf('R'));
        KEY_CODE_TO_CHAR.put(47, Character.valueOf('S'));
        KEY_CODE_TO_CHAR.put(48, Character.valueOf('T'));
        KEY_CODE_TO_CHAR.put(49, Character.valueOf('U'));
        KEY_CODE_TO_CHAR.put(50, Character.valueOf('V'));
        KEY_CODE_TO_CHAR.put(51, Character.valueOf('W'));
        KEY_CODE_TO_CHAR.put(52, Character.valueOf('X'));
        KEY_CODE_TO_CHAR.put(53, Character.valueOf('Y'));
        KEY_CODE_TO_CHAR.put(54, Character.valueOf('Z'));
        KEY_CODE_TO_CHAR.put(62, Character.valueOf(' '));
    }
}

