/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.Configuration;
import android.hardware.display.DisplayManager;
import android.hardware.display.DisplayManagerGlobal;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.DisplayInfo;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.android.Bootstrap;
import org.robolectric.android.internal.DisplayConfig;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowDisplayManagerGlobal;
import org.robolectric.util.Consumer;

@Implements(value=DisplayManager.class, minSdk=17)
public class ShadowDisplayManager {
    public static int addDisplay(String qualifiersStr) {
        return ShadowDisplayManager.getShadowDisplayManagerGlobal().addDisplay(ShadowDisplayManager.createDisplayInfo(qualifiersStr, null));
    }

    public static void configureDefaultDisplay(Configuration configuration, DisplayMetrics displayMetrics) {
        ShadowDisplayManagerGlobal shadowDisplayManagerGlobal = ShadowDisplayManager.getShadowDisplayManagerGlobal();
        if (DisplayManagerGlobal.getInstance().getDisplayIds().length != 0) {
            throw new IllegalStateException("this method should only be called by Robolectric");
        }
        shadowDisplayManagerGlobal.addDisplay(ShadowDisplayManager.createDisplayInfo(configuration, displayMetrics));
    }

    private static DisplayInfo createDisplayInfo(Configuration configuration, DisplayMetrics displayMetrics) {
        int widthPx = (int)((float)configuration.screenWidthDp * displayMetrics.density);
        int heightPx = (int)((float)configuration.screenHeightDp * displayMetrics.density);
        DisplayInfo displayInfo = new DisplayInfo();
        displayInfo.name = "Built-in screen";
        if (Build.VERSION.SDK_INT >= 23) {
            displayInfo.uniqueId = "screen0";
        }
        displayInfo.appWidth = widthPx;
        displayInfo.appHeight = heightPx;
        ShadowDisplayManager.fixNominalDimens(displayInfo);
        displayInfo.logicalWidth = widthPx;
        displayInfo.logicalHeight = heightPx;
        int n = displayInfo.rotation = configuration.orientation == 1 ? 0 : 1;
        if (Build.VERSION.SDK_INT >= 23) {
            displayInfo.modeId = 0;
            displayInfo.defaultModeId = 0;
            displayInfo.supportedModes = new Display.Mode[]{new Display.Mode(0, widthPx, heightPx, 60.0f)};
        }
        displayInfo.logicalDensityDpi = displayMetrics.densityDpi;
        displayInfo.physicalXDpi = displayMetrics.densityDpi;
        displayInfo.physicalYDpi = displayMetrics.densityDpi;
        if (Build.VERSION.SDK_INT >= 21) {
            displayInfo.state = 2;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            displayInfo.getAppMetrics(displayMetrics);
        }
        return displayInfo;
    }

    private static void fixNominalDimens(DisplayInfo displayInfo) {
        int smallest = Math.min(displayInfo.appWidth, displayInfo.appHeight);
        int largest = Math.max(displayInfo.appWidth, displayInfo.appHeight);
        displayInfo.smallestNominalAppWidth = smallest;
        displayInfo.smallestNominalAppHeight = smallest;
        displayInfo.largestNominalAppWidth = largest;
        displayInfo.largestNominalAppHeight = largest;
    }

    private static DisplayInfo createDisplayInfo(String qualifiersStr, DisplayInfo baseDisplayInfo) {
        Configuration configuration = new Configuration();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        if (qualifiersStr.startsWith("+") && baseDisplayInfo != null) {
            configuration.orientation = baseDisplayInfo.rotation == 0 || baseDisplayInfo.rotation == 2 ? 1 : 2;
            configuration.screenWidthDp = baseDisplayInfo.logicalWidth * 160 / baseDisplayInfo.logicalDensityDpi;
            configuration.screenHeightDp = baseDisplayInfo.logicalHeight * 160 / baseDisplayInfo.logicalDensityDpi;
            configuration.densityDpi = baseDisplayInfo.logicalDensityDpi;
            displayMetrics.densityDpi = baseDisplayInfo.logicalDensityDpi;
            displayMetrics.density = (float)baseDisplayInfo.logicalDensityDpi * 0.00625f;
        }
        Bootstrap.applyQualifiers(qualifiersStr, RuntimeEnvironment.getApiLevel(), configuration, displayMetrics);
        return ShadowDisplayManager.createDisplayInfo(configuration, displayMetrics);
    }

    public static void changeDisplay(int displayId, String qualifiersStr) {
        DisplayInfo baseDisplayInfo = DisplayManagerGlobal.getInstance().getDisplayInfo(displayId);
        DisplayInfo displayInfo = ShadowDisplayManager.createDisplayInfo(qualifiersStr, baseDisplayInfo);
        ShadowDisplayManager.getShadowDisplayManagerGlobal().changeDisplay(displayId, displayInfo);
    }

    static void changeDisplay(int displayId, Consumer<DisplayConfig> consumer) {
        DisplayInfo displayInfo = DisplayManagerGlobal.getInstance().getDisplayInfo(displayId);
        if (displayInfo != null) {
            DisplayConfig displayConfig = new DisplayConfig(displayInfo);
            consumer.accept((Object)displayConfig);
            displayConfig.copyTo(displayInfo);
            ShadowDisplayManager.fixNominalDimens(displayInfo);
        }
        ShadowDisplayManager.getShadowDisplayManagerGlobal().changeDisplay(displayId, displayInfo);
    }

    public static void removeDisplay(int displayId) {
        ShadowDisplayManager.getShadowDisplayManagerGlobal().removeDisplay(displayId);
    }

    public static float getSaturationLevel() {
        return ShadowDisplayManager.getShadowDisplayManagerGlobal().getSaturationLevel();
    }

    public static void setSaturationLevel(float level) {
        DisplayManagerGlobal.getInstance().setSaturationLevel(level);
    }

    private static ShadowDisplayManagerGlobal getShadowDisplayManagerGlobal() {
        if (Build.VERSION.SDK_INT < 17) {
            throw new UnsupportedOperationException("multiple displays not supported in Jelly Bean");
        }
        return (ShadowDisplayManagerGlobal)Shadow.extract((Object)DisplayManagerGlobal.getInstance());
    }
}

