/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.backup.BackupManager;
import android.app.backup.IBackupManagerMonitor;
import android.app.backup.IRestoreObserver;
import android.app.backup.IRestoreSession;
import android.app.backup.RestoreSession;
import android.app.backup.RestoreSet;
import android.content.Context;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=BackupManager.class)
public class ShadowBackupManager {
    @RealObject
    private BackupManager realBackupManager;
    Context context;
    private static BackupManagerServiceState serviceState = new BackupManagerServiceState();

    @Resetter
    public static void reset() {
        serviceState = new BackupManagerServiceState();
    }

    @Implementation
    protected void __constructor__(Context context) {
        this.context = context;
        Shadow.invokeConstructor(BackupManager.class, (Object)this.realBackupManager, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context)});
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected void setBackupEnabled(boolean isEnabled) {
        this.enforceBackupPermission("setBackupEnabled");
        ShadowBackupManager.serviceState.backupEnabled = isEnabled;
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected boolean isBackupEnabled() {
        this.enforceBackupPermission("isBackupEnabled");
        return ShadowBackupManager.serviceState.backupEnabled;
    }

    @Implementation
    @HiddenApi
    protected RestoreSession beginRestoreSession() {
        this.enforceBackupPermission("beginRestoreSession");
        return (RestoreSession)ReflectionHelpers.callConstructor(RestoreSession.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)this.context), ReflectionHelpers.ClassParameter.from(IRestoreSession.class, (Object)new FakeRestoreSession())});
    }

    public long getPackageRestoreToken(String packageName) {
        Long token = ShadowBackupManager.serviceState.restoredPackages.get(packageName);
        return token != null ? token : 0L;
    }

    public void addAvailableRestoreSets(long restoreToken, List<String> packages) {
        ShadowBackupManager.serviceState.restoreData.put(restoreToken, packages);
    }

    private void enforceBackupPermission(String message) {
        RuntimeEnvironment.application.enforceCallingOrSelfPermission("android.permission.BACKUP", message);
    }

    private static interface RemoteRunnable {
        public void run() throws RemoteException;
    }

    private static class BackupManagerServiceState {
        boolean backupEnabled = true;
        long lastRestoreToken = 0L;
        final Map<Long, List<String>> restoreData = new HashMap<Long, List<String>>();
        final Map<String, Long> restoredPackages = new HashMap<String, Long>();

        private BackupManagerServiceState() {
        }
    }

    private class FakeRestoreSession
    implements IRestoreSession {
        private FakeRestoreSession() {
        }

        public int getAvailableRestoreSets(IRestoreObserver observer) throws RemoteException {
            return this.getAvailableRestoreSets(observer, null);
        }

        public int getAvailableRestoreSets(IRestoreObserver observer, IBackupManagerMonitor monitor) throws RemoteException {
            this.post(() -> {
                Set<Long> restoreTokens = serviceState.restoreData.keySet();
                HashSet<RestoreSet> restoreSets = new HashSet<RestoreSet>();
                for (long token : restoreTokens) {
                    restoreSets.add(new RestoreSet("RestoreSet-" + token, "device", token));
                }
                observer.restoreSetsAvailable(restoreSets.toArray(new RestoreSet[restoreSets.size()]));
            });
            return 0;
        }

        public int restoreAll(long token, IRestoreObserver observer) throws RemoteException {
            return this.restoreAll(token, observer, null);
        }

        public int restoreAll(long token, IRestoreObserver observer, IBackupManagerMonitor monitor) throws RemoteException {
            return this.restoreSome(token, observer, monitor, null);
        }

        public int restoreSome(long token, IRestoreObserver observer, String[] packages) throws RemoteException {
            return this.restoreSome(token, observer, null, packages);
        }

        public int restoreSome(long token, IRestoreObserver observer, IBackupManagerMonitor monitor, String[] packages) throws RemoteException {
            ArrayList restorePackages = new ArrayList(serviceState.restoreData.get(token));
            if (packages != null) {
                restorePackages.retainAll(Arrays.asList(packages));
            }
            this.post(() -> observer.restoreStarting(restorePackages.size()));
            int i = 0;
            while (i < restorePackages.size()) {
                int index = i++;
                this.post(() -> observer.onUpdate(index, (String)restorePackages.get(index)));
                serviceState.restoredPackages.put((String)restorePackages.get(index), token);
            }
            this.post(() -> observer.restoreFinished(0));
            serviceState.lastRestoreToken = token;
            return 0;
        }

        public int restorePackage(String packageName, IRestoreObserver observer) throws RemoteException {
            return this.restorePackage(packageName, observer, null);
        }

        public int restorePackage(String packageName, IRestoreObserver observer, IBackupManagerMonitor monitor) throws RemoteException {
            if (serviceState.lastRestoreToken == 0L) {
                return -1;
            }
            List<String> restorePackages = serviceState.restoreData.get(serviceState.lastRestoreToken);
            if (!restorePackages.contains(packageName)) {
                return -2002;
            }
            this.post(() -> observer.restoreStarting(1));
            this.post(() -> observer.onUpdate(0, packageName));
            serviceState.restoredPackages.put(packageName, serviceState.lastRestoreToken);
            this.post(() -> observer.restoreFinished(0));
            return 0;
        }

        public void endRestoreSession() throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }

        private void post(RemoteRunnable runnable) {
            new Handler(Looper.getMainLooper()).post(() -> {
                try {
                    runnable.run();
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }
}

