/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.ActivityManager;
import android.app.IActivityManager;
import android.content.pm.ConfigurationInfo;
import android.os.Process;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=ActivityManager.class)
public class ShadowActivityManager {
    private int memoryClass = 16;
    private String backgroundPackage;
    private ActivityManager.MemoryInfo memoryInfo;
    private final List<ActivityManager.AppTask> appTasks = new CopyOnWriteArrayList<ActivityManager.AppTask>();
    private final List<ActivityManager.RunningTaskInfo> tasks = new CopyOnWriteArrayList<ActivityManager.RunningTaskInfo>();
    private final List<ActivityManager.RunningServiceInfo> services = new CopyOnWriteArrayList<ActivityManager.RunningServiceInfo>();
    private static List<ActivityManager.RunningAppProcessInfo> processes = new CopyOnWriteArrayList<ActivityManager.RunningAppProcessInfo>();
    @RealObject
    private ActivityManager realObject;
    private Boolean isLowRamDeviceOverride = null;
    private int lockTaskModeState = 0;

    public ShadowActivityManager() {
        ActivityManager.RunningAppProcessInfo processInfo = new ActivityManager.RunningAppProcessInfo();
        ShadowActivityManager.fillInProcessInfo(processInfo);
        processInfo.processName = RuntimeEnvironment.application.getPackageName();
        processInfo.pkgList = new String[]{RuntimeEnvironment.application.getPackageName()};
        processes.add(processInfo);
    }

    @Implementation
    protected int getMemoryClass() {
        return this.memoryClass;
    }

    @Implementation
    protected static boolean isUserAMonkey() {
        return false;
    }

    @Implementation
    protected List<ActivityManager.RunningTaskInfo> getRunningTasks(int maxNum) {
        return this.tasks;
    }

    @Implementation(minSdk=21)
    protected List<ActivityManager.AppTask> getAppTasks() {
        return this.appTasks;
    }

    @Implementation
    protected List<ActivityManager.RunningServiceInfo> getRunningServices(int maxNum) {
        return this.services;
    }

    @Implementation
    protected List<ActivityManager.RunningAppProcessInfo> getRunningAppProcesses() {
        if (processes.isEmpty()) {
            return null;
        }
        return processes;
    }

    @Implementation
    protected static void getMyMemoryState(ActivityManager.RunningAppProcessInfo inState) {
        ShadowActivityManager.fillInProcessInfo(inState);
        for (ActivityManager.RunningAppProcessInfo info : processes) {
            if (info.pid != Process.myPid()) continue;
            inState.importance = info.importance;
            inState.lru = info.lru;
            inState.importanceReasonCode = info.importanceReasonCode;
            inState.importanceReasonPid = info.importanceReasonPid;
            inState.lastTrimLevel = info.lastTrimLevel;
            inState.pkgList = info.pkgList;
            inState.processName = info.processName;
        }
    }

    private static void fillInProcessInfo(ActivityManager.RunningAppProcessInfo processInfo) {
        processInfo.pid = Process.myPid();
        processInfo.uid = Process.myUid();
    }

    @Implementation
    protected void killBackgroundProcesses(String packageName) {
        this.backgroundPackage = packageName;
    }

    @Implementation
    protected void getMemoryInfo(ActivityManager.MemoryInfo outInfo) {
        if (this.memoryInfo != null) {
            outInfo.availMem = this.memoryInfo.availMem;
            outInfo.lowMemory = this.memoryInfo.lowMemory;
            outInfo.threshold = this.memoryInfo.threshold;
            outInfo.totalMem = this.memoryInfo.totalMem;
        }
    }

    @Implementation
    protected ConfigurationInfo getDeviceConfigurationInfo() {
        return new ConfigurationInfo();
    }

    public void setTasks(List<ActivityManager.RunningTaskInfo> tasks) {
        this.tasks.clear();
        this.tasks.addAll(tasks);
    }

    public void setAppTasks(List<ActivityManager.AppTask> appTasks) {
        this.appTasks.clear();
        this.appTasks.addAll(appTasks);
    }

    public void setServices(List<ActivityManager.RunningServiceInfo> services) {
        this.services.clear();
        this.services.addAll(services);
    }

    public void setProcesses(List<ActivityManager.RunningAppProcessInfo> processes) {
        ShadowActivityManager.processes.clear();
        ShadowActivityManager.processes.addAll(processes);
    }

    public String getBackgroundPackage() {
        return this.backgroundPackage;
    }

    public void setMemoryClass(int memoryClass) {
        this.memoryClass = memoryClass;
    }

    public void setMemoryInfo(ActivityManager.MemoryInfo memoryInfo) {
        this.memoryInfo = memoryInfo;
    }

    @Implementation(minSdk=26)
    protected static IActivityManager getService() {
        return (IActivityManager)ReflectionHelpers.createNullProxy(IActivityManager.class);
    }

    @Implementation(minSdk=19)
    protected boolean isLowRamDevice() {
        if (this.isLowRamDeviceOverride != null) {
            return this.isLowRamDeviceOverride;
        }
        return (Boolean)Shadow.directlyOn((Object)this.realObject, ActivityManager.class, (String)"isLowRamDevice", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    public void setIsLowRamDevice(boolean isLowRamDevice) {
        this.isLowRamDeviceOverride = isLowRamDevice;
    }

    @Implementation(minSdk=23)
    protected int getLockTaskModeState() {
        return this.lockTaskModeState;
    }

    @Implementation(minSdk=21)
    protected boolean isInLockTaskMode() {
        return this.getLockTaskModeState() != 0;
    }

    public void setLockTaskModeState(int lockTaskModeState) {
        this.lockTaskModeState = lockTaskModeState;
    }

    @Resetter
    public static void reset() {
        processes.clear();
    }
}

