/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.art;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.roaringbitmap.art.Node;
import org.roaringbitmap.art.NodeType;
import org.roaringbitmap.longlong.LongUtils;

public class LeafNode
extends Node {
    private int keyHigh;
    private char keyLow;
    long containerIdx;
    public static final int LEAF_NODE_KEY_LENGTH_IN_BYTES = 6;

    public LeafNode(byte[] key, long containerIdx) {
        this.setKeyFromShifted(LongUtils.fromKey(key));
        this.containerIdx = containerIdx;
    }

    public LeafNode(long key, long containerIdx) {
        this.setKeyFromShifted(key);
        this.containerIdx = containerIdx;
    }

    @Override
    protected LeafNode clone() {
        return new LeafNode(this.getKey(), this.containerIdx);
    }

    @Override
    public void serializeNodeBody(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.keyHigh);
        dataOutput.writeShort(this.keyLow);
        dataOutput.writeLong(Long.reverseBytes(this.containerIdx));
    }

    @Override
    public void serializeNodeBody(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            byteBuffer.putInt(this.keyHigh);
            byteBuffer.putChar(this.keyLow);
        } else {
            byteBuffer.putInt(Integer.reverseBytes(this.keyHigh));
            byteBuffer.putChar(Character.reverseBytes(this.keyLow));
        }
        byteBuffer.putLong(this.containerIdx);
    }

    @Override
    public void deserializeNodeBody(DataInput dataInput) throws IOException {
        this.keyHigh = dataInput.readInt();
        this.keyLow = dataInput.readChar();
        this.containerIdx = Long.reverseBytes(dataInput.readLong());
    }

    @Override
    public void deserializeNodeBody(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            this.keyHigh = byteBuffer.getInt();
            this.keyLow = byteBuffer.getChar();
        } else {
            this.keyHigh = Integer.reverseBytes(byteBuffer.getInt());
            this.keyLow = Character.reverseBytes(byteBuffer.getChar());
        }
        this.containerIdx = byteBuffer.getLong();
    }

    @Override
    public int serializeNodeBodySizeInBytes() {
        return 14;
    }

    public long getContainerIdx() {
        return this.containerIdx;
    }

    public byte[] getKeyBytes() {
        return LongUtils.highPart(this.getKey() << 16);
    }

    public long getKey() {
        return ((long)this.keyHigh & 0xFFFFFFFFL) << 16 | (long)this.keyLow & 0xFFFFL;
    }

    private void setKeyFromShifted(long key) {
        this.keyHigh = (int)(key >> 32);
        this.keyLow = (char)(key >> 16);
    }

    @Override
    protected void serializeHeader(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte((byte)NodeType.LEAF_NODE.ordinal());
        dataOutput.writeShort(0);
        dataOutput.writeByte(0);
    }

    @Override
    protected void serializeHeader(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.put((byte)NodeType.LEAF_NODE.ordinal());
        byteBuffer.putShort((short)0);
        byteBuffer.put((byte)0);
    }

    public String toString() {
        return "LeafNode{key=" + Long.toHexString(this.getKey()) + ", containerIdx=" + this.containerIdx + '}';
    }
}

