/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.art;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.roaringbitmap.art.BranchNode;
import org.roaringbitmap.art.Node;
import org.roaringbitmap.art.Node16;
import org.roaringbitmap.art.NodeType;
import org.roaringbitmap.art.SearchResult;
import org.roaringbitmap.longlong.IntegerUtil;
import org.roaringbitmap.longlong.LongUtils;

public class Node4
extends BranchNode {
    int key = 0;
    Node[] children = new Node[4];

    public Node4(int compressedPrefixSize) {
        super(compressedPrefixSize);
    }

    @Override
    protected Node4 clone() {
        Node4 clone = new Node4(this.prefixLength());
        clone.key = this.key;
        this.postClone(clone, this.children, clone.children);
        return clone;
    }

    @Override
    protected NodeType nodeType() {
        return NodeType.NODE4;
    }

    @Override
    public int getChildPos(byte k) {
        for (int i = 0; i < this.count; ++i) {
            int shiftLeftLen = (3 - i) * 8;
            byte v = (byte)(this.key >> shiftLeftLen);
            if (v != k) continue;
            return i;
        }
        return -1;
    }

    @Override
    public SearchResult getNearestChildPos(byte k) {
        byte[] firstBytes = IntegerUtil.toBDBytes(this.key);
        return Node4.binarySearchWithResult(firstBytes, 0, this.count, k);
    }

    @Override
    public byte getChildKey(int pos) {
        int shiftLeftLen = (3 - pos) * 8;
        byte v = (byte)(this.key >> shiftLeftLen);
        return v;
    }

    @Override
    public Node getChild(int pos) {
        return this.children[pos];
    }

    @Override
    public Node getChildAtKey(byte key) {
        int pos = this.getChildPos(key);
        return pos != -1 ? this.children[pos] : null;
    }

    @Override
    public void replaceNode(int pos, Node freshOne) {
        this.children[pos] = freshOne;
    }

    @Override
    public int getMinPos() {
        return 0;
    }

    @Override
    public int getNextLargerPos(int pos) {
        if (pos == -1) {
            return 0;
        }
        return ++pos < this.count ? pos : -1;
    }

    @Override
    public int getMaxPos() {
        return this.count - 1;
    }

    @Override
    public int getNextSmallerPos(int pos) {
        if (pos == -1) {
            return this.count - 1;
        }
        return --pos >= 0 ? pos : -1;
    }

    @Override
    protected BranchNode insert(Node childNode, byte key) {
        if (this.count < 4) {
            this.key = IntegerUtil.setByte(this.key, key, this.count);
            this.children[this.count] = childNode;
            this.count = (short)(this.count + 1);
            Node4.insertionSort(this);
            return this;
        }
        Node16 node16 = new Node16(this.prefixLength());
        node16.count = (short)4;
        node16.firstV = LongUtils.initWithFirst4Byte(this.key);
        System.arraycopy(this.children, 0, node16.children, 0, 4);
        Node4.copyPrefix(this, node16);
        BranchNode freshOne = node16.insert(childNode, key);
        return freshOne;
    }

    @Override
    public Node remove(int pos) {
        assert (pos < this.count);
        this.count = (short)(this.count - 1);
        this.key = IntegerUtil.shiftLeftFromSpecifiedPosition(this.key, pos, 4 - pos - 1);
        while (pos < this.count) {
            this.children[pos] = this.children[pos + 1];
            ++pos;
        }
        this.children[pos] = null;
        if (this.count == 1) {
            Node childNode = this.children[0];
            if (childNode instanceof BranchNode) {
                BranchNode child = (BranchNode)childNode;
                byte childPrefixLength = child.prefixLength();
                byte thisPrefixLength = this.prefixLength();
                byte newLength = (byte)(childPrefixLength + thisPrefixLength + 1);
                byte[] newPrefix = new byte[newLength];
                System.arraycopy(this.prefix, 0, newPrefix, 0, thisPrefixLength);
                newPrefix[thisPrefixLength] = IntegerUtil.firstByte(this.key);
                System.arraycopy(child.prefix, 0, newPrefix, thisPrefixLength + 1, childPrefixLength);
                child.prefix = newPrefix;
            }
            return childNode;
        }
        return this;
    }

    @Override
    public void serializeNodeBody(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(Integer.reverseBytes(this.key));
    }

    @Override
    public void serializeNodeBody(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.putInt(this.key);
    }

    @Override
    public void deserializeNodeBody(DataInput dataInput) throws IOException {
        int v = dataInput.readInt();
        this.key = Integer.reverseBytes(v);
    }

    @Override
    public void deserializeNodeBody(ByteBuffer byteBuffer) throws IOException {
        this.key = byteBuffer.getInt();
    }

    @Override
    public int serializeNodeBodySizeInBytes() {
        return 4;
    }

    @Override
    public void replaceChildren(Node[] children) {
        System.arraycopy(children, 0, this.children, 0, this.count);
    }

    private static void insertionSort(Node4 node4) {
        byte[] key = IntegerUtil.toBDBytes(node4.key);
        byte[] sortedKey = Node4.sortSmallByteArray(key, node4.children, 0, node4.count - 1);
        node4.key = IntegerUtil.fromBDBytes(sortedKey);
    }
}

