/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.art;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.roaringbitmap.art.BranchNode;
import org.roaringbitmap.art.Node;
import org.roaringbitmap.art.Node4;
import org.roaringbitmap.art.Node48;
import org.roaringbitmap.art.NodeType;
import org.roaringbitmap.art.SearchResult;
import org.roaringbitmap.longlong.LongUtils;

public class Node16
extends BranchNode {
    long firstV = 0L;
    long secondV = 0L;
    Node[] children = new Node[16];

    public Node16(int compressionLength) {
        super(compressionLength);
    }

    @Override
    protected Node16 clone() {
        Node16 clone = new Node16(this.prefixLength());
        clone.firstV = this.firstV;
        clone.secondV = this.secondV;
        this.postClone(clone, this.children, clone.children);
        return clone;
    }

    @Override
    protected NodeType nodeType() {
        return NodeType.NODE16;
    }

    @Override
    public int getChildPos(byte k) {
        byte[] firstBytes = LongUtils.toBDBytes(this.firstV);
        if (this.count <= 8) {
            return Node16.binarySearch(firstBytes, 0, this.count, k);
        }
        int pos = Node16.binarySearch(firstBytes, 0, 8, k);
        if (pos != -1) {
            return pos;
        }
        byte[] secondBytes = LongUtils.toBDBytes(this.secondV);
        pos = Node16.binarySearch(secondBytes, 0, this.count - 8, k);
        if (pos != -1) {
            return 8 + pos;
        }
        return -1;
    }

    @Override
    public Node getChildAtKey(byte key) {
        int pos = this.getChildPos(key);
        return pos != -1 ? this.children[pos] : null;
    }

    @Override
    public SearchResult getNearestChildPos(byte k) {
        byte[] firstBytes = LongUtils.toBDBytes(this.firstV);
        if (this.count <= 8) {
            return Node16.binarySearchWithResult(firstBytes, 0, this.count, k);
        }
        SearchResult firstResult = Node16.binarySearchWithResult(firstBytes, 0, 8, k);
        if (firstResult.outcome == SearchResult.Outcome.FOUND || firstResult.hasNextLargerPos()) {
            return firstResult;
        }
        byte[] secondBytes = LongUtils.toBDBytes(this.secondV);
        SearchResult secondResult = Node16.binarySearchWithResult(secondBytes, 0, this.count - 8, k);
        switch (secondResult.outcome) {
            case FOUND: {
                return SearchResult.found(8 + secondResult.getKeyPos());
            }
            case NOT_FOUND: {
                int lowPos = secondResult.getNextSmallerPos();
                int highPos = secondResult.getNextLargerPos();
                if (lowPos >= 0) {
                    lowPos += 8;
                }
                if (highPos >= 0) {
                    highPos += 8;
                }
                if (!firstResult.hasNextLargerPos() && !secondResult.hasNextSmallerPos()) {
                    lowPos = firstResult.getNextSmallerPos();
                }
                return SearchResult.notFound(lowPos, highPos);
            }
        }
        throw new IllegalStateException("There only two possible search outcomes");
    }

    @Override
    public byte getChildKey(int pos) {
        if (pos <= 7) {
            int posInLong = pos;
            byte[] firstBytes = LongUtils.toBDBytes(this.firstV);
            return firstBytes[posInLong];
        }
        int posInLong = pos - 8;
        byte[] secondBytes = LongUtils.toBDBytes(this.secondV);
        return secondBytes[posInLong];
    }

    @Override
    public Node getChild(int pos) {
        return this.children[pos];
    }

    @Override
    public void replaceNode(int pos, Node freshOne) {
        this.children[pos] = freshOne;
    }

    @Override
    public int getMinPos() {
        return 0;
    }

    @Override
    public int getNextLargerPos(int pos) {
        if (pos == -1) {
            return 0;
        }
        return ++pos < this.count ? pos : -1;
    }

    @Override
    public int getMaxPos() {
        return this.count - 1;
    }

    @Override
    public int getNextSmallerPos(int pos) {
        if (pos == -1) {
            return this.count - 1;
        }
        return --pos >= 0 ? pos : -1;
    }

    @Override
    protected BranchNode insert(Node child, byte key) {
        if (this.count < 8) {
            byte[] bytes = LongUtils.toBDBytes(this.firstV);
            bytes[this.count] = key;
            this.children[this.count] = child;
            Node16.sortSmallByteArray(bytes, this.children, 0, this.count);
            this.count = (short)(this.count + 1);
            this.firstV = LongUtils.fromBDBytes(bytes);
            return this;
        }
        if (this.count < 16) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN);
            byteBuffer.putLong(this.firstV);
            byteBuffer.putLong(this.secondV);
            byteBuffer.put((int)this.count, key);
            this.children[this.count] = child;
            Node16.sortSmallByteArray(byteBuffer.array(), this.children, 0, this.count);
            this.count = (short)(this.count + 1);
            this.firstV = byteBuffer.getLong(0);
            this.secondV = byteBuffer.getLong(8);
            return this;
        }
        Node48 node48 = new Node48(this.prefixLength());
        for (int i = 0; i < 8; ++i) {
            int unsignedIdx = Byte.toUnsignedInt((byte)(this.firstV >>> (7 - i << 3)));
            Node48.setOneByte(unsignedIdx, (byte)i, node48.childIndex);
            node48.children[i] = this.children[i];
        }
        byte[] secondBytes = LongUtils.toBDBytes(this.secondV);
        for (int i = 8; i < this.count; ++i) {
            byte v = secondBytes[i - 8];
            int unsignedIdx = Byte.toUnsignedInt(v);
            Node48.setOneByte(unsignedIdx, (byte)i, node48.childIndex);
            node48.children[i] = this.children[i];
        }
        Node16.copyPrefix(this, node48);
        node48.count = this.count;
        BranchNode freshOne = node48.insert(child, key);
        return freshOne;
    }

    @Override
    public Node remove(int pos) {
        this.children[pos] = null;
        ByteBuffer byteBuffer = ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN);
        byte[] bytes = byteBuffer.putLong(this.firstV).putLong(this.secondV).array();
        System.arraycopy(bytes, pos + 1, bytes, pos, 16 - pos - 1);
        System.arraycopy(this.children, pos + 1, this.children, pos, 16 - pos - 1);
        this.firstV = byteBuffer.getLong(0);
        this.secondV = byteBuffer.getLong(8);
        this.count = (short)(this.count - 1);
        if (this.count <= 3) {
            Node4 node4 = new Node4(this.prefixLength());
            node4.key = (int)(this.firstV >> 32);
            System.arraycopy(this.children, 0, node4.children, 0, this.count);
            node4.count = this.count;
            Node16.copyPrefix(this, node4);
            return node4;
        }
        return this;
    }

    @Override
    public void serializeNodeBody(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(Long.reverseBytes(this.firstV));
        dataOutput.writeLong(Long.reverseBytes(this.secondV));
    }

    @Override
    public void serializeNodeBody(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.putLong(this.firstV);
        byteBuffer.putLong(this.secondV);
    }

    @Override
    public void deserializeNodeBody(DataInput dataInput) throws IOException {
        this.firstV = Long.reverseBytes(dataInput.readLong());
        this.secondV = Long.reverseBytes(dataInput.readLong());
    }

    @Override
    public void deserializeNodeBody(ByteBuffer byteBuffer) throws IOException {
        this.firstV = byteBuffer.getLong();
        this.secondV = byteBuffer.getLong();
    }

    @Override
    public int serializeNodeBodySizeInBytes() {
        return 16;
    }

    @Override
    public void replaceChildren(Node[] children) {
        System.arraycopy(children, 0, this.children, 0, this.count);
    }
}

