/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableContainerPointer;
import org.roaringbitmap.buffer.MutableRoaringArray;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class BufferParallelAggregation {
    private static final Collector<Map.Entry<Short, List<MappeableContainer>>, MutableRoaringArray, MutableRoaringBitmap> OR = new ContainerCollector(BufferParallelAggregation::or);
    private static final Collector<Map.Entry<Short, List<MappeableContainer>>, MutableRoaringArray, MutableRoaringBitmap> XOR = new ContainerCollector(BufferParallelAggregation::xor);

    public static SortedMap<Short, List<MappeableContainer>> groupByKey(ImmutableRoaringBitmap ... bitmaps) {
        HashMap<Short, ArrayList<MappeableContainer>> grouped = new HashMap<Short, ArrayList<MappeableContainer>>();
        for (ImmutableRoaringBitmap bitmap : bitmaps) {
            MappeableContainerPointer it = bitmap.highLowContainer.getContainerPointer();
            while (null != it.getContainer()) {
                MappeableContainer container = it.getContainer();
                Short key = it.key();
                ArrayList<MappeableContainer> slice = (ArrayList<MappeableContainer>)grouped.get(key);
                if (null == slice) {
                    slice = new ArrayList<MappeableContainer>();
                    grouped.put(key, slice);
                }
                slice.add(container);
                it.advance();
            }
        }
        TreeMap<Short, List<MappeableContainer>> sorted = new TreeMap<Short, List<MappeableContainer>>(BufferUtil::compareUnsigned);
        sorted.putAll(grouped);
        return sorted;
    }

    public static MutableRoaringBitmap or(ImmutableRoaringBitmap ... bitmaps) {
        return BufferParallelAggregation.groupByKey(bitmaps).entrySet().parallelStream().collect(OR);
    }

    public static MutableRoaringBitmap xor(ImmutableRoaringBitmap ... bitmaps) {
        return BufferParallelAggregation.groupByKey(bitmaps).entrySet().parallelStream().collect(XOR);
    }

    private static MappeableContainer or(List<MappeableContainer> containers) {
        MappeableContainer result = containers.get(0).clone();
        if (containers.size() == 1) {
            return result;
        }
        for (int i = 1; i < containers.size(); ++i) {
            result = result.lazyIOR(containers.get(i));
        }
        return result.repairAfterLazy();
    }

    private static MappeableContainer xor(List<MappeableContainer> containers) {
        MappeableContainer result = containers.get(0).clone();
        for (int i = 1; i < containers.size(); ++i) {
            result = result.ixor(containers.get(i));
        }
        return result;
    }

    public static class ContainerCollector
    implements Collector<Map.Entry<Short, List<MappeableContainer>>, MutableRoaringArray, MutableRoaringBitmap> {
        private final Function<List<MappeableContainer>, MappeableContainer> reducer;

        public ContainerCollector(Function<List<MappeableContainer>, MappeableContainer> reducer) {
            this.reducer = reducer;
        }

        @Override
        public Supplier<MutableRoaringArray> supplier() {
            return MutableRoaringArray::new;
        }

        @Override
        public BiConsumer<MutableRoaringArray, Map.Entry<Short, List<MappeableContainer>>> accumulator() {
            return (l, r) -> {
                assert (l.size == 0 || Util.compareUnsigned(l.keys[l.size - 1], (Short)r.getKey()) < 0);
                MappeableContainer container = this.reducer.apply((List<MappeableContainer>)r.getValue());
                if (!container.isEmpty()) {
                    l.append((Short)r.getKey(), container);
                }
            };
        }

        @Override
        public BinaryOperator<MutableRoaringArray> combiner() {
            return (l, r) -> {
                assert (l.size == 0 || r.size == 0 || Util.compareUnsigned(l.keys[l.size - 1], r.keys[0]) < 0);
                l.append((MutableRoaringArray)r);
                return l;
            };
        }

        @Override
        public Function<MutableRoaringArray, MutableRoaringBitmap> finisher() {
            return MutableRoaringBitmap::new;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.noneOf(Collector.Characteristics.class);
        }
    }
}

