/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.OrderedWriter;
import org.roaringbitmap.RoaringArray;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.Util;

public class SparseOrderedWriter
implements OrderedWriter {
    private final RoaringBitmap underlying;
    private Container container;
    private short currentKey;

    public SparseOrderedWriter(RoaringBitmap underlying) {
        this.underlying = underlying;
        this.container = new ArrayContainer();
    }

    public SparseOrderedWriter() {
        this(new RoaringBitmap());
    }

    @Override
    public RoaringBitmap getUnderlying() {
        return this.underlying;
    }

    @Override
    public void add(int value) {
        short key = Util.highbits(value);
        short low = Util.lowbits(value);
        if (key != this.currentKey) {
            if (Util.compareUnsigned(key, this.currentKey) < 0) {
                this.underlying.add(value);
                return;
            }
            this.flush();
        }
        this.currentKey = key;
        this.container = this.container.add(low);
    }

    @Override
    public void flush() {
        if (!this.container.isEmpty()) {
            short key;
            RoaringArray highLowContainer = this.underlying.highLowContainer;
            if (highLowContainer.size > 0 && Util.compareUnsigned(this.currentKey, key = highLowContainer.getKeyAtIndex(highLowContainer.size - 1)) <= 0) {
                throw new IllegalStateException("Cannot write " + this.currentKey + " after " + key);
            }
            highLowContainer.append(this.currentKey, this.container.runOptimize());
            this.currentKey = (short)(this.currentKey + 1);
            this.container = new ArrayContainer();
        }
    }
}

