/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.IntStream;
import org.roaringbitmap.BitmapContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.RoaringArray;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.Util;

public class ParallelAggregation {
    private static final Collector<Map.Entry<Short, List<Container>>, RoaringArray, RoaringBitmap> XOR = new ContainerCollector(ParallelAggregation::xor);
    private static final OrCollector OR = new OrCollector();

    public static SortedMap<Short, List<Container>> groupByKey(RoaringBitmap ... bitmaps) {
        HashMap<Short, ArrayList<Container>> grouped = new HashMap<Short, ArrayList<Container>>();
        for (RoaringBitmap bitmap : bitmaps) {
            RoaringArray ra = bitmap.highLowContainer;
            for (int i = 0; i < ra.size; ++i) {
                Container container = ra.values[i];
                Short key = ra.keys[i];
                ArrayList<Container> slice = (ArrayList<Container>)grouped.get(key);
                if (null == slice) {
                    slice = new ArrayList<Container>();
                    grouped.put(key, slice);
                }
                slice.add(container);
            }
        }
        TreeMap<Short, List<Container>> sorted = new TreeMap<Short, List<Container>>(Util::compareUnsigned);
        sorted.putAll(grouped);
        return sorted;
    }

    public static RoaringBitmap or(RoaringBitmap ... bitmaps) {
        SortedMap<Short, List<Container>> grouped = ParallelAggregation.groupByKey(bitmaps);
        short[] keys = new short[grouped.size()];
        Container[] values = new Container[grouped.size()];
        ArrayList<List<Container>> slices = new ArrayList<List<Container>>(grouped.size());
        int i = 0;
        for (Map.Entry<Short, List<Container>> slice : grouped.entrySet()) {
            keys[i++] = slice.getKey();
            slices.add(slice.getValue());
        }
        IntStream.range(0, i).parallel().forEach(position -> {
            containerArray[position] = ParallelAggregation.or((List)slices.get(position));
        });
        return new RoaringBitmap(new RoaringArray(keys, values, i));
    }

    public static RoaringBitmap xor(RoaringBitmap ... bitmaps) {
        return ParallelAggregation.groupByKey(bitmaps).entrySet().parallelStream().collect(XOR);
    }

    private static Container xor(List<Container> containers) {
        Container result = containers.get(0).clone();
        for (int i = 1; i < containers.size(); ++i) {
            result = result.ixor(containers.get(i));
        }
        return result;
    }

    private static Container or(List<Container> containers) {
        int parallelism;
        if (containers.size() < 16) {
            Container result = containers.get(0).clone();
            for (int i2 = 1; i2 < containers.size(); ++i2) {
                result = result.lazyIOR(containers.get(i2));
            }
            return result.repairAfterLazy();
        }
        if (containers.size() < 512 || (parallelism = ParallelAggregation.availableParallelism()) == 1) {
            Container result = new BitmapContainer(new long[1024], -1);
            for (Container container : containers) {
                result = result.lazyIOR(container);
            }
            return ((Container)result).repairAfterLazy();
        }
        int partitionSize = (containers.size() + parallelism - 1) / parallelism;
        return IntStream.range(0, parallelism).parallel().mapToObj(i -> containers.subList(i * partitionSize, Math.min((i + 1) * partitionSize, containers.size()))).collect(OR);
    }

    private static int availableParallelism() {
        return ForkJoinTask.inForkJoinPool() ? ForkJoinTask.getPool().getParallelism() : ForkJoinPool.getCommonPoolParallelism();
    }

    public static class OrCollector
    implements Collector<List<Container>, Container, Container> {
        @Override
        public Supplier<Container> supplier() {
            return () -> new BitmapContainer(new long[1024], -1);
        }

        @Override
        public BiConsumer<Container, List<Container>> accumulator() {
            return (l, r) -> l.lazyIOR(ParallelAggregation.or(r));
        }

        @Override
        public BinaryOperator<Container> combiner() {
            return Container::lazyIOR;
        }

        @Override
        public Function<Container, Container> finisher() {
            return Container::repairAfterLazy;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.UNORDERED);
        }
    }

    public static class ContainerCollector
    implements Collector<Map.Entry<Short, List<Container>>, RoaringArray, RoaringBitmap> {
        private final Function<List<Container>, Container> reducer;

        public ContainerCollector(Function<List<Container>, Container> reducer) {
            this.reducer = reducer;
        }

        @Override
        public Supplier<RoaringArray> supplier() {
            return RoaringArray::new;
        }

        @Override
        public BiConsumer<RoaringArray, Map.Entry<Short, List<Container>>> accumulator() {
            return (l, r) -> {
                assert (l.size == 0 || Util.compareUnsigned(l.keys[l.size - 1], (Short)r.getKey()) < 0);
                Container container = this.reducer.apply((List<Container>)r.getValue());
                if (!container.isEmpty()) {
                    l.append((Short)r.getKey(), container);
                }
            };
        }

        @Override
        public BinaryOperator<RoaringArray> combiner() {
            return (l, r) -> {
                assert (l.size == 0 || r.size == 0 || Util.compareUnsigned(l.keys[l.size - 1], r.keys[0]) < 0);
                l.append((RoaringArray)r);
                return l;
            };
        }

        @Override
        public Function<RoaringArray, RoaringBitmap> finisher() {
            return RoaringBitmap::new;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.noneOf(Collector.Characteristics.class);
        }
    }
}

