/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.ArrayContainerShortIterator;
import org.roaringbitmap.BitmapContainer;
import org.roaringbitmap.BitmapContainerShortIterator;
import org.roaringbitmap.Container;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.PeekableShortIterator;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.RunContainer;
import org.roaringbitmap.RunContainerShortIterator;
import org.roaringbitmap.Util;

public class IntIteratorFlyweight
implements PeekableIntIterator {
    private int hs;
    private PeekableShortIterator iter;
    private ArrayContainerShortIterator arrIter = new ArrayContainerShortIterator();
    private BitmapContainerShortIterator bitmapIter = new BitmapContainerShortIterator();
    private RunContainerShortIterator runIter = new RunContainerShortIterator();
    private int pos;
    private RoaringBitmap roaringBitmap = null;

    public IntIteratorFlyweight() {
    }

    public IntIteratorFlyweight(RoaringBitmap r) {
        this.wrap(r);
    }

    @Override
    public PeekableIntIterator clone() {
        try {
            IntIteratorFlyweight x = (IntIteratorFlyweight)super.clone();
            x.iter = this.iter.clone();
            return x;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.roaringBitmap.highLowContainer.size();
    }

    @Override
    public int next() {
        int x = this.iter.nextAsInt() | this.hs;
        if (!this.iter.hasNext()) {
            ++this.pos;
            this.nextContainer();
        }
        return x;
    }

    private void nextContainer() {
        if (this.pos < this.roaringBitmap.highLowContainer.size()) {
            Container container = this.roaringBitmap.highLowContainer.getContainerAtIndex(this.pos);
            if (container instanceof BitmapContainer) {
                this.bitmapIter.wrap(((BitmapContainer)container).bitmap);
                this.iter = this.bitmapIter;
            } else if (container instanceof ArrayContainer) {
                this.arrIter.wrap((ArrayContainer)container);
                this.iter = this.arrIter;
            } else {
                this.runIter.wrap((RunContainer)container);
                this.iter = this.runIter;
            }
            this.hs = Util.toIntUnsigned(this.roaringBitmap.highLowContainer.getKeyAtIndex(this.pos)) << 16;
        }
    }

    public void wrap(RoaringBitmap r) {
        this.hs = 0;
        this.pos = 0;
        this.roaringBitmap = r;
        this.nextContainer();
    }

    @Override
    public void advanceIfNeeded(int minval) {
        while (this.hs >>> 16 < minval >>> 16) {
            ++this.pos;
            if (this.pos < this.roaringBitmap.highLowContainer.size()) {
                this.nextContainer();
                continue;
            }
            return;
        }
        this.iter.advanceIfNeeded(Util.lowbits(minval));
    }

    @Override
    public int peekNext() {
        return Util.toIntUnsigned(this.iter.peekNext()) | this.hs;
    }
}

