/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.roaringbitmap.Container;
import org.roaringbitmap.ContainerPointer;
import org.roaringbitmap.RoaringBitmap;

public final class FastAggregation {
    private FastAggregation() {
    }

    public static RoaringBitmap naive_and(RoaringBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new RoaringBitmap();
        }
        RoaringBitmap answer = bitmaps[0].clone();
        for (int k = 1; k < bitmaps.length; ++k) {
            answer.and(bitmaps[k]);
        }
        return answer;
    }

    public static RoaringBitmap naive_and(Iterator<RoaringBitmap> bitmaps) {
        if (!bitmaps.hasNext()) {
            return new RoaringBitmap();
        }
        RoaringBitmap answer = bitmaps.next().clone();
        while (bitmaps.hasNext()) {
            answer.and(bitmaps.next());
        }
        return answer;
    }

    public static RoaringBitmap naive_or(RoaringBitmap ... bitmaps) {
        RoaringBitmap answer = new RoaringBitmap();
        for (int k = 0; k < bitmaps.length; ++k) {
            answer.lazyor(bitmaps[k]);
        }
        answer.repairAfterLazy();
        return answer;
    }

    public static RoaringBitmap naive_or(Iterator<RoaringBitmap> bitmaps) {
        RoaringBitmap answer = new RoaringBitmap();
        while (bitmaps.hasNext()) {
            answer.lazyor(bitmaps.next());
        }
        answer.repairAfterLazy();
        return answer;
    }

    public static RoaringBitmap naive_xor(RoaringBitmap ... bitmaps) {
        RoaringBitmap answer = new RoaringBitmap();
        for (int k = 0; k < bitmaps.length; ++k) {
            answer.xor(bitmaps[k]);
        }
        return answer;
    }

    public static RoaringBitmap naive_xor(Iterator<RoaringBitmap> bitmaps) {
        RoaringBitmap answer = new RoaringBitmap();
        while (bitmaps.hasNext()) {
            answer.xor(bitmaps.next());
        }
        return answer;
    }

    public static RoaringBitmap or(RoaringBitmap ... bitmaps) {
        return FastAggregation.naive_or(bitmaps);
    }

    public static RoaringBitmap or(Iterator<RoaringBitmap> bitmaps) {
        return FastAggregation.naive_or(bitmaps);
    }

    public static RoaringBitmap xor(RoaringBitmap ... bitmaps) {
        return FastAggregation.naive_xor(bitmaps);
    }

    public static RoaringBitmap xor(Iterator<RoaringBitmap> bitmaps) {
        return FastAggregation.naive_xor(bitmaps);
    }

    public static RoaringBitmap and(RoaringBitmap ... bitmaps) {
        return FastAggregation.naive_and(bitmaps);
    }

    public static RoaringBitmap and(Iterator<RoaringBitmap> bitmaps) {
        return FastAggregation.naive_and(bitmaps);
    }

    @Deprecated
    public static RoaringBitmap horizontal_or(Iterator<RoaringBitmap> bitmaps) {
        return FastAggregation.naive_or(bitmaps);
    }

    public static RoaringBitmap priorityqueue_or(RoaringBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new RoaringBitmap();
        }
        PriorityQueue<RoaringBitmap> pq = new PriorityQueue<RoaringBitmap>(bitmaps.length, new Comparator<RoaringBitmap>(){

            @Override
            public int compare(RoaringBitmap a, RoaringBitmap b) {
                return a.getSizeInBytes() - b.getSizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 1) {
            RoaringBitmap x1 = pq.poll();
            RoaringBitmap x2 = pq.poll();
            pq.add(RoaringBitmap.lazyor(x1, x2));
        }
        RoaringBitmap answer = pq.poll();
        answer.repairAfterLazy();
        return answer;
    }

    public static RoaringBitmap priorityqueue_or(Iterator<RoaringBitmap> bitmaps) {
        if (!bitmaps.hasNext()) {
            return new RoaringBitmap();
        }
        PriorityQueue<RoaringBitmap> pq = new PriorityQueue<RoaringBitmap>(16, new Comparator<RoaringBitmap>(){

            @Override
            public int compare(RoaringBitmap a, RoaringBitmap b) {
                return a.getSizeInBytes() - b.getSizeInBytes();
            }
        });
        while (bitmaps.hasNext()) {
            pq.add(bitmaps.next());
        }
        while (pq.size() > 1) {
            RoaringBitmap x1 = pq.poll();
            RoaringBitmap x2 = pq.poll();
            pq.add(RoaringBitmap.lazyor(x1, x2));
        }
        RoaringBitmap answer = pq.poll();
        answer.repairAfterLazy();
        return answer;
    }

    public static RoaringBitmap horizontal_or(RoaringBitmap ... bitmaps) {
        RoaringBitmap answer = new RoaringBitmap();
        if (bitmaps.length == 0) {
            return answer;
        }
        PriorityQueue<ContainerPointer> pq = new PriorityQueue<ContainerPointer>(bitmaps.length);
        for (int k = 0; k < bitmaps.length; ++k) {
            ContainerPointer x = bitmaps[k].highLowContainer.getContainerPointer();
            if (x.getContainer() == null) continue;
            pq.add(x);
        }
        while (!pq.isEmpty()) {
            ContainerPointer x1 = (ContainerPointer)pq.poll();
            if (pq.isEmpty() || ((ContainerPointer)pq.peek()).key() != x1.key()) {
                answer.highLowContainer.append(x1.key(), x1.getContainer().clone());
                x1.advance();
                if (x1.getContainer() == null) continue;
                pq.add(x1);
                continue;
            }
            ContainerPointer x2 = (ContainerPointer)pq.poll();
            Container newc = x1.getContainer().lazyOR(x2.getContainer());
            while (!pq.isEmpty() && ((ContainerPointer)pq.peek()).key() == x1.key()) {
                ContainerPointer x = (ContainerPointer)pq.poll();
                newc = newc.lazyIOR(x.getContainer());
                x.advance();
                if (x.getContainer() != null) {
                    pq.add(x);
                    continue;
                }
                if (!pq.isEmpty()) continue;
                break;
            }
            newc = newc.repairAfterLazy();
            answer.highLowContainer.append(x1.key(), newc);
            x1.advance();
            if (x1.getContainer() != null) {
                pq.add(x1);
            }
            x2.advance();
            if (x2.getContainer() == null) continue;
            pq.add(x2);
        }
        return answer;
    }

    public static RoaringBitmap horizontal_or(List<RoaringBitmap> bitmaps) {
        RoaringBitmap answer = new RoaringBitmap();
        if (bitmaps.isEmpty()) {
            return answer;
        }
        PriorityQueue<ContainerPointer> pq = new PriorityQueue<ContainerPointer>(bitmaps.size());
        for (int k = 0; k < bitmaps.size(); ++k) {
            ContainerPointer x = bitmaps.get((int)k).highLowContainer.getContainerPointer();
            if (x.getContainer() == null) continue;
            pq.add(x);
        }
        while (!pq.isEmpty()) {
            ContainerPointer x1 = (ContainerPointer)pq.poll();
            if (pq.isEmpty() || ((ContainerPointer)pq.peek()).key() != x1.key()) {
                answer.highLowContainer.append(x1.key(), x1.getContainer().clone());
                x1.advance();
                if (x1.getContainer() == null) continue;
                pq.add(x1);
                continue;
            }
            ContainerPointer x2 = (ContainerPointer)pq.poll();
            Container newc = x1.getContainer().lazyOR(x2.getContainer());
            while (!pq.isEmpty() && ((ContainerPointer)pq.peek()).key() == x1.key()) {
                ContainerPointer x = (ContainerPointer)pq.poll();
                newc = newc.lazyIOR(x.getContainer());
                x.advance();
                if (x.getContainer() != null) {
                    pq.add(x);
                    continue;
                }
                if (!pq.isEmpty()) continue;
                break;
            }
            newc = newc.repairAfterLazy();
            answer.highLowContainer.append(x1.key(), newc);
            x1.advance();
            if (x1.getContainer() != null) {
                pq.add(x1);
            }
            x2.advance();
            if (x2.getContainer() == null) continue;
            pq.add(x2);
        }
        return answer;
    }

    public static RoaringBitmap priorityqueue_xor(RoaringBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new RoaringBitmap();
        }
        PriorityQueue<RoaringBitmap> pq = new PriorityQueue<RoaringBitmap>(bitmaps.length, new Comparator<RoaringBitmap>(){

            @Override
            public int compare(RoaringBitmap a, RoaringBitmap b) {
                return a.getSizeInBytes() - b.getSizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 1) {
            RoaringBitmap x1 = pq.poll();
            RoaringBitmap x2 = pq.poll();
            pq.add(RoaringBitmap.xor(x1, x2));
        }
        return pq.poll();
    }

    public static RoaringBitmap horizontal_xor(RoaringBitmap ... bitmaps) {
        RoaringBitmap answer = new RoaringBitmap();
        if (bitmaps.length == 0) {
            return answer;
        }
        PriorityQueue<ContainerPointer> pq = new PriorityQueue<ContainerPointer>(bitmaps.length);
        for (int k = 0; k < bitmaps.length; ++k) {
            ContainerPointer x = bitmaps[k].highLowContainer.getContainerPointer();
            if (x.getContainer() == null) continue;
            pq.add(x);
        }
        while (!pq.isEmpty()) {
            ContainerPointer x1 = (ContainerPointer)pq.poll();
            if (pq.isEmpty() || ((ContainerPointer)pq.peek()).key() != x1.key()) {
                answer.highLowContainer.append(x1.key(), x1.getContainer().clone());
                x1.advance();
                if (x1.getContainer() == null) continue;
                pq.add(x1);
                continue;
            }
            ContainerPointer x2 = (ContainerPointer)pq.poll();
            Container newc = x1.getContainer().xor(x2.getContainer());
            while (!pq.isEmpty() && ((ContainerPointer)pq.peek()).key() == x1.key()) {
                ContainerPointer x = (ContainerPointer)pq.poll();
                newc = newc.ixor(x.getContainer());
                x.advance();
                if (x.getContainer() != null) {
                    pq.add(x);
                    continue;
                }
                if (!pq.isEmpty()) continue;
                break;
            }
            answer.highLowContainer.append(x1.key(), newc);
            x1.advance();
            if (x1.getContainer() != null) {
                pq.add(x1);
            }
            x2.advance();
            if (x2.getContainer() == null) continue;
            pq.add(x2);
        }
        return answer;
    }
}

