/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableContainerPointer;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public final class BufferFastAggregation {
    public static MutableRoaringBitmap naive_and(MutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        for (int k = 0; k < bitmaps.length; ++k) {
            answer.and(bitmaps[k]);
        }
        return answer;
    }

    public static MutableRoaringBitmap naive_and(Iterator bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        while (bitmaps.hasNext()) {
            answer.and((ImmutableRoaringBitmap)bitmaps.next());
        }
        return answer;
    }

    public static MutableRoaringBitmap naive_or(MutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        for (int k = 0; k < bitmaps.length; ++k) {
            answer.lazyor(bitmaps[k]);
        }
        answer.repairAfterLazy();
        return answer;
    }

    public static MutableRoaringBitmap naive_or(Iterator bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        while (bitmaps.hasNext()) {
            answer.lazyor((ImmutableRoaringBitmap)bitmaps.next());
        }
        answer.repairAfterLazy();
        return answer;
    }

    public static MutableRoaringBitmap naive_xor(MutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        for (int k = 0; k < bitmaps.length; ++k) {
            answer.xor(bitmaps[k]);
        }
        return answer;
    }

    public static MutableRoaringBitmap naive_xor(Iterator bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        while (bitmaps.hasNext()) {
            answer.xor((ImmutableRoaringBitmap)bitmaps.next());
        }
        return answer;
    }

    public static MutableRoaringBitmap or(MutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.naive_or(bitmaps);
    }

    public static MutableRoaringBitmap or(ImmutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.naive_or(bitmaps);
    }

    public static MutableRoaringBitmap or(Iterator bitmaps) {
        return BufferFastAggregation.naive_or(bitmaps);
    }

    public static MutableRoaringBitmap xor(MutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.naive_xor(bitmaps);
    }

    public static MutableRoaringBitmap xor(ImmutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.naive_xor(bitmaps);
    }

    public static MutableRoaringBitmap xor(Iterator bitmaps) {
        return BufferFastAggregation.naive_xor(bitmaps);
    }

    public static MutableRoaringBitmap naive_and(ImmutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        for (int k = 0; k < bitmaps.length; ++k) {
            answer.and(bitmaps[k]);
        }
        return answer;
    }

    public static MutableRoaringBitmap naive_or(ImmutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        for (int k = 0; k < bitmaps.length; ++k) {
            answer.or(bitmaps[k]);
        }
        return answer;
    }

    public static MutableRoaringBitmap naive_xor(ImmutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        for (int k = 0; k < bitmaps.length; ++k) {
            answer.xor(bitmaps[k]);
        }
        return answer;
    }

    public static Iterator<ImmutableRoaringBitmap> convertToImmutable(final Iterator<MutableRoaringBitmap> i) {
        return new Iterator<ImmutableRoaringBitmap>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public ImmutableRoaringBitmap next() {
                return (ImmutableRoaringBitmap)i.next();
            }

            @Override
            public void remove() {
            }
        };
    }

    private static ImmutableRoaringBitmap[] convertToImmutable(MutableRoaringBitmap[] array) {
        ImmutableRoaringBitmap[] answer = new ImmutableRoaringBitmap[array.length];
        for (int k = 0; k < answer.length; ++k) {
            answer[k] = array[k];
        }
        return answer;
    }

    public static MutableRoaringBitmap and(MutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.and(BufferFastAggregation.convertToImmutable(bitmaps));
    }

    public static MutableRoaringBitmap and(ImmutableRoaringBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new MutableRoaringBitmap();
        }
        if (bitmaps.length == 1) {
            return bitmaps[0].toMutableRoaringBitmap();
        }
        ImmutableRoaringBitmap[] array = Arrays.copyOf(bitmaps, bitmaps.length);
        Arrays.sort(array, new Comparator<ImmutableRoaringBitmap>(){

            @Override
            public int compare(ImmutableRoaringBitmap a, ImmutableRoaringBitmap b) {
                return a.getSizeInBytes() - b.getSizeInBytes();
            }
        });
        MutableRoaringBitmap answer = ImmutableRoaringBitmap.and(array[0], array[1]);
        for (int k = 2; k < array.length; ++k) {
            answer.and(array[k]);
        }
        return answer;
    }

    public static MutableRoaringBitmap and(Iterator bitmaps) {
        if (!bitmaps.hasNext()) {
            return new MutableRoaringBitmap();
        }
        ArrayList<ImmutableRoaringBitmap> array = new ArrayList<ImmutableRoaringBitmap>();
        while (bitmaps.hasNext()) {
            array.add((ImmutableRoaringBitmap)bitmaps.next());
        }
        if (array.size() == 1) {
            return ((ImmutableRoaringBitmap)array.get(0)).toMutableRoaringBitmap();
        }
        Collections.sort(array, new Comparator<ImmutableRoaringBitmap>(){

            @Override
            public int compare(ImmutableRoaringBitmap a, ImmutableRoaringBitmap b) {
                return a.getSizeInBytes() - b.getSizeInBytes();
            }
        });
        MutableRoaringBitmap answer = ImmutableRoaringBitmap.and((ImmutableRoaringBitmap)array.get(0), (ImmutableRoaringBitmap)array.get(1));
        for (int k = 2; k < array.size(); ++k) {
            answer.and((ImmutableRoaringBitmap)array.get(k));
        }
        return answer;
    }

    @Deprecated
    public static MutableRoaringBitmap horizontal_or(Iterator bitmaps) {
        return BufferFastAggregation.naive_or(bitmaps);
    }

    public static MutableRoaringBitmap horizontal_or(MutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.horizontal_or(BufferFastAggregation.convertToImmutable(bitmaps));
    }

    public static MutableRoaringBitmap horizontal_or(ImmutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        if (bitmaps.length == 0) {
            return answer;
        }
        PriorityQueue<MappeableContainerPointer> pq = new PriorityQueue<MappeableContainerPointer>(bitmaps.length);
        for (int k = 0; k < bitmaps.length; ++k) {
            MappeableContainerPointer x = bitmaps[k].highLowContainer.getContainerPointer();
            if (x.getContainer() == null) continue;
            pq.add(x);
        }
        while (!pq.isEmpty()) {
            MappeableContainerPointer x1 = (MappeableContainerPointer)pq.poll();
            if (pq.isEmpty() || ((MappeableContainerPointer)pq.peek()).key() != x1.key()) {
                answer.getMappeableRoaringArray().append(x1.key(), x1.getContainer().clone());
                x1.advance();
                if (x1.getContainer() == null) continue;
                pq.add(x1);
                continue;
            }
            MappeableContainerPointer x2 = (MappeableContainerPointer)pq.poll();
            MappeableContainer newc = x1.getContainer().lazyOR(x2.getContainer());
            while (!pq.isEmpty() && ((MappeableContainerPointer)pq.peek()).key() == x1.key()) {
                MappeableContainerPointer x = (MappeableContainerPointer)pq.poll();
                newc = newc.lazyIOR(x.getContainer());
                x.advance();
                if (x.getContainer() != null) {
                    pq.add(x);
                    continue;
                }
                if (!pq.isEmpty()) continue;
                break;
            }
            newc = newc.repairAfterLazy();
            answer.getMappeableRoaringArray().append(x1.key(), newc);
            x1.advance();
            if (x1.getContainer() != null) {
                pq.add(x1);
            }
            x2.advance();
            if (x2.getContainer() == null) continue;
            pq.add(x2);
        }
        return answer;
    }

    public static MutableRoaringBitmap horizontal_xor(MutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.horizontal_xor(BufferFastAggregation.convertToImmutable(bitmaps));
    }

    public static MutableRoaringBitmap horizontal_xor(ImmutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        if (bitmaps.length == 0) {
            return answer;
        }
        PriorityQueue<MappeableContainerPointer> pq = new PriorityQueue<MappeableContainerPointer>(bitmaps.length);
        for (int k = 0; k < bitmaps.length; ++k) {
            MappeableContainerPointer x = bitmaps[k].highLowContainer.getContainerPointer();
            if (x.getContainer() == null) continue;
            pq.add(x);
        }
        while (!pq.isEmpty()) {
            MappeableContainerPointer x1 = (MappeableContainerPointer)pq.poll();
            if (pq.isEmpty() || ((MappeableContainerPointer)pq.peek()).key() != x1.key()) {
                answer.getMappeableRoaringArray().append(x1.key(), x1.getContainer().clone());
                x1.advance();
                if (x1.getContainer() == null) continue;
                pq.add(x1);
                continue;
            }
            MappeableContainerPointer x2 = (MappeableContainerPointer)pq.poll();
            MappeableContainer newc = x1.getContainer().xor(x2.getContainer());
            while (!pq.isEmpty() && ((MappeableContainerPointer)pq.peek()).key() == x1.key()) {
                MappeableContainerPointer x = (MappeableContainerPointer)pq.poll();
                newc = newc.ixor(x.getContainer());
                x.advance();
                if (x.getContainer() != null) {
                    pq.add(x);
                    continue;
                }
                if (!pq.isEmpty()) continue;
                break;
            }
            answer.getMappeableRoaringArray().append(x1.key(), newc);
            x1.advance();
            if (x1.getContainer() != null) {
                pq.add(x1);
            }
            x2.advance();
            if (x2.getContainer() == null) continue;
            pq.add(x2);
        }
        return answer;
    }

    public static MutableRoaringBitmap priorityqueue_or(ImmutableRoaringBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new MutableRoaringBitmap();
        }
        if (bitmaps.length == 1) {
            return bitmaps[0].toMutableRoaringBitmap();
        }
        PriorityQueue<ImmutableRoaringBitmap> pq = new PriorityQueue<ImmutableRoaringBitmap>(bitmaps.length, new Comparator<ImmutableRoaringBitmap>(){

            @Override
            public int compare(ImmutableRoaringBitmap a, ImmutableRoaringBitmap b) {
                return a.getSizeInBytes() - b.getSizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 1) {
            ImmutableRoaringBitmap x1 = pq.poll();
            ImmutableRoaringBitmap x2 = pq.poll();
            pq.add(ImmutableRoaringBitmap.lazyor(x1, x2));
        }
        MutableRoaringBitmap answer = (MutableRoaringBitmap)pq.poll();
        answer.repairAfterLazy();
        return answer;
    }

    public static MutableRoaringBitmap priorityqueue_or(Iterator bitmaps) {
        if (!bitmaps.hasNext()) {
            return new MutableRoaringBitmap();
        }
        PriorityQueue<ImmutableRoaringBitmap> pq = new PriorityQueue<ImmutableRoaringBitmap>(16, new Comparator<ImmutableRoaringBitmap>(){

            @Override
            public int compare(ImmutableRoaringBitmap a, ImmutableRoaringBitmap b) {
                return a.getSizeInBytes() - b.getSizeInBytes();
            }
        });
        while (bitmaps.hasNext()) {
            pq.add((ImmutableRoaringBitmap)bitmaps.next());
        }
        while (pq.size() > 1) {
            ImmutableRoaringBitmap x1 = pq.poll();
            ImmutableRoaringBitmap x2 = pq.poll();
            pq.add(ImmutableRoaringBitmap.lazyor(x1, x2));
        }
        MutableRoaringBitmap answer = (MutableRoaringBitmap)pq.poll();
        answer.repairAfterLazy();
        return answer;
    }

    public static MutableRoaringBitmap priorityqueue_xor(ImmutableRoaringBitmap ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("Expecting at least 2 bitmaps");
        }
        PriorityQueue<ImmutableRoaringBitmap> pq = new PriorityQueue<ImmutableRoaringBitmap>(bitmaps.length, new Comparator<ImmutableRoaringBitmap>(){

            @Override
            public int compare(ImmutableRoaringBitmap a, ImmutableRoaringBitmap b) {
                return a.getSizeInBytes() - b.getSizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 1) {
            ImmutableRoaringBitmap x1 = pq.poll();
            ImmutableRoaringBitmap x2 = pq.poll();
            pq.add(ImmutableRoaringBitmap.xor(x1, x2));
        }
        return (MutableRoaringBitmap)pq.poll();
    }

    private BufferFastAggregation() {
    }
}

