/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.ImmutableRoaringArray;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableContainerPointer;
import org.roaringbitmap.buffer.PointableRoaringArray;

public final class MutableRoaringArray
implements Cloneable,
Externalizable,
PointableRoaringArray {
    protected static final int INITIAL_CAPACITY = 4;
    protected static final short SERIAL_COOKIE = 12345;
    private static final long serialVersionUID = 4L;
    Element[] array = null;
    int size = 0;

    protected MutableRoaringArray() {
        this.array = new Element[4];
    }

    protected MutableRoaringArray(ByteBuffer bb) {
        int k;
        bb.order(ByteOrder.LITTLE_ENDIAN);
        if (bb.getInt() != 12345) {
            throw new RuntimeException("I failed to find the right cookie.");
        }
        this.size = bb.getInt();
        this.array = new Element[this.size];
        short[] keys = new short[this.size];
        int[] cardinalities = new int[this.size];
        boolean[] isBitmap = new boolean[this.size];
        for (k = 0; k < this.size; ++k) {
            keys[k] = bb.getShort();
            cardinalities[k] = BufferUtil.toIntUnsigned(bb.getShort()) + 1;
            isBitmap[k] = cardinalities[k] > 4096;
        }
        for (k = 0; k < this.size; ++k) {
            MappeableContainer val;
            if (cardinalities[k] == 0) {
                throw new RuntimeException("no");
            }
            if (isBitmap[k]) {
                LongBuffer bitmapArray = bb.asLongBuffer().slice();
                bitmapArray.limit(1024);
                bb.position(bb.position() + 8192);
                val = new MappeableBitmapContainer(bitmapArray, cardinalities[k]);
            } else {
                ShortBuffer shortArray = bb.asShortBuffer().slice();
                shortArray.limit(cardinalities[k]);
                bb.position(bb.position() + cardinalities[k] * 2);
                val = new MappeableArrayContainer(shortArray, cardinalities[k]);
            }
            this.array[k] = new Element(keys[k], val);
        }
    }

    protected void append(short key, MappeableContainer value) {
        this.extendArray(1);
        this.array[this.size++] = new Element(key, value);
    }

    protected void appendCopiesAfter(PointableRoaringArray highLowContainer, short beforeStart) {
        int startLocation = highLowContainer.getIndex(beforeStart);
        startLocation = startLocation >= 0 ? ++startLocation : -startLocation - 1;
        this.extendArray(highLowContainer.size() - startLocation);
        for (int i = startLocation; i < highLowContainer.size(); ++i) {
            this.array[this.size++] = new Element(highLowContainer.getKeyAtIndex(i), highLowContainer.getContainerAtIndex(i).clone());
        }
    }

    protected void appendCopiesUntil(PointableRoaringArray highLowContainer, short stoppingKey) {
        int stopKey = BufferUtil.toIntUnsigned(stoppingKey);
        MappeableContainerPointer cp = highLowContainer.getContainerPointer();
        while (cp.hasContainer() && BufferUtil.toIntUnsigned(cp.key()) < stopKey) {
            this.extendArray(1);
            this.array[this.size++] = new Element(cp.key(), cp.getContainer().clone());
            cp.advance();
        }
    }

    protected void appendCopy(PointableRoaringArray highLowContainer, int startingIndex, int end) {
        this.extendArray(end - startingIndex);
        for (int i = startingIndex; i < end; ++i) {
            this.array[this.size++] = new Element(highLowContainer.getKeyAtIndex(i), highLowContainer.getContainerAtIndex(i).clone());
        }
    }

    protected void appendCopy(short key, MappeableContainer value) {
        this.extendArray(1);
        this.array[this.size++] = new Element(key, value.clone());
    }

    private int binarySearch(int begin, int end, short key) {
        int low = begin;
        int high = end - 1;
        int ikey = BufferUtil.toIntUnsigned(key);
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = BufferUtil.toIntUnsigned(this.array[middleIndex].key);
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    protected void clear() {
        this.array = null;
        this.size = 0;
    }

    @Override
    public MutableRoaringArray clone() {
        try {
            MutableRoaringArray sa = (MutableRoaringArray)super.clone();
            sa.array = Arrays.copyOf(this.array, this.size);
            for (int k = 0; k < this.size; ++k) {
                sa.array[k] = sa.array[k].clone();
            }
            sa.size = this.size;
            return sa;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void deserialize(DataInput in) throws IOException {
        int k;
        this.clear();
        byte[] buffer4 = new byte[4];
        byte[] buffer = new byte[2];
        in.readFully(buffer4);
        int cookie = buffer4[0] & 0xFF | (buffer4[1] & 0xFF) << 8 | (buffer4[2] & 0xFF) << 16 | (buffer4[3] & 0xFF) << 24;
        if (cookie != 12345) {
            throw new IOException("I failed to find the right cookie.");
        }
        in.readFully(buffer4);
        this.size = buffer4[0] & 0xFF | (buffer4[1] & 0xFF) << 8 | (buffer4[2] & 0xFF) << 16 | (buffer4[3] & 0xFF) << 24;
        if (this.array == null || this.array.length < this.size) {
            this.array = new Element[this.size];
        }
        short[] keys = new short[this.size];
        int[] cardinalities = new int[this.size];
        boolean[] isBitmap = new boolean[this.size];
        for (k = 0; k < this.size; ++k) {
            in.readFully(buffer);
            keys[k] = (short)(buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8);
            in.readFully(buffer);
            cardinalities[k] = 1 + (buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8);
            isBitmap[k] = cardinalities[k] > 4096;
        }
        for (k = 0; k < this.size; ++k) {
            MappeableContainer val;
            if (isBitmap[k]) {
                LongBuffer bitmapArray = LongBuffer.allocate(1024);
                byte[] buf = new byte[8];
                for (int l = 0; l < bitmapArray.limit(); ++l) {
                    in.readFully(buf);
                    bitmapArray.put(l, ((long)buf[7] << 56) + ((long)(buf[6] & 0xFF) << 48) + ((long)(buf[5] & 0xFF) << 40) + ((long)(buf[4] & 0xFF) << 32) + ((long)(buf[3] & 0xFF) << 24) + (long)((buf[2] & 0xFF) << 16) + (long)((buf[1] & 0xFF) << 8) + (long)(buf[0] & 0xFF));
                }
                val = new MappeableBitmapContainer(bitmapArray, cardinalities[k]);
            } else {
                ShortBuffer shortArray = ShortBuffer.allocate(cardinalities[k]);
                for (int l = 0; l < shortArray.limit(); ++l) {
                    in.readFully(buffer);
                    shortArray.put(l, (short)(buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8));
                }
                val = new MappeableArrayContainer(shortArray, cardinalities[k]);
            }
            this.array[k] = new Element(keys[k], val);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof MutableRoaringArray) {
            MutableRoaringArray srb = (MutableRoaringArray)o;
            if (srb.size != this.size) {
                return false;
            }
            for (int i = 0; i < srb.size; ++i) {
                Element self = this.array[i];
                Element other = srb.array[i];
                if (self.key == other.key && self.value.equals(other.value)) continue;
                return false;
            }
            return true;
        }
        if (o instanceof ImmutableRoaringArray) {
            ImmutableRoaringArray srb = (ImmutableRoaringArray)o;
            MappeableContainerPointer cp1 = srb.getContainerPointer();
            MappeableContainerPointer cp2 = srb.getContainerPointer();
            while (cp1.hasContainer()) {
                if (!cp2.hasContainer()) {
                    return false;
                }
                if (cp1.key() != cp2.key()) {
                    return false;
                }
                if (cp1.getCardinality() != cp2.getCardinality()) {
                    return false;
                }
                if (cp1.getContainer().equals(cp2.getContainer())) continue;
                return false;
            }
            return !cp2.hasContainer();
        }
        return false;
    }

    protected void extendArray(int k) {
        if (this.size + k >= this.array.length) {
            int newCapacity = this.array.length < 1024 ? 2 * (this.size + k) : 5 * (this.size + k) / 4;
            this.array = Arrays.copyOf(this.array, newCapacity);
        }
    }

    @Override
    public MappeableContainer getContainer(short x) {
        int i = this.binarySearch(0, this.size, x);
        if (i < 0) {
            return null;
        }
        return this.array[i].value;
    }

    @Override
    public MappeableContainer getContainerAtIndex(int i) {
        return this.array[i].value;
    }

    @Override
    public MappeableContainerPointer getContainerPointer() {
        return new MappeableContainerPointer(){
            int k = 0;

            @Override
            public void advance() {
                ++this.k;
            }

            @Override
            public int compareTo(MappeableContainerPointer o) {
                if (this.key() != o.key()) {
                    return BufferUtil.toIntUnsigned(this.key()) - BufferUtil.toIntUnsigned(o.key());
                }
                return o.getCardinality() - this.getCardinality();
            }

            @Override
            public int getCardinality() {
                return this.getContainer().getCardinality();
            }

            @Override
            public MappeableContainer getContainer() {
                if (this.k >= MutableRoaringArray.this.size) {
                    return null;
                }
                return MutableRoaringArray.this.array[this.k].value;
            }

            @Override
            public boolean hasContainer() {
                return this.k < MutableRoaringArray.this.size;
            }

            @Override
            public short key() {
                return MutableRoaringArray.this.array[this.k].key;
            }

            @Override
            public MappeableContainerPointer clone() {
                try {
                    return (MappeableContainerPointer)super.clone();
                }
                catch (CloneNotSupportedException e) {
                    return null;
                }
            }
        };
    }

    @Override
    public int getIndex(short x) {
        if (this.size == 0 || this.array[this.size - 1].key == x) {
            return this.size - 1;
        }
        return this.binarySearch(0, this.size, x);
    }

    @Override
    public short getKeyAtIndex(int i) {
        return this.array[i].key;
    }

    public int hashCode() {
        int hashvalue = 0;
        for (int k = 0; k < this.size; ++k) {
            hashvalue = 31 * hashvalue + this.array[k].hashCode();
        }
        return hashvalue;
    }

    protected void insertNewKeyValueAt(int i, short key, MappeableContainer value) {
        this.extendArray(1);
        System.arraycopy(this.array, i, this.array, i + 1, this.size - i);
        this.array[i] = new Element(key, value);
        ++this.size;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    protected void removeAtIndex(int i) {
        System.arraycopy(this.array, i + 1, this.array, i, this.size - i - 1);
        this.array[this.size - 1] = null;
        --this.size;
    }

    protected void resize(int newLength) {
        for (int k = newLength; k < this.size; ++k) {
            this.array[k] = null;
        }
        this.size = newLength;
    }

    public void serialize(DataOutput out) throws IOException {
        int k;
        out.write(57);
        out.write(48);
        out.write(0);
        out.write(0);
        out.write(this.size & 0xFF);
        out.write(this.size >>> 8 & 0xFF);
        out.write(this.size >>> 16 & 0xFF);
        out.write(this.size >>> 24 & 0xFF);
        for (k = 0; k < this.size; ++k) {
            out.write(this.array[k].key & 0xFF);
            out.write(this.array[k].key >>> 8 & 0xFF);
            out.write(this.array[k].value.getCardinality() - 1 & 0xFF);
            out.write(this.array[k].value.getCardinality() - 1 >>> 8 & 0xFF);
        }
        for (k = 0; k < this.size; ++k) {
            this.array[k].value.writeArray(out);
        }
    }

    public int serializedSizeInBytes() {
        int count = 8 + 4 * this.size;
        for (int k = 0; k < this.size; ++k) {
            count += this.array[k].value.getArraySizeInBytes();
        }
        return count;
    }

    protected void setContainerAtIndex(int i, MappeableContainer c) {
        this.array[i].value = c;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    protected static final class Element
    implements Cloneable,
    Comparable<Element> {
        final short key;
        MappeableContainer value;

        public Element(short key, MappeableContainer value) {
            this.key = key;
            this.value = value;
        }

        public Element clone() throws CloneNotSupportedException {
            Element c = (Element)super.clone();
            c.value = this.value.clone();
            return c;
        }

        @Override
        public int compareTo(Element o) {
            return BufferUtil.toIntUnsigned(this.key) - BufferUtil.toIntUnsigned(o.key);
        }

        public boolean equals(Object o) {
            if (o instanceof Element) {
                Element e = (Element)o;
                return e.key == this.key && e.value.equals(this.value);
            }
            return false;
        }

        public int hashCode() {
            return this.key * 0xF0F0F0 + this.value.hashCode();
        }
    }
}

