/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableContainerPointer;
import org.roaringbitmap.buffer.MutableRoaringArray;
import org.roaringbitmap.buffer.PointableRoaringArray;

public final class ImmutableRoaringArray
implements PointableRoaringArray {
    protected static final short SERIAL_COOKIE = 12345;
    ByteBuffer buffer;
    short[] cardinalities;
    int[] containeroffsets;
    short[] keys;

    protected static int unsignedBinarySearch(short[] array, int begin, int end, short k) {
        int low = begin;
        int high = end - 1;
        int ikey = BufferUtil.toIntUnsigned(k);
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = BufferUtil.toIntUnsigned(array[middleIndex]);
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    protected ImmutableRoaringArray(ByteBuffer bbf) {
        this.buffer = bbf.duplicate();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        if (this.buffer.getInt() != 12345) {
            throw new RuntimeException("I failed to find the right cookie.");
        }
        int size = this.buffer.getInt();
        this.keys = new short[size];
        this.cardinalities = new short[size];
        this.containeroffsets = new int[size + 1];
        for (int k = 0; k < size; ++k) {
            this.keys[k] = this.buffer.getShort();
            this.cardinalities[k] = this.buffer.getShort();
            this.containeroffsets[k + 1] = this.containeroffsets[k] + BufferUtil.getSizeInBytesFromCardinality(this.getCardinality(k));
        }
        this.buffer = this.buffer.slice();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public ImmutableRoaringArray clone() {
        ImmutableRoaringArray sa;
        try {
            sa = (ImmutableRoaringArray)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return sa;
    }

    public boolean equals(Object o) {
        if (o instanceof ImmutableRoaringArray) {
            ImmutableRoaringArray srb = (ImmutableRoaringArray)o;
            if (!Arrays.equals(this.keys, srb.keys)) {
                return false;
            }
            if (!Arrays.equals(this.cardinalities, srb.cardinalities)) {
                return false;
            }
            for (int i = 0; i < srb.keys.length; ++i) {
                if (this.getContainerAtIndex(i).equals(srb.getContainerAtIndex(i))) continue;
                return false;
            }
            return true;
        }
        if (o instanceof MutableRoaringArray) {
            MutableRoaringArray srb = (MutableRoaringArray)o;
            MappeableContainerPointer cp1 = srb.getContainerPointer();
            MappeableContainerPointer cp2 = srb.getContainerPointer();
            while (cp1.hasContainer()) {
                if (!cp2.hasContainer()) {
                    return false;
                }
                if (cp1.key() != cp2.key()) {
                    return false;
                }
                if (cp1.getCardinality() != cp2.getCardinality()) {
                    return false;
                }
                if (!cp1.getContainer().equals(cp2.getContainer())) {
                    return false;
                }
                cp1.advance();
                cp2.advance();
            }
            return !cp2.hasContainer();
        }
        return false;
    }

    private int getCardinality(int k) {
        return BufferUtil.toIntUnsigned(this.cardinalities[k]) + 1;
    }

    @Override
    public MappeableContainer getContainer(short x) {
        int i = ImmutableRoaringArray.unsignedBinarySearch(this.keys, 0, this.keys.length, x);
        if (i < 0) {
            return null;
        }
        return this.getContainerAtIndex(i);
    }

    @Override
    public MappeableContainer getContainerAtIndex(int i) {
        boolean isBitmap = this.getCardinality(i) > 4096;
        this.buffer.position(this.containeroffsets[i]);
        if (isBitmap) {
            LongBuffer bitmapArray = this.buffer.asLongBuffer().slice();
            bitmapArray.limit(1024);
            return new MappeableBitmapContainer(bitmapArray, this.getCardinality(i));
        }
        ShortBuffer shortArray = this.buffer.asShortBuffer().slice();
        shortArray.limit(this.getCardinality(i));
        return new MappeableArrayContainer(shortArray, this.getCardinality(i));
    }

    @Override
    public MappeableContainerPointer getContainerPointer() {
        return new MappeableContainerPointer(){
            int k = 0;

            @Override
            public void advance() {
                ++this.k;
            }

            @Override
            public int compareTo(MappeableContainerPointer o) {
                if (this.key() != o.key()) {
                    return BufferUtil.toIntUnsigned(this.key()) - BufferUtil.toIntUnsigned(o.key());
                }
                return o.getCardinality() - this.getCardinality();
            }

            @Override
            public int getCardinality() {
                return ImmutableRoaringArray.this.getCardinality(this.k);
            }

            @Override
            public MappeableContainer getContainer() {
                if (this.k >= ImmutableRoaringArray.this.keys.length) {
                    return null;
                }
                return ImmutableRoaringArray.this.getContainerAtIndex(this.k);
            }

            @Override
            public boolean hasContainer() {
                return this.k < ImmutableRoaringArray.this.keys.length;
            }

            @Override
            public short key() {
                return ImmutableRoaringArray.this.keys[this.k];
            }

            @Override
            public MappeableContainerPointer clone() {
                try {
                    return (MappeableContainerPointer)super.clone();
                }
                catch (CloneNotSupportedException e) {
                    return null;
                }
            }
        };
    }

    @Override
    public int getIndex(short x) {
        return ImmutableRoaringArray.unsignedBinarySearch(this.keys, 0, this.keys.length, x);
    }

    @Override
    public short getKeyAtIndex(int i) {
        return this.keys[i];
    }

    public int hashCode() {
        MappeableContainerPointer cp = this.getContainerPointer();
        int hashvalue = 0;
        while (cp.hasContainer()) {
            int th = cp.key() * 0xF0F0F0 + cp.getContainer().hashCode();
            hashvalue = 31 * hashvalue + th;
        }
        return hashvalue;
    }

    public int serializedSizeInBytes() {
        return 8 + this.keys.length * 4 + this.containeroffsets[this.containeroffsets.length - 1];
    }

    @Override
    public int size() {
        return this.keys.length;
    }
}

