/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public final class BufferUtil {
    private BufferUtil() {
    }

    private static int advanceUntil(ShortBuffer array, int pos, int length, short min) {
        int upper;
        int lower = pos + 1;
        if (lower >= length || BufferUtil.toIntUnsigned(array.get(lower)) >= BufferUtil.toIntUnsigned(min)) {
            return lower;
        }
        int spansize = 1;
        while (lower + spansize < length && BufferUtil.toIntUnsigned(array.get(lower + spansize)) < BufferUtil.toIntUnsigned(min)) {
            spansize *= 2;
        }
        int n = upper = lower + spansize < length ? lower + spansize : length - 1;
        if (array.get(upper) == min) {
            return upper;
        }
        if (BufferUtil.toIntUnsigned(array.get(upper)) < BufferUtil.toIntUnsigned(min)) {
            return length;
        }
        lower += spansize / 2;
        while (lower + 1 != upper) {
            int mid = (lower + upper) / 2;
            if (array.get(mid) == min) {
                return mid;
            }
            if (BufferUtil.toIntUnsigned(array.get(mid)) < BufferUtil.toIntUnsigned(min)) {
                lower = mid;
                continue;
            }
            upper = mid;
        }
        return upper;
    }

    protected static void fillArrayAND(short[] container, LongBuffer bitmap1, LongBuffer bitmap2) {
        int pos = 0;
        if (bitmap1.limit() != bitmap2.limit()) {
            throw new IllegalArgumentException("not supported");
        }
        for (int k = 0; k < bitmap1.limit(); ++k) {
            long t;
            for (long bitset = bitmap1.get(k) & bitmap2.get(k); bitset != 0L; bitset ^= t) {
                t = bitset & -bitset;
                container[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
            }
        }
    }

    protected static void fillArrayANDNOT(short[] container, LongBuffer bitmap1, LongBuffer bitmap2) {
        int pos = 0;
        if (bitmap1.limit() != bitmap2.limit()) {
            throw new IllegalArgumentException("not supported");
        }
        for (int k = 0; k < bitmap1.limit(); ++k) {
            long t;
            for (long bitset = bitmap1.get(k) & (bitmap2.get(k) ^ 0xFFFFFFFFFFFFFFFFL); bitset != 0L; bitset ^= t) {
                t = bitset & -bitset;
                container[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
            }
        }
    }

    protected static void fillArrayXOR(short[] container, LongBuffer bitmap1, LongBuffer bitmap2) {
        int pos = 0;
        if (bitmap1.limit() != bitmap2.limit()) {
            throw new IllegalArgumentException("not supported");
        }
        for (int k = 0; k < bitmap1.limit(); ++k) {
            long t;
            for (long bitset = bitmap1.get(k) ^ bitmap2.get(k); bitset != 0L; bitset ^= t) {
                t = bitset & -bitset;
                container[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
            }
        }
    }

    protected static short highbits(int x) {
        return (short)(x >>> 16);
    }

    protected static short lowbits(int x) {
        return (short)(x & 0xFFFF);
    }

    protected static short maxLowBit() {
        return -1;
    }

    protected static int toIntUnsigned(short x) {
        return x & 0xFFFF;
    }

    protected static int unsignedBinarySearch(ShortBuffer array, int begin, int end, short k) {
        int low = begin;
        int high = end - 1;
        int ikey = BufferUtil.toIntUnsigned(k);
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = BufferUtil.toIntUnsigned(array.get(middleIndex));
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    protected static int unsignedDifference(ShortBuffer set1, int length1, ShortBuffer set2, int length2, short[] buffer) {
        int pos;
        block9: {
            pos = 0;
            int k1 = 0;
            int k2 = 0;
            if (0 == length2) {
                for (int k = 0; k < length1; ++k) {
                    buffer[k] = set1.get(k);
                }
                return length1;
            }
            if (0 == length1) {
                return 0;
            }
            while (true) {
                if (BufferUtil.toIntUnsigned(set1.get(k1)) < BufferUtil.toIntUnsigned(set2.get(k2))) {
                    buffer[pos++] = set1.get(k1);
                    if (++k1 < length1) continue;
                    break block9;
                }
                if (BufferUtil.toIntUnsigned(set1.get(k1)) == BufferUtil.toIntUnsigned(set2.get(k2))) {
                    ++k2;
                    if (++k1 < length1) {
                        if (k2 < length2) continue;
                        while (k1 < length1) {
                            buffer[pos++] = set1.get(k1);
                            ++k1;
                        }
                    }
                    break block9;
                }
                if (++k2 >= length2) break;
            }
            while (k1 < length1) {
                buffer[pos++] = set1.get(k1);
                ++k1;
            }
        }
        return pos;
    }

    protected static int unsignedExclusiveUnion2by2(ShortBuffer set1, int length1, ShortBuffer set2, int length2, short[] buffer) {
        int pos;
        block13: {
            pos = 0;
            int k1 = 0;
            int k2 = 0;
            if (0 == length2) {
                for (int k = 0; k < length1; ++k) {
                    buffer[k] = set1.get(k);
                }
                return length1;
            }
            if (0 == length1) {
                for (int k = 0; k < length2; ++k) {
                    buffer[k] = set2.get(k);
                }
                return length2;
            }
            while (true) {
                if (BufferUtil.toIntUnsigned(set1.get(k1)) < BufferUtil.toIntUnsigned(set2.get(k2))) {
                    buffer[pos++] = set1.get(k1);
                    if (++k1 < length1) continue;
                    while (k2 < length2) {
                        buffer[pos++] = set2.get(k2);
                        ++k2;
                    }
                    break block13;
                }
                if (BufferUtil.toIntUnsigned(set1.get(k1)) == BufferUtil.toIntUnsigned(set2.get(k2))) {
                    ++k2;
                    if (++k1 >= length1) {
                        while (k2 < length2) {
                            buffer[pos++] = set2.get(k2);
                            ++k2;
                        }
                    } else {
                        if (k2 < length2) continue;
                        while (k1 < length1) {
                            buffer[pos++] = set1.get(k1);
                            ++k1;
                        }
                    }
                    break block13;
                }
                buffer[pos++] = set2.get(k2);
                if (++k2 >= length2) break;
            }
            while (k1 < length1) {
                buffer[pos++] = set1.get(k1);
                ++k1;
            }
        }
        return pos;
    }

    protected static int unsignedIntersect2by2(ShortBuffer set1, int length1, ShortBuffer set2, int length2, short[] buffer) {
        if (set1.limit() * 64 < set2.limit()) {
            return BufferUtil.unsignedOneSidedGallopingIntersect2by2(set1, length1, set2, length2, buffer);
        }
        if (set2.limit() * 64 < set1.limit()) {
            return BufferUtil.unsignedOneSidedGallopingIntersect2by2(set2, length2, set1, length1, buffer);
        }
        return BufferUtil.unsignedLocalIntersect2by2(set1, length1, set2, length2, buffer);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static int unsignedLocalIntersect2by2(ShortBuffer set1, int length1, ShortBuffer set2, int length2, short[] buffer) {
        if (0 == length1) return 0;
        if (0 == length2) {
            return 0;
        }
        int k1 = 0;
        int k2 = 0;
        int pos = 0;
        while (true) {
            if (BufferUtil.toIntUnsigned(set2.get(k2)) < BufferUtil.toIntUnsigned(set1.get(k1))) {
                do {
                    if (++k2 != length2) continue;
                    return pos;
                } while (BufferUtil.toIntUnsigned(set2.get(k2)) < BufferUtil.toIntUnsigned(set1.get(k1)));
            }
            if (BufferUtil.toIntUnsigned(set1.get(k1)) >= BufferUtil.toIntUnsigned(set2.get(k2))) {
                buffer[pos++] = set1.get(k1);
                if (++k1 == length1) {
                    return pos;
                }
                if (++k2 != length2) continue;
                return pos;
            }
            do {
                if (++k1 != length1) continue;
                return pos;
            } while (BufferUtil.toIntUnsigned(set1.get(k1)) < BufferUtil.toIntUnsigned(set2.get(k2)));
        }
    }

    protected static int unsignedOneSidedGallopingIntersect2by2(ShortBuffer smallSet, int smallLength, ShortBuffer largeSet, int largeLength, short[] buffer) {
        if (0 == smallLength) {
            return 0;
        }
        int k1 = 0;
        int k2 = 0;
        int pos = 0;
        while (BufferUtil.toIntUnsigned(largeSet.get(k1)) >= BufferUtil.toIntUnsigned(smallSet.get(k2)) || (k1 = BufferUtil.advanceUntil(largeSet, k1, largeLength, smallSet.get(k2))) != largeLength) {
            if (BufferUtil.toIntUnsigned(smallSet.get(k2)) < BufferUtil.toIntUnsigned(largeSet.get(k1))) {
                if (++k2 != smallLength) continue;
                break;
            }
            buffer[pos++] = smallSet.get(k2);
            if (++k2 != smallLength && (k1 = BufferUtil.advanceUntil(largeSet, k1, largeLength, smallSet.get(k2))) != largeLength) continue;
            break;
        }
        return pos;
    }

    protected static int unsignedUnion2by2(ShortBuffer set1, int length1, ShortBuffer set2, int length2, short[] buffer) {
        int pos;
        block13: {
            pos = 0;
            int k1 = 0;
            int k2 = 0;
            if (0 == length2) {
                for (int k = 0; k < length1; ++k) {
                    buffer[k] = set1.get(k);
                }
                return length1;
            }
            if (0 == length1) {
                for (int k = 0; k < length2; ++k) {
                    buffer[k] = set2.get(k);
                }
                return length2;
            }
            while (true) {
                if (BufferUtil.toIntUnsigned(set1.get(k1)) < BufferUtil.toIntUnsigned(set2.get(k2))) {
                    buffer[pos++] = set1.get(k1);
                    if (++k1 < length1) continue;
                    while (k2 < length2) {
                        buffer[pos++] = set2.get(k2);
                        ++k2;
                    }
                    break block13;
                }
                if (BufferUtil.toIntUnsigned(set1.get(k1)) == BufferUtil.toIntUnsigned(set2.get(k2))) {
                    buffer[pos++] = set1.get(k1);
                    ++k2;
                    if (++k1 >= length1) {
                        while (k2 < length2) {
                            buffer[pos++] = set2.get(k2);
                            ++k2;
                        }
                    } else {
                        if (k2 < length2) continue;
                        while (k1 < length1) {
                            buffer[pos++] = set1.get(k1);
                            ++k1;
                        }
                    }
                    break block13;
                }
                buffer[pos++] = set2.get(k2);
                if (++k2 >= length2) break;
            }
            while (k1 < length1) {
                buffer[pos++] = set1.get(k1);
                ++k1;
            }
        }
        return pos;
    }
}

