/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

public final class Util {
    private Util() {
    }

    private static int advanceUntil(short[] array, int pos, int length, short min) {
        int upper;
        int lower = pos + 1;
        if (lower >= length || Util.toIntUnsigned(array[lower]) >= Util.toIntUnsigned(min)) {
            return lower;
        }
        int spansize = 1;
        while (lower + spansize < length && Util.toIntUnsigned(array[lower + spansize]) < Util.toIntUnsigned(min)) {
            spansize *= 2;
        }
        int n = upper = lower + spansize < length ? lower + spansize : length - 1;
        if (array[upper] == min) {
            return upper;
        }
        if (Util.toIntUnsigned(array[upper]) < Util.toIntUnsigned(min)) {
            return length;
        }
        lower += spansize / 2;
        while (lower + 1 != upper) {
            int mid = (lower + upper) / 2;
            if (array[mid] == min) {
                return mid;
            }
            if (Util.toIntUnsigned(array[mid]) < Util.toIntUnsigned(min)) {
                lower = mid;
                continue;
            }
            upper = mid;
        }
        return upper;
    }

    public static void fillArrayAND(short[] container, long[] bitmap1, long[] bitmap2) {
        int pos = 0;
        if (bitmap1.length != bitmap2.length) {
            throw new IllegalArgumentException("not supported");
        }
        for (int k = 0; k < bitmap1.length; ++k) {
            long t;
            for (long bitset = bitmap1[k] & bitmap2[k]; bitset != 0L; bitset ^= t) {
                t = bitset & -bitset;
                container[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
            }
        }
    }

    public static void fillArrayANDNOT(short[] container, long[] bitmap1, long[] bitmap2) {
        int pos = 0;
        if (bitmap1.length != bitmap2.length) {
            throw new IllegalArgumentException("not supported");
        }
        for (int k = 0; k < bitmap1.length; ++k) {
            long t;
            for (long bitset = bitmap1[k] & (bitmap2[k] ^ 0xFFFFFFFFFFFFFFFFL); bitset != 0L; bitset ^= t) {
                t = bitset & -bitset;
                container[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
            }
        }
    }

    public static void fillArrayXOR(short[] container, long[] bitmap1, long[] bitmap2) {
        int pos = 0;
        if (bitmap1.length != bitmap2.length) {
            throw new IllegalArgumentException("not supported");
        }
        for (int k = 0; k < bitmap1.length; ++k) {
            long t;
            for (long bitset = bitmap1[k] ^ bitmap2[k]; bitset != 0L; bitset ^= t) {
                t = bitset & -bitset;
                container[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
            }
        }
    }

    protected static short highbits(int x) {
        return (short)(x >>> 16);
    }

    protected static short lowbits(int x) {
        return (short)(x & 0xFFFF);
    }

    protected static short maxLowBit() {
        return -1;
    }

    protected static int toIntUnsigned(short x) {
        return x & 0xFFFF;
    }

    protected static int unsignedBinarySearch(short[] array, int begin, int end, short k) {
        int low = begin;
        int high = end - 1;
        int ikey = Util.toIntUnsigned(k);
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = Util.toIntUnsigned(array[middleIndex]);
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    public static int unsignedDifference(short[] set1, int length1, short[] set2, int length2, short[] buffer) {
        int pos;
        block8: {
            pos = 0;
            int k1 = 0;
            int k2 = 0;
            if (0 == length2) {
                System.arraycopy(set1, 0, buffer, 0, length1);
                return length1;
            }
            if (0 == length1) {
                return 0;
            }
            while (true) {
                if (Util.toIntUnsigned(set1[k1]) < Util.toIntUnsigned(set2[k2])) {
                    buffer[pos++] = set1[k1];
                    if (++k1 < length1) continue;
                    break block8;
                }
                if (Util.toIntUnsigned(set1[k1]) == Util.toIntUnsigned(set2[k2])) {
                    ++k2;
                    if (++k1 < length1) {
                        if (k2 < length2) continue;
                        while (k1 < length1) {
                            buffer[pos++] = set1[k1];
                            ++k1;
                        }
                    }
                    break block8;
                }
                if (++k2 >= length2) break;
            }
            while (k1 < length1) {
                buffer[pos++] = set1[k1];
                ++k1;
            }
        }
        return pos;
    }

    public static int unsigned_exclusiveunion2by2(short[] set1, int length1, short[] set2, int length2, short[] buffer) {
        int pos;
        block11: {
            pos = 0;
            int k1 = 0;
            int k2 = 0;
            if (0 == length2) {
                System.arraycopy(set1, 0, buffer, 0, length1);
                return length1;
            }
            if (0 == length1) {
                System.arraycopy(set2, 0, buffer, 0, length2);
                return length2;
            }
            while (true) {
                if (Util.toIntUnsigned(set1[k1]) < Util.toIntUnsigned(set2[k2])) {
                    buffer[pos++] = set1[k1];
                    if (++k1 < length1) continue;
                    while (k2 < length2) {
                        buffer[pos++] = set2[k2];
                        ++k2;
                    }
                    break block11;
                }
                if (Util.toIntUnsigned(set1[k1]) == Util.toIntUnsigned(set2[k2])) {
                    ++k2;
                    if (++k1 >= length1) {
                        while (k2 < length2) {
                            buffer[pos++] = set2[k2];
                            ++k2;
                        }
                    } else {
                        if (k2 < length2) continue;
                        while (k1 < length1) {
                            buffer[pos++] = set1[k1];
                            ++k1;
                        }
                    }
                    break block11;
                }
                buffer[pos++] = set2[k2];
                if (++k2 >= length2) break;
            }
            while (k1 < length1) {
                buffer[pos++] = set1[k1];
                ++k1;
            }
        }
        return pos;
    }

    public static int unsigned_intersect2by2(short[] set1, int length1, short[] set2, int length2, short[] buffer) {
        if (set1.length * 64 < set2.length) {
            return Util.unsigned_onesidedgallopingintersect2by2(set1, length1, set2, length2, buffer);
        }
        if (set2.length * 64 < set1.length) {
            return Util.unsigned_onesidedgallopingintersect2by2(set2, length2, set1, length1, buffer);
        }
        return Util.unsigned_localintersect2by2(set1, length1, set2, length2, buffer);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static int unsigned_localintersect2by2(short[] set1, int length1, short[] set2, int length2, short[] buffer) {
        if (0 == length1) return 0;
        if (0 == length2) {
            return 0;
        }
        int k1 = 0;
        int k2 = 0;
        int pos = 0;
        while (true) {
            if (Util.toIntUnsigned(set2[k2]) < Util.toIntUnsigned(set1[k1])) {
                do {
                    if (++k2 != length2) continue;
                    return pos;
                } while (Util.toIntUnsigned(set2[k2]) < Util.toIntUnsigned(set1[k1]));
            }
            if (Util.toIntUnsigned(set1[k1]) >= Util.toIntUnsigned(set2[k2])) {
                buffer[pos++] = set1[k1];
                if (++k1 == length1) {
                    return pos;
                }
                if (++k2 != length2) continue;
                return pos;
            }
            do {
                if (++k1 != length1) continue;
                return pos;
            } while (Util.toIntUnsigned(set1[k1]) < Util.toIntUnsigned(set2[k2]));
        }
    }

    protected static int unsigned_onesidedgallopingintersect2by2(short[] smallSet, int smallLength, short[] largeSet, int largeLength, short[] buffer) {
        if (0 == smallLength) {
            return 0;
        }
        int k1 = 0;
        int k2 = 0;
        int pos = 0;
        while (Util.toIntUnsigned(largeSet[k1]) >= Util.toIntUnsigned(smallSet[k2]) || (k1 = Util.advanceUntil(largeSet, k1, largeLength, smallSet[k2])) != largeLength) {
            if (Util.toIntUnsigned(smallSet[k2]) < Util.toIntUnsigned(largeSet[k1])) {
                if (++k2 != smallLength) continue;
                break;
            }
            buffer[pos++] = smallSet[k2];
            if (++k2 != smallLength && (k1 = Util.advanceUntil(largeSet, k1, largeLength, smallSet[k2])) != largeLength) continue;
            break;
        }
        return pos;
    }

    public static int unsigned_union2by2(short[] set1, int length1, short[] set2, int length2, short[] buffer) {
        int pos;
        block11: {
            pos = 0;
            int k1 = 0;
            int k2 = 0;
            if (0 == length2) {
                System.arraycopy(set1, 0, buffer, 0, length1);
                return length1;
            }
            if (0 == length1) {
                System.arraycopy(set2, 0, buffer, 0, length2);
                return length2;
            }
            while (true) {
                if (Util.toIntUnsigned(set1[k1]) < Util.toIntUnsigned(set2[k2])) {
                    buffer[pos++] = set1[k1];
                    if (++k1 < length1) continue;
                    while (k2 < length2) {
                        buffer[pos++] = set2[k2];
                        ++k2;
                    }
                    break block11;
                }
                if (Util.toIntUnsigned(set1[k1]) == Util.toIntUnsigned(set2[k2])) {
                    buffer[pos++] = set1[k1];
                    ++k2;
                    if (++k1 >= length1) {
                        while (k2 < length2) {
                            buffer[pos++] = set2[k2];
                            ++k2;
                        }
                    } else {
                        if (k2 < length2) continue;
                        while (k1 < length1) {
                            buffer[pos++] = set1[k1];
                            ++k1;
                        }
                    }
                    break block11;
                }
                buffer[pos++] = set2[k2];
                if (++k2 >= length2) break;
            }
            while (k1 < length1) {
                buffer[pos++] = set1[k1];
                ++k1;
            }
        }
        return pos;
    }
}

