/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Iterator;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.buffer.ArrayContainer;
import org.roaringbitmap.buffer.Container;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.RoaringArray;
import org.roaringbitmap.buffer.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RoaringBitmap
extends ImmutableRoaringBitmap
implements Cloneable,
Serializable,
Iterable<Integer>,
Externalizable {
    private static final long serialVersionUID = 3L;

    public static RoaringBitmap and(RoaringBitmap x1, RoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highlowcontainer.size();
        int length2 = x2.highlowcontainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
            short s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    if (++pos2 == length2) break;
                    s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
                    continue;
                }
                Container C = x1.highlowcontainer.getContainerAtIndex(pos1).and(x2.highlowcontainer.getContainerAtIndex(pos2));
                if (C.getCardinality() > 0) {
                    answer.highlowcontainer.append(s1, C);
                }
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
                s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            }
        }
        return answer;
    }

    public static RoaringBitmap andNot(RoaringBitmap x1, RoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highlowcontainer.size();
        int length2 = x2.highlowcontainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
            short s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    answer.highlowcontainer.appendCopy(x1.highlowcontainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    if (++pos2 == length2) break;
                    s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
                    continue;
                }
                Container C = x1.highlowcontainer.getContainerAtIndex(pos1).andNot(x2.highlowcontainer.getContainerAtIndex(pos2));
                if (C.getCardinality() > 0) {
                    answer.highlowcontainer.append(s1, C);
                }
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
                s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            }
        }
        if (pos2 == length2) {
            answer.highlowcontainer.appendCopy(x1.highlowcontainer, pos1, length1);
        }
        return answer;
    }

    public static RoaringBitmap bitmapOf(int ... dat) {
        RoaringBitmap ans = new RoaringBitmap();
        for (int i : dat) {
            ans.add(i);
        }
        return ans;
    }

    public static RoaringBitmap flip(RoaringBitmap bm, int rangeStart, int rangeEnd) {
        RoaringBitmap answer = null;
        if (rangeStart >= rangeEnd) {
            answer = bm.clone();
            return answer;
        }
        answer = new RoaringBitmap();
        short hbStart = Util.highbits(rangeStart);
        short lbStart = Util.lowbits(rangeStart);
        short hbLast = Util.highbits(rangeEnd - 1);
        short lbLast = Util.lowbits(rangeEnd - 1);
        answer.highlowcontainer.appendCopiesUntil(bm.highlowcontainer, hbStart);
        int max = Util.toIntUnsigned(Util.maxLowBit());
        for (short hb = hbStart; hb <= hbLast; hb = (short)(hb + 1)) {
            int containerStart = hb == hbStart ? Util.toIntUnsigned(lbStart) : 0;
            int containerLast = hb == hbLast ? Util.toIntUnsigned(lbLast) : max;
            int i = bm.highlowcontainer.getIndex(hb);
            int j = answer.highlowcontainer.getIndex(hb);
            assert (j < 0);
            if (i >= 0) {
                Container c = bm.highlowcontainer.getContainerAtIndex(i).not(containerStart, containerLast);
                if (c.getCardinality() <= 0) continue;
                answer.highlowcontainer.insertNewKeyValueAt(-j - 1, hb, c);
                continue;
            }
            answer.highlowcontainer.insertNewKeyValueAt(-j - 1, hb, Container.rangeOfOnes(containerStart, containerLast));
        }
        answer.highlowcontainer.appendCopiesAfter(bm.highlowcontainer, hbLast);
        return answer;
    }

    public static RoaringBitmap or(RoaringBitmap x1, RoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highlowcontainer.size();
        int length2 = x2.highlowcontainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
            short s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    answer.highlowcontainer.appendCopy(x1.highlowcontainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    answer.highlowcontainer.appendCopy(x2.highlowcontainer, pos2);
                    if (++pos2 == length2) break;
                    s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
                    continue;
                }
                answer.highlowcontainer.append(s1, x1.highlowcontainer.getContainerAtIndex(pos1).or(x2.highlowcontainer.getContainerAtIndex(pos2)));
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
                s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            answer.highlowcontainer.appendCopy(x2.highlowcontainer, pos2, length2);
        } else if (pos2 == length2) {
            answer.highlowcontainer.appendCopy(x1.highlowcontainer, pos1, length1);
        }
        return answer;
    }

    public static RoaringBitmap xor(RoaringBitmap x1, RoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highlowcontainer.size();
        int length2 = x2.highlowcontainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
            short s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    answer.highlowcontainer.appendCopy(x1.highlowcontainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    answer.highlowcontainer.appendCopy(x2.highlowcontainer, pos2);
                    if (++pos2 == length2) break;
                    s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
                    continue;
                }
                Container C = x1.highlowcontainer.getContainerAtIndex(pos1).xor(x2.highlowcontainer.getContainerAtIndex(pos2));
                if (C.getCardinality() > 0) {
                    answer.highlowcontainer.append(s1, C);
                }
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
                s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            answer.highlowcontainer.appendCopy(x2.highlowcontainer, pos2, length2);
        } else if (pos2 == length2) {
            answer.highlowcontainer.appendCopy(x1.highlowcontainer, pos1, length1);
        }
        return answer;
    }

    public RoaringBitmap() {
        this.highlowcontainer = new RoaringArray();
    }

    public void add(int x) {
        short hb = Util.highbits(x);
        int i = this.highlowcontainer.getIndex(hb);
        if (i >= 0) {
            this.highlowcontainer.setContainerAtIndex(i, this.highlowcontainer.getContainerAtIndex(i).add(Util.lowbits(x)));
        } else {
            ArrayContainer newac = new ArrayContainer();
            this.highlowcontainer.insertNewKeyValueAt(-i - 1, hb, newac.add(Util.lowbits(x)));
        }
    }

    public void and(RoaringBitmap x2) {
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highlowcontainer.size();
        int length2 = x2.highlowcontainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = this.highlowcontainer.getKeyAtIndex(pos1);
            short s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    this.highlowcontainer.removeAtIndex(pos1);
                    if (pos1 == --length1) break;
                    s1 = this.highlowcontainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    if (++pos2 == length2) break;
                    s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
                    continue;
                }
                Container C = this.highlowcontainer.getContainerAtIndex(pos1).iand(x2.highlowcontainer.getContainerAtIndex(pos2));
                if (C.getCardinality() > 0) {
                    this.highlowcontainer.setContainerAtIndex(pos1, C);
                    ++pos1;
                } else {
                    this.highlowcontainer.removeAtIndex(pos1);
                    --length1;
                }
                if (pos1 == length1 || ++pos2 == length2) break;
                s1 = this.highlowcontainer.getKeyAtIndex(pos1);
                s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            }
        }
        this.highlowcontainer.resize(pos1);
    }

    public void andNot(RoaringBitmap x2) {
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highlowcontainer.size();
        int length2 = x2.highlowcontainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = this.highlowcontainer.getKeyAtIndex(pos1);
            short s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = this.highlowcontainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    if (++pos2 == length2) break;
                    s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
                    continue;
                }
                Container C = this.highlowcontainer.getContainerAtIndex(pos1).iandNot(x2.highlowcontainer.getContainerAtIndex(pos2));
                if (C.getCardinality() > 0) {
                    this.highlowcontainer.setContainerAtIndex(pos1, C);
                    ++pos1;
                } else {
                    this.highlowcontainer.removeAtIndex(pos1);
                    --length1;
                }
                if (pos1 == length1 || ++pos2 == length2) break;
                s1 = this.highlowcontainer.getKeyAtIndex(pos1);
                s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            }
        }
    }

    public void clear() {
        this.highlowcontainer = new RoaringArray();
    }

    public RoaringBitmap clone() {
        try {
            RoaringBitmap x = (RoaringBitmap)super.clone();
            x.highlowcontainer = this.highlowcontainer.clone();
            return x;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException("shouldn't happen with clone");
        }
    }

    public void deserialize(DataInput in) throws IOException {
        this.highlowcontainer.deserialize(in);
    }

    public void flip(int rangeStart, int rangeEnd) {
        if (rangeStart >= rangeEnd) {
            return;
        }
        short hbStart = Util.highbits(rangeStart);
        short lbStart = Util.lowbits(rangeStart);
        short hbLast = Util.highbits(rangeEnd - 1);
        short lbLast = Util.lowbits(rangeEnd - 1);
        int max = Util.toIntUnsigned(Util.maxLowBit());
        for (short hb = hbStart; hb <= hbLast; hb = (short)(hb + 1)) {
            int containerStart = hb == hbStart ? Util.toIntUnsigned(lbStart) : 0;
            int containerLast = hb == hbLast ? Util.toIntUnsigned(lbLast) : max;
            int i = this.highlowcontainer.getIndex(hb);
            if (i >= 0) {
                Container c = this.highlowcontainer.getContainerAtIndex(i).inot(containerStart, containerLast);
                if (c.getCardinality() > 0) {
                    this.highlowcontainer.setContainerAtIndex(i, c);
                    continue;
                }
                this.highlowcontainer.removeAtIndex(i);
                continue;
            }
            this.highlowcontainer.insertNewKeyValueAt(-i - 1, hb, Container.rangeOfOnes(containerStart, containerLast));
        }
    }

    private IntIterator getIntIterator() {
        return new IntIterator(){
            int hs = 0;
            Iterator<Short> iter;
            short pos = 0;
            int x;

            public boolean hasNext() {
                return this.pos < RoaringBitmap.this.highlowcontainer.size();
            }

            public IntIterator init() {
                if (this.pos < RoaringBitmap.this.highlowcontainer.size()) {
                    this.iter = RoaringBitmap.this.highlowcontainer.getContainerAtIndex(this.pos).iterator();
                    this.hs = Util.toIntUnsigned(RoaringBitmap.this.highlowcontainer.getKeyAtIndex(this.pos)) << 16;
                }
                return this;
            }

            public int next() {
                this.x = Util.toIntUnsigned(this.iter.next()) | this.hs;
                if (!this.iter.hasNext()) {
                    this.pos = (short)(this.pos + 1);
                    this.init();
                }
                return this.x;
            }

            public void remove() {
                if ((this.x & this.hs) == this.hs) {
                    this.iter.remove();
                } else {
                    RoaringBitmap.this.remove(this.x);
                }
            }
        }.init();
    }

    @Override
    public int hashCode() {
        return this.highlowcontainer.hashCode();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int hs = 0;
            Iterator<Short> iter;
            short pos = 0;
            int x;

            @Override
            public boolean hasNext() {
                return this.pos < RoaringBitmap.this.highlowcontainer.size();
            }

            public Iterator<Integer> init() {
                if (this.pos < RoaringBitmap.this.highlowcontainer.size()) {
                    this.iter = RoaringBitmap.this.highlowcontainer.getContainerAtIndex(this.pos).iterator();
                    this.hs = Util.toIntUnsigned(RoaringBitmap.this.highlowcontainer.getKeyAtIndex(this.pos)) << 16;
                }
                return this;
            }

            @Override
            public Integer next() {
                this.x = Util.toIntUnsigned(this.iter.next()) | this.hs;
                if (!this.iter.hasNext()) {
                    this.pos = (short)(this.pos + 1);
                    this.init();
                }
                return this.x;
            }

            @Override
            public void remove() {
                if ((this.x & this.hs) == this.hs) {
                    this.iter.remove();
                } else {
                    RoaringBitmap.this.remove(this.x);
                }
            }
        }.init();
    }

    public void or(RoaringBitmap x2) {
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highlowcontainer.size();
        int length2 = x2.highlowcontainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = this.highlowcontainer.getKeyAtIndex(pos1);
            short s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = this.highlowcontainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    this.highlowcontainer.insertNewKeyValueAt(pos1, s2, x2.highlowcontainer.getContainerAtIndex(pos2));
                    ++pos1;
                    ++length1;
                    if (++pos2 == length2) break;
                    s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
                    continue;
                }
                this.highlowcontainer.setContainerAtIndex(pos1, this.highlowcontainer.getContainerAtIndex(pos1).ior(x2.highlowcontainer.getContainerAtIndex(pos2)));
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = this.highlowcontainer.getKeyAtIndex(pos1);
                s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            this.highlowcontainer.appendCopy(x2.highlowcontainer, pos2, length2);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.highlowcontainer.readExternal(in);
    }

    public void remove(int x) {
        short hb = Util.highbits(x);
        int i = this.highlowcontainer.getIndex(hb);
        if (i < 0) {
            return;
        }
        this.highlowcontainer.setContainerAtIndex(i, this.highlowcontainer.getContainerAtIndex(i).remove(Util.lowbits(x)));
        if (this.highlowcontainer.getContainerAtIndex(i).getCardinality() == 0) {
            this.highlowcontainer.removeAtIndex(i);
        }
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        this.highlowcontainer.serialize(out);
    }

    @Override
    public String toString() {
        StringBuffer answer = new StringBuffer();
        IntIterator i = this.getIntIterator();
        answer.append("{");
        if (i.hasNext()) {
            answer.append(i.next());
        }
        while (i.hasNext()) {
            answer.append(",");
            answer.append(i.next());
        }
        answer.append("}");
        return answer.toString();
    }

    public void trim() {
        for (int i = 0; i < this.highlowcontainer.size(); ++i) {
            this.highlowcontainer.getContainerAtIndex(i).trim();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.highlowcontainer.writeExternal(out);
    }

    public void xor(RoaringBitmap x2) {
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highlowcontainer.size();
        int length2 = x2.highlowcontainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = this.highlowcontainer.getKeyAtIndex(pos1);
            short s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = this.highlowcontainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    this.highlowcontainer.insertNewKeyValueAt(pos1, s2, x2.highlowcontainer.getContainerAtIndex(pos2));
                    ++pos1;
                    ++length1;
                    if (++pos2 == length2) break;
                    s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
                    continue;
                }
                Container C = this.highlowcontainer.getContainerAtIndex(pos1).ixor(x2.highlowcontainer.getContainerAtIndex(pos2));
                if (C.getCardinality() > 0) {
                    this.highlowcontainer.setContainerAtIndex(pos1, C);
                    ++pos1;
                } else {
                    this.highlowcontainer.removeAtIndex(pos1);
                    --length1;
                }
                if (pos1 == length1 || ++pos2 == length2) break;
                s1 = this.highlowcontainer.getKeyAtIndex(pos1);
                s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            this.highlowcontainer.appendCopy(x2.highlowcontainer, pos2, length2);
        }
    }
}

