/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSObject;
import org.richfaces.application.ServiceTracker;
import org.richfaces.component.AbstractNotifyMessage;
import org.richfaces.component.AbstractNotifyMessages;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.javascript.JavaScriptService;
import org.richfaces.renderkit.MessageForRender;
import org.richfaces.renderkit.MessageRendererBase;
import org.richfaces.renderkit.NotifyRendererUtils;
import org.richfaces.renderkit.util.RendererUtils;

public class NotifyMessageRendererBase
extends MessageRendererBase {
    @Override
    protected String getJSClassName() {
        return "RichFaces.ui.NotifyMessage";
    }

    protected void encodeScript(FacesContext facesContext, UIComponent component, Map<String, Object> options) throws IOException {
        FacesMessage.Severity level;
        UIComponent target;
        JavaScriptService javaScriptService = (JavaScriptService)ServiceTracker.getService(JavaScriptService.class);
        JSObject messageObject = new JSObject(this.getJSClassName(), new Object[]{component.getClientId(facesContext)});
        Map attributes = component.getAttributes();
        ImmutableMap.Builder parametersBuilder = ImmutableMap.builder();
        String forId = (String)attributes.get("for");
        RendererUtils rendererUtils = RendererUtils.getInstance();
        if (!Strings.isNullOrEmpty((String)forId) && null != (target = rendererUtils.findComponentFor(component, forId))) {
            parametersBuilder.put((Object)"forComponentId", (Object)target.getClientId(facesContext));
        }
        if (FacesMessage.SEVERITY_INFO != (level = this.getLevel(component))) {
            parametersBuilder.put((Object)"level", (Object)level.getOrdinal());
        }
        if (!rendererUtils.isBooleanAttribute(component, "showSummary")) {
            parametersBuilder.put((Object)"showSummary", (Object)false);
        }
        if (rendererUtils.isBooleanAttribute(component, "showDetail")) {
            parametersBuilder.put((Object)"showDetail", (Object)true);
        }
        if (rendererUtils.isBooleanAttribute(component, "tooltip")) {
            parametersBuilder.put((Object)"tooltip", (Object)true);
        }
        if (this.isComponentMessages(component) && rendererUtils.isBooleanAttribute(component, "globalOnly")) {
            parametersBuilder.put((Object)"globalOnly", (Object)true);
        }
        if (this.isComponentMessages(component)) {
            parametersBuilder.put((Object)"isMessages", (Object)true);
        }
        messageObject.addParameter((Object)parametersBuilder.build());
        messageObject.addParameter(options);
        javaScriptService.addPageReadyScript(facesContext, (Object)messageObject);
    }

    protected void encodeNotification(FacesContext facesContext, UIComponent component, Map<String, Object> options) throws IOException {
        JavaScriptService javaScriptService = (JavaScriptService)ServiceTracker.getService(JavaScriptService.class);
        for (MessageForRender message : this.getVisibleMessages(facesContext, component)) {
            JSFunction notifyCall = new JSFunction("RichFaces.ui.Notify", new Object[0]);
            LinkedHashMap<String, Object> optionsCopy = new LinkedHashMap<String, Object>(options);
            this.addMessageSpecificAttributes(message, facesContext, component, optionsCopy);
            notifyCall.addParameter(optionsCopy);
            javaScriptService.addPageReadyScript(facesContext, (Object)notifyCall);
            message.rendered();
        }
    }

    private void addMessageSpecificAttributes(MessageForRender message, FacesContext facesContext, UIComponent component, Map<String, Object> options) {
        Boolean showSummary = (Boolean)component.getAttributes().get("showSummary");
        Boolean showDetail = (Boolean)component.getAttributes().get("showDetail");
        String stackId = NotifyRendererUtils.getStackId(facesContext, component);
        boolean escape = true;
        if (component instanceof AbstractNotifyMessage) {
            escape = ((AbstractNotifyMessage)component).isEscape();
        }
        if (component instanceof AbstractNotifyMessages) {
            escape = ((AbstractNotifyMessages)component).isEscape();
        }
        options.put("severity", message.getSeverity().getOrdinal());
        if (showSummary != null && showSummary.booleanValue()) {
            options.put("summary", NotifyMessageRendererBase.escapeValue(message.getSummary(), escape));
        }
        if (showSummary != null && showDetail.booleanValue()) {
            options.put("detail", NotifyMessageRendererBase.escapeValue(message.getDetail(), escape));
        }
        if (stackId != null && !stackId.isEmpty()) {
            options.put("stackId", stackId);
        }
    }

    private static String escapeValue(String value, boolean escape) {
        return escape ? HtmlUtil.escapeHtml(value) : value;
    }
}

