/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import java.util.AbstractMap;
import javax.faces.component.UIComponent;
import org.richfaces.component.ColumnsFilter;
import org.richfaces.component.ColumnsOrder;
import org.richfaces.component.ColumnsSort;
import org.richfaces.component.ColumnsWidth;
import org.richfaces.component.UIDataTableBase;
import org.richfaces.json.JSONCollection;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONMap;
import org.richfaces.json.JSONObject;

public class ExtendedDataTableState
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected ColumnsWidth columnsWidthState;
    protected ColumnsOrder columnsOrderState;
    protected ColumnsFilter columnsFilterState;
    protected ColumnsSort columnsSortState;

    public ExtendedDataTableState(UIDataTableBase extendedDataTable) {
        this.columnsWidthState = new ColumnsWidth(extendedDataTable);
        this.columnsOrderState = new ColumnsOrder(extendedDataTable);
        this.columnsFilterState = new ColumnsFilter(extendedDataTable);
        this.columnsSortState = new ColumnsSort(extendedDataTable);
    }

    public ExtendedDataTableState(String tableState) {
        AbstractMap json = null;
        if (tableState != null && tableState.length() > 0) {
            try {
                json = new JSONMap(tableState);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (json != null) {
            this.columnsWidthState = new ColumnsWidth((JSONMap)json.get("columnsWidthState"));
            this.columnsOrderState = new ColumnsOrder((JSONCollection)json.get("columnsOrderState"));
            this.columnsFilterState = new ColumnsFilter((JSONMap)json.get("columnsFilterState"));
            this.columnsSortState = new ColumnsSort((JSONMap)json.get("columnsSortState"));
        }
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        try {
            if (this.columnsWidthState != null && !this.columnsWidthState.isEmpty()) {
                json.put("columnsWidthState", this.columnsWidthState.toJSON());
            }
            if (this.columnsOrderState != null && !this.columnsOrderState.isEmpty()) {
                json.put("columnsOrderState", this.columnsOrderState.toJSON());
            }
            if (this.columnsFilterState != null && !this.columnsFilterState.isEmpty()) {
                json.put("columnsFilterState", this.columnsFilterState.toJSON());
            }
            if (this.columnsSortState != null && !this.columnsSortState.isEmpty()) {
                json.put("columnsSortState", this.columnsSortState.toJSON());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    public String toString() {
        return this.toJSON().toString();
    }

    public String getColumnWidth(UIComponent column) {
        return this.columnsWidthState.getColumnState(column);
    }

    public String getColumnFilter(UIComponent column) {
        return this.columnsFilterState.getColumnState(column);
    }

    public String getColumnSort(UIComponent column) {
        return this.columnsSortState.getColumnState(column);
    }

    public String[] getColumnsOrder() {
        return this.columnsOrderState.getColumnsOrder();
    }
}

