/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import org.richfaces.StateHolderArray;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.component.Column;
import org.richfaces.component.Expandable;
import org.richfaces.component.UIDataTableBase;
import org.richfaces.event.CollapsibleSubTableToggleEvent;
import org.richfaces.event.CollapsibleSubTableToggleListener;

public abstract class AbstractCollapsibleSubTable
extends UIDataTableBase
implements Column,
Expandable {
    public static final String COMPONENT_TYPE = "org.richfaces.CollapsibleSubTable";
    public static final String COMPONENT_FAMILY = "org.richfaces.Data";
    public static final String MODE_AJAX = "ajax";
    public static final String MODE_SERVER = "server";
    public static final String MODE_CLIENT = "client";
    public static final int EXPANDED_STATE = 1;
    public static final int COLLAPSED_STATE = 0;

    @Attribute
    public boolean isExpanded() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.expanded), (Object)true);
    }

    public void setExpanded(boolean expanded) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.expanded), (Object)expanded);
    }

    @Attribute
    public abstract String getExpandMode();

    @Override
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof CollapsibleSubTableToggleEvent) {
            CollapsibleSubTableToggleEvent toggleEvent = (CollapsibleSubTableToggleEvent)event;
            boolean newValue = toggleEvent.isExpanded();
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.expanded), (Object)newValue);
            FacesContext facesContext = this.getFacesContext();
            ELContext elContext = facesContext.getELContext();
            ValueExpression valueExpression = this.getValueExpression(PropertyKeys.expanded.toString());
            if (valueExpression != null && !valueExpression.isReadOnly(elContext)) {
                valueExpression.setValue(elContext, (Object)newValue);
            }
            if (this.getFacesContext().getPartialViewContext().isAjaxRequest()) {
                String render = this.resolveClientId(facesContext, (UIComponent)this, "body");
                this.getFacesContext().getPartialViewContext().getRenderIds().add(render);
                String togglerId = toggleEvent.getTogglerId();
                if (togglerId != null) {
                    this.getFacesContext().getPartialViewContext().getRenderIds().add(togglerId);
                }
            }
        }
        super.broadcast(event);
    }

    public boolean isBreakBefore() {
        return true;
    }

    public void setBreakBefore(boolean newBreakBefore) {
        throw new IllegalStateException("Property 'breakBefore' for subtable is read-only");
    }

    public String getSortExpression() {
        return null;
    }

    public void setSortExpression(String sortExpression) {
        throw new IllegalArgumentException("subtable is not sortable element");
    }

    public void addCollapsibleSubTableToggleListener(CollapsibleSubTableToggleListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public void removeCollapsibleSubTableToggleListener(CollapsibleSubTableToggleListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public CollapsibleSubTableToggleListener[] getCollapsibleSubTableToggleListener() {
        return (CollapsibleSubTableToggleListener[])this.getFacesListeners(CollapsibleSubTableToggleListener.class);
    }

    @Override
    public void setIterationState(Object stateObject) {
        StateHolderArray stateHolderList = (StateHolderArray)stateObject;
        if (stateHolderList != null && !stateHolderList.isEmpty()) {
            super.setIterationState(stateHolderList.get(0));
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.expanded), (Object)((Boolean)stateHolderList.get(1)));
        } else {
            super.setIterationState(null);
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.expanded), null);
        }
    }

    @Override
    public Object getIterationState() {
        StateHolderArray holderList = new StateHolderArray();
        holderList.add(super.getIterationState());
        holderList.add(this.getStateHelper().get((Serializable)((Object)PropertyKeys.expanded)));
        return holderList;
    }

    static enum PropertyKeys {
        expanded;

    }
}

