/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.bootstrap.ui.tabbable;

import java.util.List;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import org.richfaces.bootstrap.semantic.AbstractMenuFacet;
import org.richfaces.bootstrap.ui.tab.AbstractTab;
import org.richfaces.bootstrap.ui.tabbable.AbstractTabbable;
import org.richfaces.renderkit.RendererBase;

@ResourceDependencies(value={@ResourceDependency(library="org.richfaces", name="ajax.reslib"), @ResourceDependency(library="org.richfaces", name="base-component.reslib"), @ResourceDependency(library="org.richfaces", name="bootstrap-css.reslib"), @ResourceDependency(library="org.richfaces", name="bootstrap-js.reslib")})
public abstract class TabbableRendererBase
extends RendererBase {
    public static final String RENDERER_TYPE = "org.richfaces.bootstrap.TabbableRenderer";
    private String indexSeparator;

    public void setDefaultChild(UIComponent component) {
        AbstractTabbable tabbable = (AbstractTabbable)component;
        boolean hasDefaultChild = this.hasDefaultChild(tabbable.getChildren(), false);
        if (!hasDefaultChild && tabbable.getActiveName() != null && !"".equals(tabbable.getActiveName())) {
            hasDefaultChild = this.setDefaultChildByName(tabbable.getChildren(), tabbable.getActiveName(), false);
        }
        if (!hasDefaultChild) {
            this.indexSeparator = tabbable.getIndexSeparator();
            this.setDefaultChildByIndex(tabbable.getChildren(), tabbable.getActiveIndex(), "", false);
        }
    }

    private boolean hasDefaultChild(List<UIComponent> children, boolean hasDefaultChildSoFar) {
        for (UIComponent child : children) {
            boolean hasDefaultChildSoFarOld;
            if (child instanceof AbstractTab) {
                AbstractTab tab = (AbstractTab)child;
                if (hasDefaultChildSoFar) {
                    tab.getAttributes().put("default", false);
                    continue;
                }
                hasDefaultChildSoFar = tab.isDefault();
                continue;
            }
            if (!(child instanceof AbstractMenuFacet) || (hasDefaultChildSoFarOld = hasDefaultChildSoFar) == (hasDefaultChildSoFar = this.hasDefaultChild(child.getChildren(), hasDefaultChildSoFar))) continue;
            AbstractMenuFacet menuFacet = (AbstractMenuFacet)child;
            menuFacet.getAttributes().put("active", true);
        }
        return hasDefaultChildSoFar;
    }

    private boolean setDefaultChildByName(List<UIComponent> children, String tabName, boolean hasDefaultChildSoFar) {
        for (UIComponent child : children) {
            boolean hasDefaultChildSoFarOld;
            if (child instanceof AbstractTab) {
                AbstractTab tab = (AbstractTab)child;
                if (hasDefaultChildSoFar || !tabName.equals(tab.getName())) continue;
                tab.getAttributes().put("default", true);
                hasDefaultChildSoFar = true;
                continue;
            }
            if (!(child instanceof AbstractMenuFacet) || (hasDefaultChildSoFarOld = hasDefaultChildSoFar) == (hasDefaultChildSoFar = this.setDefaultChildByName(child.getChildren(), tabName, hasDefaultChildSoFar))) continue;
            AbstractMenuFacet menuFacet = (AbstractMenuFacet)child;
            menuFacet.getAttributes().put("active", true);
        }
        return hasDefaultChildSoFar;
    }

    private boolean setDefaultChildByIndex(List<UIComponent> children, String index, String currentIndex, boolean hasDefaultChildSoFar) {
        int intLocalIndex = Integer.valueOf("0");
        for (UIComponent child : children) {
            boolean hasDefaultChildSoFarOld;
            String localIndex = currentIndex.length() > 0 ? currentIndex + this.indexSeparator + intLocalIndex : "" + intLocalIndex;
            if (child instanceof AbstractTab && localIndex.equals(index)) {
                AbstractTab tab = (AbstractTab)child;
                tab.getAttributes().put("default", true);
                hasDefaultChildSoFar = true;
            } else if (child instanceof AbstractMenuFacet && (hasDefaultChildSoFarOld = hasDefaultChildSoFar) != (hasDefaultChildSoFar = this.setDefaultChildByIndex(child.getChildren(), index, localIndex, hasDefaultChildSoFar))) {
                AbstractMenuFacet menuFacet = (AbstractMenuFacet)child;
                menuFacet.getAttributes().put("active", true);
            }
            ++intLocalIndex;
        }
        return hasDefaultChildSoFar;
    }
}

