/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.bootstrap.ui.input;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import org.richfaces.bootstrap.ui.commandButton.AbstractCommandButton;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.component.attribute.CoreProps;

public abstract class AbstractInput
extends UIInput
implements CoreProps {
    public static final String COMPONENT_FAMILY = "org.richfaces.bootstrap.Input";
    public static final String COMPONENT_TYPE = "org.richfaces.bootstrap.Input";
    public static final String TYPE_BUTTON = "button";
    public static final String TYPE_CHECKBOX = "checkbox";
    public static final String TYPE_COLOR = "color";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_DATETIME = "datetime";
    public static final String TYPE_DATETIME_LOCAL = "datetime-local";
    public static final String TYPE_EMAIL = "email";
    public static final String TYPE_FILE = "file";
    public static final String TYPE_HIDDEN = "hidden";
    public static final String TYPE_IMAGE = "image";
    public static final String TYPE_MONTH = "month";
    public static final String TYPE_NUMBER = "number";
    public static final String TYPE_PASSWORD = "password";
    public static final String TYPE_RADIO = "radio";
    public static final String TYPE_RANGE = "range";
    public static final String TYPE_RESET = "reset";
    public static final String TYPE_SEARCH = "search";
    public static final String TYPE_SUBMIT = "submit";
    public static final String TYPE_TEL = "tel";
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_TIME = "time";
    public static final String TYPE_URL = "url";
    public static final String TYPE_WEEK = "week";

    @Attribute(defaultValue="text", suggestedValue="button,checkbox,color,date,datetime,datetime-local,email,file,hidden,image,month,number,password,radio,range,reset,search,submit,tel,text,time,url,week")
    public abstract String getType();

    @Attribute(suggestedValue="success,info,warning,error")
    public abstract String getSeverity();

    @Attribute(suggestedValue="mini,small,medium,large,xlarge,xxlarge")
    public abstract String getScale();

    @Attribute
    public abstract String getPlaceholder();

    @Attribute
    public abstract boolean isReadonly();

    @Attribute
    public abstract boolean isDisabled();

    public boolean hasFacet(String facetName) {
        return this.getFacet(facetName) != null && this.getFacet(facetName).isRendered();
    }

    public boolean isChildBtn(UIComponent child) {
        return child instanceof AbstractCommandButton || this.hasStyleClass(child, "btn");
    }

    public boolean hasStyleClass(UIComponent component, String styleClassName) {
        return this.containsStyleClass(component.getAttributes().get("styleClass"), styleClassName);
    }

    public boolean containsStyleClass(Object styleClassAttribute, String styleClassName) {
        if (styleClassAttribute == null) {
            return false;
        }
        StringBuilder regex = new StringBuilder();
        regex.append("^").append(styleClassName).append(" ");
        regex.append("|");
        regex.append(" ").append(styleClassName).append(" ");
        regex.append("|");
        regex.append(" ").append(styleClassName).append("$");
        regex.append("|");
        regex.append("^").append(styleClassName).append("$");
        Pattern pattern = Pattern.compile(regex.toString());
        Matcher matcher = pattern.matcher(styleClassAttribute.toString());
        return matcher.find();
    }

    public List<UIComponent> getFacetChildren(String facetName) {
        UIComponent facet = this.getFacet(facetName);
        if (facet != null && facet.isRendered()) {
            if ("javax.faces.Panel".equals(facet.getFamily())) {
                return facet.getChildren();
            }
            ArrayList<UIComponent> children = new ArrayList<UIComponent>();
            children.add(facet);
            return children;
        }
        return null;
    }
}

