/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.bootstrap.ui.commandButton;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.bootstrap.ui.commandButton.AbstractCommandButton;
import org.richfaces.bootstrap.ui.commandButton.CommandButtonRendererBase;
import org.richfaces.renderkit.RenderKitUtils;

public class CommandButtonRenderer
extends CommandButtonRendererBase {
    private static final RenderKitUtils.Attributes PASS_THROUGH_ATTRIBUTES10 = RenderKitUtils.attributes().bool("disabled", "disabled").generic("ondblclick", "ondblclick", new String[]{"dblclick"}).generic("onmousedown", "onmousedown", new String[]{"mousedown"}).generic("onmousemove", "onmousemove", new String[]{"mousemove"}).generic("onmouseout", "onmouseout", new String[]{"mouseout"}).generic("onmouseover", "onmouseover", new String[]{"mouseover"}).generic("onmouseup", "onmouseup", new String[]{"mouseup"}).generic("title", "title", new String[0]);
    private static final RenderKitUtils.Attributes PASS_THROUGH_ATTRIBUTES11 = RenderKitUtils.attributes().bool("disabled", "disabled").generic("ondblclick", "ondblclick", new String[]{"dblclick"}).generic("onmousedown", "onmousedown", new String[]{"mousedown"}).generic("onmousemove", "onmousemove", new String[]{"mousemove"}).generic("onmouseout", "onmouseout", new String[]{"mouseout"}).generic("onmouseover", "onmouseover", new String[]{"mouseover"}).generic("onmouseup", "onmouseup", new String[]{"mouseup"}).generic("title", "title", new String[0]);
    private static final RenderKitUtils.Attributes PASS_THROUGH_ATTRIBUTES12 = RenderKitUtils.attributes().generic("style", "style", new String[0]);

    private static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object.getClass().isArray()) {
            return ((Object[])object).length == 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return object.toString().length() == 0;
    }

    private static String convertToString(Object object) {
        return object != null ? object.toString() : "";
    }

    private static boolean isEqual(Object o1, Object o2) {
        if (o1 != null) {
            return o1.equals(o2);
        }
        return o2 == null;
    }

    public void renderCommandButton(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent, String type, boolean split) throws IOException {
        String colorStyleWhenNotEmpty;
        AbstractCommandButton component = (AbstractCommandButton)uiComponent;
        String clientId = component.getClientId(facesContext);
        String styleWhenNotSplit = !split ? component.getStyle() : "";
        String styleClassWhenNotSplit = !split ? component.getStyleClass() : "";
        String severityClass = CommandButtonRenderer.isEmpty(component.getSeverity()) ? "" : "btn-".concat(component.getSeverity());
        String scaleClass = CommandButtonRenderer.isEmpty(component.getScale()) ? "" : "btn-".concat(component.getScale());
        String color = component.getColor();
        String colorStyle = "color: " + CommandButtonRenderer.convertToString(color) + ";";
        String string = colorStyleWhenNotEmpty = color != null && !color.equals("") ? colorStyle : "";
        if (CommandButtonRenderer.isEqual(component.getTag(), "button")) {
            Object text;
            responseWriter.startElement("button", (UIComponent)component);
            Object value = "btn " + CommandButtonRenderer.convertToString(styleClassWhenNotSplit) + " " + CommandButtonRenderer.convertToString(severityClass) + " " + CommandButtonRenderer.convertToString(scaleClass);
            if (null != value && ((String)value).length() > 0) {
                responseWriter.writeAttribute("class", value, null);
            }
            if (null != (value = clientId) && ((String)value).length() > 0) {
                responseWriter.writeAttribute("name", value, null);
            }
            if (null != (value = this.getOnClick(facesContext, (UIComponent)component)) && ((String)value).length() > 0) {
                responseWriter.writeAttribute("onclick", value, null);
            }
            if (null != (value = CommandButtonRenderer.convertToString(colorStyleWhenNotEmpty) + CommandButtonRenderer.convertToString(styleWhenNotSplit)) && ((String)value).length() > 0) {
                responseWriter.writeAttribute("style", value, null);
            }
            if (null != (value = type) && ((String)value).length() > 0) {
                responseWriter.writeAttribute("type", value, null);
            }
            if (null != (value = component.getValue()) && RenderKitUtils.shouldRenderAttribute((Object)value)) {
                responseWriter.writeAttribute("value", value, null);
            }
            RenderKitUtils.renderPassThroughAttributes((FacesContext)facesContext, (UIComponent)component, (Collection)PASS_THROUGH_ATTRIBUTES10);
            this.encodeId(facesContext, (UIComponent)component, split, clientId);
            if (!CommandButtonRenderer.isEmpty(component.getIcon())) {
                responseWriter.startElement("i", (UIComponent)component);
                value = "icon-" + CommandButtonRenderer.convertToString(component.getIcon());
                if (null != value && ((String)value).length() > 0) {
                    responseWriter.writeAttribute("class", value, null);
                }
                responseWriter.endElement("i");
                responseWriter.writeText((Object)" ", null);
            }
            if ((text = component.getValue()) != null) {
                responseWriter.writeText(text, null);
            }
            this.renderChildren(facesContext, (UIComponent)component);
            responseWriter.endElement("button");
        } else if (CommandButtonRenderer.isEqual(component.getTag(), "input")) {
            responseWriter.startElement("input", (UIComponent)component);
            Object value = "btn " + CommandButtonRenderer.convertToString(styleClassWhenNotSplit) + " " + CommandButtonRenderer.convertToString(severityClass) + " " + CommandButtonRenderer.convertToString(scaleClass);
            if (null != value && ((String)value).length() > 0) {
                responseWriter.writeAttribute("class", value, null);
            }
            if (null != (value = clientId) && ((String)value).length() > 0) {
                responseWriter.writeAttribute("name", value, null);
            }
            if (null != (value = this.getOnClick(facesContext, (UIComponent)component)) && ((String)value).length() > 0) {
                responseWriter.writeAttribute("onclick", value, null);
            }
            if (null != (value = CommandButtonRenderer.convertToString(colorStyleWhenNotEmpty) + CommandButtonRenderer.convertToString(styleWhenNotSplit)) && ((String)value).length() > 0) {
                responseWriter.writeAttribute("style", value, null);
            }
            responseWriter.writeAttribute("type", (Object)"submit", null);
            value = component.getValue();
            if (null != value && RenderKitUtils.shouldRenderAttribute((Object)value)) {
                responseWriter.writeAttribute("value", value, null);
            }
            RenderKitUtils.renderPassThroughAttributes((FacesContext)facesContext, (UIComponent)component, (Collection)PASS_THROUGH_ATTRIBUTES11);
            this.encodeId(facesContext, (UIComponent)component, split, clientId);
            this.encodeTypeAndImage(facesContext, (UIComponent)component);
            responseWriter.endElement("input");
        }
    }

    private static boolean convertToBoolean(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return Boolean.valueOf(object.toString());
    }

    public void renderSplit(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent, String type) throws IOException {
        AbstractCommandButton component = (AbstractCommandButton)uiComponent;
        String clientId = component.getClientId(facesContext);
        String severityClass = CommandButtonRenderer.isEmpty(component.getSeverity()) ? "" : "btn-".concat(component.getSeverity());
        String scaleClass = CommandButtonRenderer.isEmpty(component.getScale()) ? "" : "btn-".concat(component.getScale());
        String color = component.getColor();
        String colorStyle = "border-top-color: " + CommandButtonRenderer.convertToString(color) + "; border-bottom-color: " + CommandButtonRenderer.convertToString(color) + ";";
        String horizontalClass = component.getHorizontal() != null ? component.getHorizontal().getButtonClass() : "";
        String verticalClass = component.getVertical() != null ? component.getVertical().getButtonClass() : "";
        responseWriter.startElement("div", (UIComponent)component);
        String value = "btn-group " + CommandButtonRenderer.convertToString(component.getStyleClass()) + " " + CommandButtonRenderer.convertToString(verticalClass);
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("class", (Object)value, null);
        }
        if (null != (value = clientId) && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        RenderKitUtils.renderPassThroughAttributes((FacesContext)facesContext, (UIComponent)component, (Collection)PASS_THROUGH_ATTRIBUTES12);
        this.renderCommandButton(responseWriter, facesContext, (UIComponent)component, type, CommandButtonRenderer.convertToBoolean("true"));
        responseWriter.startElement("button", (UIComponent)component);
        value = "btn dropdown-toggle " + CommandButtonRenderer.convertToString(severityClass) + " " + CommandButtonRenderer.convertToString(scaleClass);
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("class", (Object)value, null);
        }
        responseWriter.writeAttribute("data-toggle", (Object)"dropdown", null);
        responseWriter.startElement("span", (UIComponent)component);
        responseWriter.writeAttribute("class", (Object)"caret", null);
        String string = value = color == null ? "" : colorStyle;
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("style", (Object)value, null);
        }
        responseWriter.endElement("span");
        responseWriter.endElement("button");
        responseWriter.startElement("ul", (UIComponent)component);
        value = "dropdown-menu " + CommandButtonRenderer.convertToString(horizontalClass);
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("class", (Object)value, null);
        }
        for (UIComponent child : component.getFacetChildren("split")) {
            responseWriter.startElement("li", (UIComponent)component);
            child.encodeAll(facesContext);
            responseWriter.endElement("li");
        }
        responseWriter.endElement("ul");
        responseWriter.endElement("div");
    }

    public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String type;
        AbstractCommandButton component = (AbstractCommandButton)uiComponent;
        String clientId = component.getClientId(facesContext);
        String string = type = CommandButtonRenderer.isEqual("client", component.getAttributes().get("mode").toString()) ? "button" : component.getAttributes().get("type").toString();
        if (component.hasFacet("split")) {
            this.renderSplit(responseWriter, facesContext, (UIComponent)component, type);
        } else {
            this.renderCommandButton(responseWriter, facesContext, (UIComponent)component, type, CommandButtonRenderer.convertToBoolean("false"));
        }
    }

    public boolean getRendersChildren() {
        return true;
    }
}

