/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.bootstrap.resource;

import com.google.common.collect.ImmutableList;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;
import org.richfaces.application.configuration.ConfigurationServiceHelper;
import org.richfaces.bootstrap.BootstrapConfiguration;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.ResourceLibrary;

public class CssLibrary
implements ResourceLibrary {
    private static final ImmutableList<ResourceKey> BOOTSTRAP_MIN = ImmutableList.of((Object)ResourceKey.create((String)"min/rf-bootstrap-css.css", (String)"org.richfaces"));
    private static final ImmutableList<ResourceKey> BOOTSTRAP_RESPONSIVE_MIN = ImmutableList.of((Object)ResourceKey.create((String)"min/rf-bootstrap-responsive.css", (String)"org.richfaces"));
    private static final ImmutableList<ResourceKey> BOOTSTRAP_CLIENT_SIDE = ImmutableList.of((Object)ResourceKey.create((String)"bootstrap.less", (String)"org.richfaces.develop"), (Object)ResourceKey.create((String)"less.min.js", (String)"less"), (Object)ResourceKey.create((String)"less.instant.js", (String)"less"));
    private static final ImmutableList<ResourceKey> BOOTSTRAP_RESPONSIVE_CLIENT_SIDE = ImmutableList.of((Object)ResourceKey.create((String)"bootstrap-responsive.less", (String)"org.richfaces.develop"), (Object)ResourceKey.create((String)"less.min.js", (String)"less"), (Object)ResourceKey.create((String)"less.instant.js", (String)"less"));

    public Iterable<ResourceKey> getResources() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ProjectStage stage = facesContext.getApplication().getProjectStage();
        Boolean isResponsive = ConfigurationServiceHelper.getBooleanConfigurationValue((FacesContext)facesContext, (Enum)BootstrapConfiguration.Items.responsiveDesign);
        Boolean isClientSideStyle = ConfigurationServiceHelper.getBooleanConfigurationValue((FacesContext)facesContext, (Enum)BootstrapConfiguration.Items.clientSideStyle);
        if (ProjectStage.Production != stage && isClientSideStyle.booleanValue()) {
            if (isResponsive.booleanValue()) {
                return BOOTSTRAP_RESPONSIVE_CLIENT_SIDE;
            }
            return BOOTSTRAP_CLIENT_SIDE;
        }
        if (isResponsive.booleanValue()) {
            return BOOTSTRAP_RESPONSIVE_MIN;
        }
        return BOOTSTRAP_MIN;
    }
}

