/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.richfaces.renderkit.html.BaseGradient;
import org.richfaces.renderkit.html.images.GradientType;

public class Base2WayGradient
extends BaseGradient {
    public Base2WayGradient(boolean horizontal) {
        super(horizontal);
    }

    public Base2WayGradient(int width, int height, boolean horizontal) {
        super(width, height, horizontal);
    }

    public Base2WayGradient(int width, int height, int gradientHeight, boolean horizontal) {
        super(width, height, gradientHeight, horizontal);
    }

    public Base2WayGradient(int width, int height, int gradientHeight, String baseColor, String gradientColor, boolean horizontal) {
        super(width, height, gradientHeight, baseColor, gradientColor, horizontal);
    }

    public Base2WayGradient(int width, int height, int gradientHeight, String baseColor, String gradientColor) {
        super(width, height, gradientHeight, baseColor, gradientColor);
    }

    public Base2WayGradient(int width, int height, int gradientHeight) {
        super(width, height, gradientHeight);
    }

    public Base2WayGradient(int width, int height, String baseColor, String gradientColor, boolean horizontal) {
        super(width, height, baseColor, gradientColor, horizontal);
    }

    public Base2WayGradient(int width, int height, String baseColor, String gradientColor) {
        super(width, height, baseColor, gradientColor);
    }

    public Base2WayGradient(int width, int height) {
        super(width, height);
    }

    public Base2WayGradient(String baseColor, String gradientColor, boolean horizontal) {
        super(baseColor, gradientColor, horizontal);
    }

    public Base2WayGradient(String baseColor, String gradientColor) {
        super(baseColor, gradientColor);
    }

    protected void drawBackGradient(Graphics2D g2d, Rectangle2D rectangle, GradientType.BiColor colors, int height) {
        if (colors != null) {
            GradientPaint gragient = new GradientPaint(0.0f, (float)(rectangle.getHeight() - (double)height), colors.getBottomColor(), 0.0f, (float)rectangle.getHeight(), colors.getTopColor());
            g2d.setPaint(gragient);
            g2d.fill(rectangle);
        }
    }

    protected void paintGradient(Graphics2D g2d, Dimension dim) {
        if (this.headerBackgroundColor != null && this.headerGradientColor != null) {
            int localGradientHeight;
            GradientType.BiColor biColor = new GradientType.BiColor(this.headerBackgroundColor, this.headerGradientColor);
            GradientType.BiColor firstLayer = this.gradientType.getFirstLayerColors(biColor);
            GradientType.BiColor secondLayer = this.gradientType.getSecondLayerColors(biColor);
            if (this.isHorizontal()) {
                g2d.transform(new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f));
                dim.setSize(dim.height, dim.width);
            }
            if ((localGradientHeight = this.getGradientHeight()) < 0) {
                localGradientHeight = dim.height / 2;
            }
            Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, dim.width, localGradientHeight);
            this.drawGradient(g2d, rect, firstLayer, localGradientHeight);
            rect = new Rectangle2D.Float(0.0f, localGradientHeight, dim.width, dim.height);
            this.drawBackGradient(g2d, rect, firstLayer, localGradientHeight);
            int smallGradientHeight = localGradientHeight / 2;
            rect = new Rectangle2D.Float(0.0f, 0.0f, dim.width, smallGradientHeight);
            this.drawGradient(g2d, rect, secondLayer, smallGradientHeight);
            rect = new Rectangle2D.Float(0.0f, dim.height - smallGradientHeight, dim.width, dim.height);
            this.drawBackGradient(g2d, rect, secondLayer, smallGradientHeight);
        }
    }
}

