/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.struct.CanonicalMapBuilderImpl;
import org.refcodes.struct.ext.factory.HtmlCanonicalMapFactorySingleton;
import org.refcodes.web.HttpBodyMap;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;

public class HtmlMediaTypeFactory
implements MediaTypeFactory {
    private static MediaType[] MEDIA_TYPES = new MediaType[]{MediaType.TEXT_HTML, MediaType.APPLICATION_XHTML_XML};

    @Override
    public MediaType[] getMediaTypes() {
        return MEDIA_TYPES;
    }

    public <SRC> String toMarshaled(SRC SRC) throws MarshalException {
        return this.toMarshaled((Object)SRC, (Map)null);
    }

    public <SRC> String toMarshaled(SRC SRC, Map<String, String> map) throws MarshalException {
        CanonicalMapBuilderImpl canonicalMapBuilderImpl = new CanonicalMapBuilderImpl(SRC);
        if (SRC.getClass().isArray()) {
            canonicalMapBuilderImpl = new CanonicalMapBuilderImpl((Object)canonicalMapBuilderImpl.retrieveTo(new String[]{"html", "body", "value"}));
            canonicalMapBuilderImpl.put(new String[]{"html", "body", TYPE_ANNOTATION}, SRC.getClass().getName());
        } else if (Collection.class.isAssignableFrom(SRC.getClass())) {
            canonicalMapBuilderImpl = new CanonicalMapBuilderImpl((Object)canonicalMapBuilderImpl.retrieveTo(new String[]{"html", "body", "value"}));
            canonicalMapBuilderImpl.put(new String[]{"html", "body", TYPE_ANNOTATION}, SRC.getClass().getName());
        }
        return HtmlCanonicalMapFactorySingleton.getInstance().toMarshaled((CanonicalMap)canonicalMapBuilderImpl);
    }

    public <T> T toUnmarshaled(String string, Class<T> clazz) throws UnmarshalException {
        return this.toUnmarshaled(string, clazz, null);
    }

    public <T> T toUnmarshaled(String string, Class<T> clazz, Map<String, String> map) throws UnmarshalException {
        CanonicalMap.CanonicalMapBuilder canonicalMapBuilder = HtmlCanonicalMapFactorySingleton.getInstance().toUnmarshaled(string, map);
        if (clazz.isArray()) {
            canonicalMapBuilder = canonicalMapBuilder.retrieveFrom(new String[]{"html", "body", "value"});
        } else if (Collection.class.isAssignableFrom(clazz)) {
            canonicalMapBuilder = canonicalMapBuilder.retrieveFrom(new String[]{"html", "body", "value"});
        } else {
            if (clazz.isAssignableFrom(HttpBodyMap.class)) {
                return (T)((Object)new HttpBodyMap(canonicalMapBuilder));
            }
            canonicalMapBuilder = canonicalMapBuilder.retrieveFrom(new String[]{"html", "body"});
        }
        return (T)canonicalMapBuilder.toType(clazz);
    }

    @Override
    public <T> T fromMarshaled(InputStream inputStream, Class<T> clazz) throws UnmarshalException {
        return this.fromMarshaled(inputStream, clazz, (Map<String, String>)null);
    }

    @Override
    public Object fromMarshaled(InputStream inputStream, Map<String, String> map, Class<?> ... classArray) throws UnmarshalException {
        CanonicalMap.CanonicalMapBuilder canonicalMapBuilder = HtmlCanonicalMapFactorySingleton.getInstance().fromMarshaled(inputStream, map);
        for (Class<?> clazz : classArray) {
            try {
                return canonicalMapBuilder.toType(clazz);
            }
            catch (Exception exception) {
            }
        }
        throw new UnmarshalException("Unable to unmarshal the input stream to fit into one of the provided types.");
    }
}

