/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.util.Collection;
import java.util.Map;
import org.refcodes.data.Delimiter;
import org.refcodes.properties.Properties;
import org.refcodes.properties.PropertiesBuilderImpl;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.Property;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.struct.Relation;
import org.refcodes.web.HttpMediaType;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeAccessor;
import org.refcodes.web.MediaTypeParameter;
import org.refcodes.web.TopLevelType;
import org.refcodes.web.TopLevelTypeAccessor;

public class ContentType
extends PropertiesBuilderImpl
implements TopLevelTypeAccessor,
MediaTypeAccessor,
Properties.PropertiesBuilder,
HttpMediaType {
    private static final long serialVersionUID = 1L;
    private MediaType _mediaType;

    public ContentType(MediaType mediaType) {
        if (mediaType == null) {
            throw new IllegalArgumentException("You must set a <MediaType> and not <null> as a <ContentType> without <MediaType> does not make sense.");
        }
        this._mediaType = mediaType;
    }

    public ContentType(String string) {
        String string2;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("You must set a HTTP content type and not <null> (or an empty >String>) as a <ContentType> without <MediaType> does not make sense.");
        }
        int n = string.indexOf(Delimiter.MEDIA_TYPE_PARAMETERS.getChar());
        if (n != -1) {
            string2 = string.substring(0, n);
            if (string.length() > n) {
                String[] stringArray;
                for (String string3 : stringArray = string.substring(n + 1).split("" + Delimiter.MEDIA_TYPE_PARAMETERS.getChar())) {
                    if (string3 == null) continue;
                    PropertyImpl propertyImpl = new PropertyImpl(string3);
                    this.put(((String)propertyImpl.getKey()).trim(), propertyImpl.getValue() != null ? ((String)propertyImpl.getValue()).trim() : null);
                }
            }
        } else {
            string2 = string;
        }
        string2 = string2.trim();
        this._mediaType = MediaType.fromHttpMediaSubtype(string2);
        if (this._mediaType == null) {
            throw new IllegalArgumentException("Unable to detect valid known Media-Type from argument <" + string + ">.");
        }
    }

    public ContentType(MediaType mediaType, Map<String, String> map) {
        if (mediaType == null) {
            throw new IllegalArgumentException("You must set a <MediaType> and not <null> as a <ContentType> without <MediaType> does not make sense.");
        }
        this._mediaType = mediaType;
        this.putAll(map);
    }

    @Override
    public TopLevelType getTopLevelType() {
        return this.getMediaType().getTopLevelType();
    }

    public String put(MediaTypeParameter mediaTypeParameter, String string) {
        return (String)this.put(mediaTypeParameter.getName(), string);
    }

    public ContentType withPut(MediaTypeParameter mediaTypeParameter, String string) {
        this.put(mediaTypeParameter.getName(), string);
        return this;
    }

    public String getCharsetParametrer() {
        return (String)this.get(MediaTypeParameter.CHARSET.getName());
    }

    public String putCharsetParametrer(String string) {
        return (String)this.put(MediaTypeParameter.CHARSET.getName(), string);
    }

    public ContentType withCharsetParametrer(String string) {
        this.put(MediaTypeParameter.CHARSET.getName(), string);
        return this;
    }

    @Override
    public String toHttpMediaType() {
        String string = null;
        MediaType mediaType = this.getMediaType();
        if (mediaType != null) {
            string = mediaType.toHttpMediaType((Properties)this);
        }
        return string;
    }

    public ContentType withPut(Collection<?> collection, String string) {
        this.put(collection, string);
        return this;
    }

    public ContentType withPut(Object[] objectArray, String string) throws NumberFormatException {
        this.put(objectArray, string);
        return this;
    }

    public ContentType withPut(Relation<String, String> relation) {
        this.put(relation);
        return this;
    }

    public ContentType withPut(String string, String string2) {
        this.put(string, string2);
        return this;
    }

    public ContentType withPut(Property property) {
        this.put(property);
        return this;
    }

    public ContentType withPut(String[] stringArray, String string) {
        this.put(stringArray, string);
        return this;
    }

    public ContentType withPutBoolean(Collection<?> collection, Boolean bl) {
        this.putBoolean(collection, bl);
        return this;
    }

    public ContentType withPutBoolean(Object object, Boolean bl) {
        this.putBoolean(object, bl);
        return this;
    }

    public ContentType withPutBoolean(Object[] objectArray, Boolean bl) {
        this.putBoolean(objectArray, bl);
        return this;
    }

    public ContentType withPutBoolean(String string, Boolean bl) {
        this.putBoolean(string, bl);
        return this;
    }

    public ContentType withPutBoolean(String[] stringArray, Boolean bl) {
        this.putBoolean(stringArray, bl);
        return this;
    }

    public ContentType withPutByte(Collection<?> collection, Byte by) {
        this.putByte(collection, by);
        return this;
    }

    public ContentType withPutByte(Object object, Byte by) {
        this.putByte(object, by);
        return this;
    }

    public ContentType withPutByte(Object[] objectArray, Byte by) {
        this.putByte(objectArray, by);
        return this;
    }

    public ContentType withPutByte(String string, Byte by) {
        this.putByte(string, by);
        return this;
    }

    public ContentType withPutByte(String[] stringArray, Byte by) {
        this.putByte(stringArray, by);
        return this;
    }

    public ContentType withPutChar(Collection<?> collection, Character c) {
        this.putChar(collection, c);
        return this;
    }

    public ContentType withPutChar(Object object, Character c) {
        this.putChar(object, c);
        return this;
    }

    public ContentType withPutChar(Object[] objectArray, Character c) {
        this.putChar(objectArray, c);
        return this;
    }

    public ContentType withPutChar(String string, Character c) {
        this.putChar(string, c);
        return this;
    }

    public ContentType withPutChar(String[] stringArray, Character c) {
        this.putChar(stringArray, c);
        return this;
    }

    public <C> ContentType withPutClass(Collection<?> collection, Class<C> clazz) {
        this.putClass(collection, clazz);
        return this;
    }

    public <C> ContentType withPutClass(Object object, Class<C> clazz) {
        this.putClass(object, clazz);
        return this;
    }

    public <C> ContentType withPutClass(Object[] objectArray, Class<C> clazz) {
        this.putClass(objectArray, clazz);
        return this;
    }

    public <C> ContentType withPutClass(String string, Class<C> clazz) {
        this.putClass(string, clazz);
        return this;
    }

    public <C> ContentType withPutClass(String[] stringArray, Class<C> clazz) {
        this.putClass(stringArray, clazz);
        return this;
    }

    public ContentType withPutDouble(Collection<?> collection, Double d) {
        this.putDouble(collection, d);
        return this;
    }

    public ContentType withPutDouble(Object object, Double d) {
        this.putDouble(object, d);
        return this;
    }

    public ContentType withPutDouble(Object[] objectArray, Double d) {
        this.putDouble(objectArray, d);
        return this;
    }

    public ContentType withPutDouble(String string, Double d) {
        this.putDouble(string, d);
        return this;
    }

    public ContentType withPutDouble(String[] stringArray, Double d) {
        this.putDouble(stringArray, d);
        return this;
    }

    public <E extends Enum<E>> ContentType withPutEnum(Collection<?> collection, E e) {
        this.putEnum(collection, e);
        return this;
    }

    public <E extends Enum<E>> ContentType withPutEnum(Object object, E e) {
        this.putEnum(object, e);
        return this;
    }

    public <E extends Enum<E>> ContentType withPutEnum(Object[] objectArray, E e) {
        this.putEnum(objectArray, e);
        return this;
    }

    public <E extends Enum<E>> ContentType withPutEnum(String string, E e) {
        this.putEnum(string, e);
        return this;
    }

    public <E extends Enum<E>> ContentType withPutEnum(String[] stringArray, E e) {
        this.putEnum(stringArray, e);
        return this;
    }

    public ContentType withPutFloat(Collection<?> collection, Float f) {
        this.putFloat(collection, f);
        return this;
    }

    public ContentType withPutFloat(Object object, Float f) {
        this.putFloat(object, f);
        return this;
    }

    public ContentType withPutFloat(Object[] objectArray, Float f) {
        this.putFloat(objectArray, f);
        return this;
    }

    public ContentType withPutFloat(String string, Float f) {
        this.putFloat(string, f);
        return this;
    }

    public ContentType withPutFloat(String[] stringArray, Float f) {
        this.putFloat(stringArray, f);
        return this;
    }

    public ContentType withPutInt(Collection<?> collection, Integer n) {
        this.putInt(collection, n);
        return this;
    }

    public ContentType withPutInt(Object object, Integer n) {
        this.putInt(object, n);
        return this;
    }

    public ContentType withPutInt(Object[] objectArray, Integer n) {
        this.putInt(objectArray, n);
        return this;
    }

    public ContentType withPutInt(String string, Integer n) {
        this.putInt(string, n);
        return this;
    }

    public ContentType withPutInt(String[] stringArray, Integer n) {
        this.putInt(stringArray, n);
        return this;
    }

    public ContentType withPutLong(Collection<?> collection, Long l) {
        this.putLong(collection, l);
        return this;
    }

    public ContentType withPutLong(Object object, Long l) {
        this.putLong(object, l);
        return this;
    }

    public ContentType withPutLong(Object[] objectArray, Long l) {
        this.putLong(objectArray, l);
        return this;
    }

    public ContentType withPutLong(String string, Long l) {
        this.putLong(string, l);
        return this;
    }

    public ContentType withPutLong(String[] stringArray, Long l) {
        this.putLong(stringArray, l);
        return this;
    }

    public ContentType withPutShort(Collection<?> collection, Short s) {
        this.putShort(collection, s);
        return this;
    }

    public ContentType withPutShort(Object object, Short s) {
        this.putShort(object, s);
        return this;
    }

    public ContentType withPutShort(Object[] objectArray, Short s) {
        this.putShort(objectArray, s);
        return this;
    }

    public ContentType withPutShort(String string, Short s) {
        this.putShort(string, s);
        return this;
    }

    public ContentType withPutShort(String[] stringArray, Short s) {
        this.putShort(stringArray, s);
        return this;
    }

    public ContentType withPutString(Collection<?> collection, String string) {
        this.putString(collection, string);
        return this;
    }

    public ContentType withPutString(Object object, String string) {
        this.putString(object, string);
        return this;
    }

    public ContentType withPutString(Object[] objectArray, String string) {
        this.putString(objectArray, string);
        return this;
    }

    public ContentType withPutString(String string, String string2) {
        this.putString(string, string2);
        return this;
    }

    public ContentType withPutString(String[] stringArray, String string) {
        this.putString(stringArray, string);
        return this;
    }

    public ContentType withInsert(Object object) {
        this.insert(object);
        return this;
    }

    public ContentType withInsert(PathMap<String> pathMap) {
        this.insert(pathMap);
        return this;
    }

    public ContentType withInsertBetween(Collection<?> collection, Object object, Collection<?> collection2) {
        this.insertBetween(collection, object, collection2);
        return this;
    }

    public ContentType withInsertBetween(Collection<?> collection, PathMap<String> pathMap, Collection<?> collection2) {
        this.insertBetween(collection, pathMap, collection2);
        return this;
    }

    public ContentType withInsertBetween(Object object, Object object2, Object object3) {
        this.insertBetween(object, object2, object3);
        return this;
    }

    public ContentType withInsertBetween(Object object, PathMap<String> pathMap, Object object2) {
        this.insertBetween(object, pathMap, object2);
        return this;
    }

    public ContentType withInsertBetween(Object[] objectArray, Object object, Object[] objectArray2) {
        this.insertBetween(objectArray, object, objectArray2);
        return this;
    }

    public ContentType withInsertBetween(Object[] objectArray, PathMap<String> pathMap, Object[] objectArray2) {
        this.insertBetween(objectArray, pathMap, objectArray2);
        return this;
    }

    public ContentType withInsertBetween(String string, Object object, String string2) {
        this.insertBetween(string, object, string2);
        return this;
    }

    public ContentType withInsertBetween(String string, PathMap<String> pathMap, String string2) {
        this.insertBetween(string, pathMap, string2);
        return this;
    }

    public ContentType withInsertBetween(String[] stringArray, Object object, String[] stringArray2) {
        this.insertBetween(stringArray, object, stringArray2);
        return this;
    }

    public ContentType withInsertBetween(String[] stringArray, PathMap<String> pathMap, String[] stringArray2) {
        this.insertBetween(stringArray, pathMap, stringArray2);
        return this;
    }

    public ContentType withInsertFrom(Object object, Collection<?> collection) {
        this.insertFrom(object, collection);
        return this;
    }

    public ContentType withInsertFrom(Object object, Object object2) {
        this.insertFrom(object, object2);
        return this;
    }

    public ContentType withInsertFrom(Object object, Object ... objectArray) {
        this.withInsertFrom(object, objectArray);
        return this;
    }

    public ContentType withInsertFrom(Object object, String string) {
        this.insertFrom(object, string);
        return this;
    }

    public ContentType withInsertFrom(Object object, String ... stringArray) {
        this.insertFrom(object, stringArray);
        return this;
    }

    public ContentType withInsertFrom(PathMap<String> pathMap, Collection<?> collection) {
        this.insertFrom(pathMap, collection);
        return this;
    }

    public ContentType withInsertFrom(PathMap<String> pathMap, Object object) {
        this.insertFrom(pathMap, object);
        return this;
    }

    public ContentType withInsertFrom(PathMap<String> pathMap, Object ... objectArray) {
        this.withInsertFrom((PathMap)pathMap, objectArray);
        return this;
    }

    public ContentType withInsertFrom(PathMap<String> pathMap, String string) {
        this.insertFrom(pathMap, string);
        return this;
    }

    public ContentType withInsertFrom(PathMap<String> pathMap, String ... stringArray) {
        this.insertFrom(pathMap, stringArray);
        return this;
    }

    public ContentType withInsertTo(Collection<?> collection, Object object) {
        this.insertTo(collection, object);
        return this;
    }

    public ContentType withInsertTo(Collection<?> collection, PathMap<String> pathMap) {
        this.insertTo(collection, pathMap);
        return this;
    }

    public ContentType withInsertTo(Object object, Object object2) {
        this.insertTo(object, object2);
        return this;
    }

    public ContentType withInsertTo(Object object, PathMap<String> pathMap) {
        this.insertTo(object, pathMap);
        return this;
    }

    public ContentType withInsertTo(Object[] objectArray, Object object) {
        this.insertTo(objectArray, object);
        return this;
    }

    public ContentType withInsertTo(Object[] objectArray, PathMap<String> pathMap) {
        this.insertTo(objectArray, pathMap);
        return this;
    }

    public ContentType withInsertTo(String string, Object object) {
        this.insertTo(string, object);
        return this;
    }

    public ContentType withInsertTo(String string, PathMap<String> pathMap) {
        this.insertTo(string, pathMap);
        return this;
    }

    public ContentType withInsertTo(String[] stringArray, Object object) {
        this.insertTo(stringArray, object);
        return this;
    }

    public ContentType withInsertTo(String[] stringArray, PathMap<String> pathMap) {
        this.insertTo(stringArray, pathMap);
        return this;
    }

    public ContentType withMerge(Object object) {
        this.merge(object);
        return this;
    }

    public ContentType withMerge(PathMap<String> pathMap) {
        this.merge(pathMap);
        return this;
    }

    public ContentType withMergeBetween(Collection<?> collection, Object object, Collection<?> collection2) {
        this.mergeBetween(collection, object, collection2);
        return this;
    }

    public ContentType withMergeBetween(Collection<?> collection, PathMap<String> pathMap, Collection<?> collection2) {
        this.mergeBetween(collection, pathMap, collection2);
        return this;
    }

    public ContentType withMergeBetween(Object object, Object object2, Object object3) {
        this.mergeBetween(object, object2, object3);
        return this;
    }

    public ContentType withMergeBetween(Object object, PathMap<String> pathMap, Object object2) {
        this.mergeBetween(object, pathMap, object2);
        return this;
    }

    public ContentType withMergeBetween(Object[] objectArray, Object object, Object[] objectArray2) {
        this.mergeBetween(objectArray, object, objectArray2);
        return this;
    }

    public ContentType withMergeBetween(Object[] objectArray, PathMap<String> pathMap, Object[] objectArray2) {
        this.mergeBetween(objectArray, objectArray2, objectArray2);
        return this;
    }

    public ContentType withMergeBetween(String string, Object object, String string2) {
        this.mergeBetween(string, object, string2);
        return this;
    }

    public ContentType withMergeBetween(String string, PathMap<String> pathMap, String string2) {
        this.mergeBetween(string, pathMap, string2);
        return this;
    }

    public ContentType withMergeBetween(String[] stringArray, Object object, String[] stringArray2) {
        this.mergeBetween(stringArray, object, stringArray2);
        return this;
    }

    public ContentType withMergeBetween(String[] stringArray, PathMap<String> pathMap, String[] stringArray2) {
        this.mergeBetween(stringArray, pathMap, stringArray2);
        return this;
    }

    public ContentType withMergeFrom(Object object, Collection<?> collection) {
        this.mergeFrom(object, collection);
        return this;
    }

    public ContentType withMergeFrom(Object object, Object object2) {
        this.mergeFrom(object, object2);
        return this;
    }

    public ContentType withMergeFrom(Object object, Object ... objectArray) {
        this.mergeFrom(object, objectArray);
        return this;
    }

    public ContentType withMergeFrom(Object object, String string) {
        this.mergeFrom(object, string);
        return this;
    }

    public ContentType withMergeFrom(Object object, String ... stringArray) {
        this.mergeFrom(object, stringArray);
        return this;
    }

    public ContentType withMergeFrom(PathMap<String> pathMap, Collection<?> collection) {
        this.mergeFrom(pathMap, collection);
        return this;
    }

    public ContentType withMergeFrom(PathMap<String> pathMap, Object object) {
        this.mergeFrom(pathMap, object);
        return this;
    }

    public ContentType withMergeFrom(PathMap<String> pathMap, Object ... objectArray) {
        this.mergeFrom(pathMap, objectArray);
        return this;
    }

    public ContentType withMergeFrom(PathMap<String> pathMap, String string) {
        this.mergeFrom(pathMap, string);
        return this;
    }

    public ContentType withMergeFrom(PathMap<String> pathMap, String ... stringArray) {
        this.mergeFrom(pathMap, stringArray);
        return this;
    }

    public ContentType withMergeTo(Collection<?> collection, Object object) {
        this.mergeTo(collection, object);
        return this;
    }

    public ContentType withMergeTo(Collection<?> collection, PathMap<String> pathMap) {
        this.mergeTo(collection, pathMap);
        return this;
    }

    public ContentType withMergeTo(Object object, Object object2) {
        this.mergeTo(object, object2);
        return this;
    }

    public ContentType withMergeTo(Object object, PathMap<String> pathMap) {
        this.mergeTo(object, pathMap);
        return this;
    }

    public ContentType withMergeTo(Object[] objectArray, Object object) {
        this.mergeTo(objectArray, object);
        return this;
    }

    public ContentType withMergeTo(Object[] objectArray, PathMap<String> pathMap) {
        this.mergeTo(objectArray, pathMap);
        return this;
    }

    public ContentType withMergeTo(String string, Object object) {
        this.mergeTo(string, object);
        return this;
    }

    public ContentType withMergeTo(String string, PathMap<String> pathMap) {
        this.mergeTo(string, pathMap);
        return this;
    }

    public ContentType withMergeTo(String[] stringArray, Object object) {
        this.mergeTo(stringArray, object);
        return this;
    }

    public ContentType withMergeTo(String[] stringArray, PathMap<String> pathMap) {
        this.mergeTo(stringArray, pathMap);
        return this;
    }

    public ContentType withPutDirAt(Collection<?> collection, int n, Object object) throws IllegalArgumentException {
        this.putDirAt(collection, n, object);
        return this;
    }

    public ContentType withPutDirAt(Collection<?> collection, int n, PathMap<String> pathMap) throws IllegalArgumentException {
        this.putDirAt(collection, n, pathMap);
        return this;
    }

    public ContentType withPutDirAt(int n, Object object) throws IllegalArgumentException {
        this.putDirAt(n, object);
        return this;
    }

    public ContentType withPutDirAt(int n, PathMap<String> pathMap) throws IllegalArgumentException {
        this.putDirAt(n, pathMap);
        return this;
    }

    public ContentType withPutDirAt(Object object, int n, Object object2) throws IllegalArgumentException {
        this.putDirAt(object, n, object2);
        return this;
    }

    public ContentType withPutDirAt(Object object, int n, PathMap<String> pathMap) throws IllegalArgumentException {
        this.putDirAt(object, n, pathMap);
        return this;
    }

    public ContentType withPutDirAt(Object[] objectArray, int n, Object object) throws IllegalArgumentException {
        this.putDirAt(objectArray, n, object);
        return this;
    }

    public ContentType withPutDirAt(Object[] objectArray, int n, PathMap<String> pathMap) throws IllegalArgumentException {
        this.putDirAt(objectArray, n, pathMap);
        return this;
    }

    public ContentType withPutDirAt(String string, int n, Object object) throws IllegalArgumentException {
        this.putDirAt(string, n, object);
        return this;
    }

    public ContentType withPutDirAt(String string, int n, PathMap<String> pathMap) throws IllegalArgumentException {
        this.putDirAt(string, n, pathMap);
        return this;
    }

    public ContentType withPutDirAt(String[] stringArray, int n, Object object) throws IllegalArgumentException {
        this.putDirAt(stringArray, n, object);
        return this;
    }

    public ContentType withPutDirAt(String[] stringArray, int n, PathMap<String> pathMap) throws IllegalArgumentException {
        this.putDirAt(stringArray, n, pathMap);
        return this;
    }

    public ContentType withRemoveFrom(Collection<?> collection) {
        this.removeFrom(collection);
        return this;
    }

    public ContentType withRemoveFrom(Object object) {
        this.removeFrom(object);
        return this;
    }

    public ContentType withRemoveFrom(Object ... objectArray) {
        this.removeFrom(objectArray);
        return this;
    }

    public ContentType withRemoveFrom(String string) {
        this.removeFrom(string);
        return this;
    }

    public ContentType withRemoveFrom(String ... stringArray) {
        this.removeFrom(stringArray);
        return this;
    }

    public ContentType withRemovePaths(String ... stringArray) {
        this.removeFrom(stringArray);
        return this;
    }

    @Override
    public MediaType getMediaType() {
        return this._mediaType;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._mediaType == null ? 0 : this._mediaType.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ContentType contentType = (ContentType)object;
        return this._mediaType == contentType._mediaType;
    }

    public String toString() {
        return this._mediaType.toHttpMediaType();
    }
}

