/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import org.refcodes.data.Encoding;
import org.refcodes.web.AuthType;
import org.refcodes.web.AuthTypeCredentials;
import org.refcodes.web.BasicCredentials;
import org.refcodes.web.ForbiddenException;

public class BasicAuthCredentials
extends BasicCredentials
implements AuthTypeCredentials<BasicAuthCredentials, BasicCredentials> {
    public static final char DELIMITER_BASIC_AUTH = ' ';
    public static final char DELIMITER_CREDENTIALS = ':';

    public BasicAuthCredentials() {
    }

    public BasicAuthCredentials(String string, String string2) {
        super(string, string2);
    }

    @Override
    public void validate(BasicCredentials basicCredentials) throws ForbiddenException {
        if (!this.isValid(basicCredentials)) {
            throw new ForbiddenException("Access denied as of unsuccessful authentification!");
        }
    }

    public void validate(String string, String string2) throws ForbiddenException {
        if (!this.isValid(string, string2)) {
            throw new ForbiddenException("Access denied as of unsuccessfull authentification!");
        }
    }

    @Override
    public BasicAuthCredentials withHttpAuthorization(String string) throws IllegalArgumentException {
        this.fromHttpAuthorization(string);
        return this;
    }

    @Override
    public AuthType getAuthType() {
        return AuthType.BASIC;
    }

    @Override
    public String getIdentity() {
        return this._identity;
    }

    @Override
    public String getSecret() {
        return this._secret;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._secret == null ? 0 : this._secret.hashCode());
        n = 31 * n + (this._identity == null ? 0 : this._identity.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BasicAuthCredentials)) {
            return false;
        }
        BasicAuthCredentials basicAuthCredentials = (BasicAuthCredentials)object;
        if (this._secret == null ? basicAuthCredentials._secret != null : !this._secret.equals(basicAuthCredentials._secret)) {
            return false;
        }
        return !(this._identity == null ? basicAuthCredentials._identity != null : !this._identity.equalsIgnoreCase(basicAuthCredentials._identity));
    }

    public String toString() {
        return "<" + this._identity + "> with secret <...>";
    }

    @Override
    public void fromHttpAuthorization(String string) {
        String string2;
        if (string == null) {
            throw new IllegalArgumentException("The provided HTTP authorization value does not conform to the format expected for Basic-Authentication.");
        }
        int n = string.indexOf(32);
        if (n == -1 || !string.substring(0, n).equals(AuthType.BASIC.getName())) {
            throw new IllegalArgumentException("The provided HTTP authorization value does not conform to the format expected for Basic-Authentication.");
        }
        byte[] byArray = Base64.getDecoder().decode(string.substring(n + 1));
        try {
            string2 = new String(byArray, Encoding.UTF_8.getCode());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = new String(byArray);
        }
        n = string2.indexOf(58);
        this._identity = string2.substring(0, n);
        this._secret = string2.substring(n + 1);
    }

    @Override
    public String toHttpAuthorization() {
        Object object = this.getIdentity() + ":" + this.getSecret();
        try {
            object = Base64.getEncoder().encodeToString(((String)object).getBytes(Encoding.UTF_8.getCode()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = Base64.getEncoder().encodeToString(((String)object).getBytes());
        }
        object = AuthType.BASIC.getName() + " " + (String)object;
        return object;
    }
}

