/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.data.ConsoleDimension;
import org.refcodes.data.Text;
import org.refcodes.mixin.EscapeCodesStatusAccessor;
import org.refcodes.mixin.RowHeightAccessor;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.TextLineBuilder;
import org.refcodes.textual.VertAlignTextMode;
import org.refcodes.textual.VertAlignTextModeAccessor;

public class VertAlignTextBuilder
extends AbstractText<VertAlignTextBuilder>
implements RowHeightAccessor.RowHeightBuilder<VertAlignTextBuilder>,
RowHeightAccessor.RowHeightProperty,
VertAlignTextModeAccessor.VertAlignTextModeProperty,
VertAlignTextModeAccessor.VertAlignTextModeBuilder<VertAlignTextBuilder>,
EscapeCodesStatusAccessor.EscapeCodeStatusProperty,
EscapeCodesStatusAccessor.EscapeCodeStatusBuilder<VertAlignTextBuilder> {
    private int _rowHeight = ConsoleDimension.MIN_HEIGHT.getValue();
    private VertAlignTextMode _alignTextMode = VertAlignTextMode.TOP;
    private char _fillChar = (char)32;
    private boolean _isEscapeCodesEnabled = false;

    public VertAlignTextBuilder build() {
        return new VertAlignTextBuilder();
    }

    public char getFillChar() {
        return this._fillChar;
    }

    public int getRowHeight() {
        return this._rowHeight;
    }

    @Override
    public VertAlignTextMode getVertAlignTextMode() {
        return this._alignTextMode;
    }

    public boolean isEscapeCodesEnabled() {
        return this._isEscapeCodesEnabled;
    }

    public void setEscapeCodesEnabled(boolean isEscCodesEnabled) {
        this._isEscapeCodesEnabled = isEscCodesEnabled;
    }

    public void setFillChar(char aFillChar) {
        this._fillChar = aFillChar;
    }

    public void setRowHeight(int aRowHeight) {
        this._rowHeight = aRowHeight;
    }

    @Override
    public void setVertAlignTextMode(VertAlignTextMode aVertAlignTextMode) {
        this._alignTextMode = aVertAlignTextMode;
    }

    @Override
    public String[] toStrings() {
        return VertAlignTextBuilder.asAligned(this.getText(), this._rowHeight, this._fillChar, this._alignTextMode, this._isEscapeCodesEnabled);
    }

    @Override
    public String[] toStrings(String ... aText) {
        return VertAlignTextBuilder.asAligned(aText, this._rowHeight, this._fillChar, this._alignTextMode, this._isEscapeCodesEnabled);
    }

    public VertAlignTextBuilder withEscapeCodesEnabled(boolean isEscCodesEnabled) {
        this.setEscapeCodesEnabled(isEscCodesEnabled);
        return this;
    }

    public VertAlignTextBuilder withFillChar(char aFillChar) {
        this.setFillChar(aFillChar);
        return this;
    }

    public VertAlignTextBuilder withRowHeight(int aRowHeight) {
        this.setRowHeight(aRowHeight);
        return this;
    }

    @Override
    public VertAlignTextBuilder withVertAlignTextMode(VertAlignTextMode aVertAlignTextMode) {
        this.setVertAlignTextMode(aVertAlignTextMode);
        return this;
    }

    public static String[] asAligned(String[] aTextBlock, int aHeight, char aFillChar, VertAlignTextMode aVertAlignTextMode) {
        return VertAlignTextBuilder.asAligned(aTextBlock, aHeight, aFillChar, aVertAlignTextMode, false);
    }

    public static String[] asAligned(String[] aTextBlock, int aHeight, VertAlignTextMode aVertAlignTextMode) {
        return VertAlignTextBuilder.asAligned(aTextBlock, aHeight, ' ', aVertAlignTextMode, false);
    }

    public static String[] asAligned(String[] aTextBlock, int aHeight, VertAlignTextMode aVertAlignTextMode, boolean isEscCodesEnabled) {
        return VertAlignTextBuilder.asAligned(aTextBlock, aHeight, ' ', aVertAlignTextMode, isEscCodesEnabled);
    }

    public static String[] asAligned(String[] aTextBlock, int aHeight, char aFillChar, VertAlignTextMode aVertAlignTextMode, boolean isEscCodesEnabled) {
        if (aTextBlock == null || aHeight == aTextBlock.length) {
            return aTextBlock;
        }
        String theLine = null;
        String[] theLines = new String[aHeight];
        int theWidth = AnsiEscapeCode.toLength((String)aTextBlock[0], (boolean)isEscCodesEnabled);
        switch (aVertAlignTextMode) {
            case BOTTOM: {
                throw new RuntimeException(Text.NOT_YET_IMPLEMENTED.getText());
            }
            case MIDDLE: {
                throw new RuntimeException(Text.NOT_YET_IMPLEMENTED.getText());
            }
            case TOP: {
                for (int i = 0; i < theLines.length; ++i) {
                    if (i < aTextBlock.length) {
                        theLines[i] = aTextBlock[i];
                        continue;
                    }
                    if (theLine == null && aTextBlock != null && aTextBlock.length > 0) {
                        theLine = new TextLineBuilder().withColumnWidth(theWidth).withLineChar(aFillChar).toString();
                    }
                    theLines[i] = theLine;
                }
                return theLines;
            }
        }
        throw new IllegalArgumentException("You must provided a supported value for the vertical align mode, though you provided <" + String.valueOf((Object)aVertAlignTextMode) + ">. The code seems to be out of date, please participate in getting the code even better. See <http://www.refcodes.org> and <https://birbucket.org/refcodes>.");
    }
}

