/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.refcodes.data.Delimiter;
import org.refcodes.textual.CsvEscapeMode;
import org.refcodes.textual.CsvMixin;

public class CsvBuilder
implements CsvMixin {
    private String _record = null;
    private Collection<Object> _fields = null;
    private char _delimiterChar = Delimiter.CSV.getChar();
    private CsvEscapeMode _csvEscapeMode = CsvEscapeMode.ESCAPED;
    private boolean _isTrim = true;
    private String[] _commentPrefixes = null;

    public void setTrim(boolean isTrim) {
        this._isTrim = isTrim;
    }

    public boolean isTrim() {
        return this._isTrim;
    }

    @Override
    public CsvEscapeMode getCsvEscapeMode() {
        return this._csvEscapeMode;
    }

    @Override
    public void setCsvEscapeMode(CsvEscapeMode aCsvEscapeMode) {
        this._csvEscapeMode = aCsvEscapeMode;
    }

    public void setRecord(String aRecord) {
        this._record = aRecord;
    }

    public String getRecord() {
        return this._record;
    }

    public void setFields(Object ... aFields) {
        this._fields = CsvBuilder.toCollection(aFields);
    }

    public Collection<Object> getFields() {
        return this._fields;
    }

    public void setFields(Collection<Object> aFields) {
        this._fields = aFields;
    }

    public char getDelimiter() {
        return this._delimiterChar;
    }

    public void setDelimiter(char aDelimiterChar) {
        this._delimiterChar = aDelimiterChar;
    }

    public List<String> toFields() {
        if (!this.isComment(this._record)) {
            return CsvBuilder.asFields(this._record, this._delimiterChar, this._csvEscapeMode, this._isTrim);
        }
        return null;
    }

    public String toRecord() {
        return CsvBuilder.asRecord(this._fields, this._delimiterChar, this._csvEscapeMode);
    }

    public String toRecord(Object ... aFields) {
        return CsvBuilder.asRecord(CsvBuilder.toCollection(aFields), this._delimiterChar, this._csvEscapeMode);
    }

    public String toRecord(Collection<Object> aFields) {
        return CsvBuilder.asRecord(aFields, this._delimiterChar, this._csvEscapeMode);
    }

    public String[] toStrings() {
        List<String> theCsvElements = this.toFields();
        if (theCsvElements != null) {
            return theCsvElements.toArray(new String[theCsvElements.size()]);
        }
        return null;
    }

    public String toRecord(String ... aFields) {
        return CsvBuilder.asRecord(CsvBuilder.toCollection(aFields), this._delimiterChar, this._csvEscapeMode);
    }

    public String[] toStrings(String aRecord) {
        return CsvBuilder.asStrings(aRecord, this._delimiterChar, this._csvEscapeMode, this._isTrim, this.getCommentPrefixes());
    }

    public String toString() {
        return this.toRecord();
    }

    @Override
    public void setCommentPrefixes(String ... aCommentPrefixes) {
        this._commentPrefixes = aCommentPrefixes;
    }

    @Override
    public String[] getCommentPrefixes() {
        return this._commentPrefixes;
    }

    @Override
    public void clearCommentPrefixes() {
        this._commentPrefixes = null;
    }

    public CsvBuilder withTrim(boolean isTrim) {
        this.setTrim(isTrim);
        return this;
    }

    @Override
    public CsvBuilder withCsvEscapeMode(CsvEscapeMode aCsvEscapeMode) {
        this.setCsvEscapeMode(aCsvEscapeMode);
        return this;
    }

    public CsvBuilder withDelimiter(char aDelimiterChar) {
        this.setDelimiter(aDelimiterChar);
        return this;
    }

    @Override
    public CsvBuilder withCommentPrefixes(String ... aCommentPrefixes) {
        this.setCommentPrefixes(aCommentPrefixes);
        return this;
    }

    public CsvBuilder withRecord(String aRecord) {
        this.setRecord(aRecord);
        return this;
    }

    public void setFields(boolean ... aFields) {
        Boolean[] theFields = new Boolean[aFields.length];
        for (int i = 0; i < theFields.length; ++i) {
            theFields[i] = aFields[i];
        }
        this.setFields((Object[])theFields);
    }

    public void setFields(byte ... aFields) {
        Byte[] theFields = new Byte[aFields.length];
        for (int i = 0; i < theFields.length; ++i) {
            theFields[i] = aFields[i];
        }
        this.setFields((Object[])theFields);
    }

    public void setFields(short ... aFields) {
        Short[] theFields = new Short[aFields.length];
        for (int i = 0; i < theFields.length; ++i) {
            theFields[i] = aFields[i];
        }
        this.setFields((Object[])theFields);
    }

    public void setFields(int ... aFields) {
        Integer[] theFields = new Integer[aFields.length];
        for (int i = 0; i < theFields.length; ++i) {
            theFields[i] = aFields[i];
        }
        this.setFields((Object[])theFields);
    }

    public void setFields(long ... aFields) {
        Long[] theFields = new Long[aFields.length];
        for (int i = 0; i < theFields.length; ++i) {
            theFields[i] = aFields[i];
        }
        this.setFields((Object[])theFields);
    }

    public void setFields(float ... aFields) {
        Float[] theFields = new Float[aFields.length];
        for (int i = 0; i < theFields.length; ++i) {
            theFields[i] = Float.valueOf(aFields[i]);
        }
        this.setFields((Object[])theFields);
    }

    public void setFields(double ... aFields) {
        Double[] theFields = new Double[aFields.length];
        for (int i = 0; i < theFields.length; ++i) {
            theFields[i] = aFields[i];
        }
        this.setFields((Object[])theFields);
    }

    public void setFields(char ... aFields) {
        Character[] theFields = new Character[aFields.length];
        for (int i = 0; i < theFields.length; ++i) {
            theFields[i] = Character.valueOf(aFields[i]);
        }
        this.setFields((Object[])theFields);
    }

    public CsvBuilder withFields(boolean ... aFields) {
        this.setFields(aFields);
        return this;
    }

    public CsvBuilder withFields(byte ... aFields) {
        this.setFields(aFields);
        return this;
    }

    public CsvBuilder withFields(short ... aFields) {
        this.setFields(aFields);
        return this;
    }

    public CsvBuilder withFields(int ... aFields) {
        this.setFields(aFields);
        return this;
    }

    public CsvBuilder withFields(long ... aFields) {
        this.setFields(aFields);
        return this;
    }

    public CsvBuilder withFields(float ... aFields) {
        this.setFields(aFields);
        return this;
    }

    public CsvBuilder withFields(double ... aFields) {
        this.setFields(aFields);
        return this;
    }

    public CsvBuilder withFields(char ... aFields) {
        this.setFields(aFields);
        return this;
    }

    public void setFields(Boolean ... aFields) {
        this.setFields((Object[])aFields);
    }

    public void setFields(Byte ... aFields) {
        this.setFields((Object[])aFields);
    }

    public void setFields(Short ... aFields) {
        this.setFields((Object[])aFields);
    }

    public void setFields(Integer ... aFields) {
        this.setFields((Object[])aFields);
    }

    public void setFields(Long ... aFields) {
        this.setFields((Object[])aFields);
    }

    public void setFields(Float ... aFields) {
        this.setFields((Object[])aFields);
    }

    public void setFields(Double ... aFields) {
        this.setFields((Object[])aFields);
    }

    public void setFields(Character ... aFields) {
        this.setFields((Object[])aFields);
    }

    public void setFields(String ... aFields) {
        this.setFields((Object[])aFields);
    }

    public CsvBuilder withFields(Object ... aFields) {
        this.setFields(aFields);
        return this;
    }

    public CsvBuilder withFields(Boolean ... aFields) {
        this.setFields((Object[])aFields);
        return this;
    }

    public CsvBuilder withFields(Byte ... aFields) {
        this.setFields((Object[])aFields);
        return this;
    }

    public CsvBuilder withFields(Short ... aFields) {
        this.setFields((Object[])aFields);
        return this;
    }

    public CsvBuilder withFields(Integer ... aFields) {
        this.setFields((Object[])aFields);
        return this;
    }

    public CsvBuilder withFields(Long ... aFields) {
        this.setFields((Object[])aFields);
        return this;
    }

    public CsvBuilder withFields(Float ... aFields) {
        this.setFields((Object[])aFields);
        return this;
    }

    public CsvBuilder withFields(Double ... aFields) {
        this.setFields((Object[])aFields);
        return this;
    }

    public CsvBuilder withFields(Character ... aFields) {
        this.setFields((Object[])aFields);
        return this;
    }

    public CsvBuilder withFields(String ... aFields) {
        this.setFields((Object[])aFields);
        return this;
    }

    public CsvBuilder withFields(Collection<Object> aFields) {
        this.setFields(aFields);
        return this;
    }

    public String toRecord(boolean ... aFields) {
        Boolean[] theBoxed = new Boolean[aFields.length];
        Arrays.setAll(theBoxed, n -> aFields[n]);
        return this.toRecord(theBoxed);
    }

    public String toRecord(byte ... aFields) {
        Byte[] theBoxed = new Byte[aFields.length];
        Arrays.setAll(theBoxed, n -> aFields[n]);
        return this.toRecord(theBoxed);
    }

    public String toRecord(short ... aFields) {
        Short[] theBoxed = new Short[aFields.length];
        Arrays.setAll(theBoxed, n -> aFields[n]);
        return this.toRecord(theBoxed);
    }

    public String toRecord(int ... aFields) {
        Integer[] theBoxed = new Integer[aFields.length];
        Arrays.setAll(theBoxed, n -> aFields[n]);
        return this.toRecord(theBoxed);
    }

    public String toRecord(long ... aFields) {
        Long[] theBoxed = new Long[aFields.length];
        Arrays.setAll(theBoxed, n -> aFields[n]);
        return this.toRecord(theBoxed);
    }

    public String toRecord(float ... aFields) {
        Float[] theBoxed = new Float[aFields.length];
        Arrays.setAll(theBoxed, n -> Float.valueOf(aFields[n]));
        return this.toRecord(theBoxed);
    }

    public String toRecord(double ... aFields) {
        Double[] theBoxed = new Double[aFields.length];
        Arrays.setAll(theBoxed, n -> aFields[n]);
        return this.toRecord(theBoxed);
    }

    public String toRecord(char ... aFields) {
        Character[] theBoxed = new Character[aFields.length];
        Arrays.setAll(theBoxed, n -> Character.valueOf(aFields[n]));
        return this.toRecord(theBoxed);
    }

    public String toString(Object ... aFields) {
        return this.toRecord(aFields);
    }

    public String toRecord(Boolean ... aFields) {
        return this.toRecord((Object[])aFields);
    }

    public String toRecord(Byte ... aFields) {
        return this.toRecord((Object[])aFields);
    }

    public String toRecord(Short ... aFields) {
        return this.toRecord((Object[])aFields);
    }

    public String toRecord(Integer ... aFields) {
        return this.toRecord((Object[])aFields);
    }

    public String toRecord(Long ... aFields) {
        return this.toRecord((Object[])aFields);
    }

    public String toRecord(Float ... aFields) {
        return this.toRecord((Object[])aFields);
    }

    public String toRecord(Double ... aFields) {
        return this.toRecord((Object[])aFields);
    }

    public String toRecord(Character ... aFields) {
        return this.toRecord((Object[])aFields);
    }

    public String toString(String ... aFields) {
        return this.toRecord((Object[])aFields);
    }

    public String toString(Collection<Object> aFields) {
        return this.toRecord(aFields.toArray(new Object[aFields.size()]));
    }

    public String[] toFields(String aRecord) {
        return this.toStrings(aRecord);
    }

    static CsvBuilder build() {
        return new CsvBuilder();
    }

    public static List<String> asFields(String aRecord, char aDelimiter, CsvEscapeMode aCsvEscapeMode, boolean isTrim) {
        if (isTrim && aRecord != null && aRecord.length() != 0) {
            aRecord = aRecord.trim();
        }
        switch (aCsvEscapeMode) {
            case ESCAPED: {
                List<String> theFields = CsvBuilder.fromSeparatedValues(aRecord, aDelimiter);
                if (!isTrim) {
                    return theFields;
                }
                ArrayList<String> theTrimmedFields = new ArrayList<String>();
                for (String eField : theFields) {
                    if (eField != null) {
                        eField = eField.trim();
                    }
                    theTrimmedFields.add(eField);
                }
                return theTrimmedFields;
            }
            case NONE: {
                List<String> theFields = CsvBuilder.fromSplitValues(aRecord, aDelimiter);
                if (!isTrim) {
                    return theFields;
                }
                ArrayList<String> theTrimmedValues = new ArrayList<String>();
                for (String eField : theFields) {
                    if (eField != null) {
                        eField = eField.trim();
                    }
                    theTrimmedValues.add(eField);
                }
                return theTrimmedValues;
            }
        }
        throw new IllegalArgumentException("You must pass a valid text overwrite mode, though you actually passed <" + String.valueOf((Object)aCsvEscapeMode) + ">!");
    }

    public static String asRecord(Collection<Object> aFields, char aDelimiter, CsvEscapeMode aCsvEscapeMode) {
        switch (aCsvEscapeMode) {
            case ESCAPED: {
                return CsvBuilder.toSeparatedValues(aFields, aDelimiter);
            }
            case NONE: {
                return CsvBuilder.toSplitValues(aFields, aDelimiter);
            }
        }
        throw new IllegalArgumentException("You must pass a valid text overwrite mode, though you actually passed <" + String.valueOf((Object)aCsvEscapeMode) + ">!");
    }

    public static String[] asStrings(String aRecord, char aDelimiterChar, CsvEscapeMode aCsvEscapeMode, boolean isTrim, String[] aCommentPrefixes) {
        if (!CsvBuilder.isComment(aRecord, aCommentPrefixes)) {
            List<String> theCsvElements = CsvBuilder.asFields(aRecord, aDelimiterChar, aCsvEscapeMode, isTrim);
            return theCsvElements.toArray(new String[theCsvElements.size()]);
        }
        return null;
    }

    private static String toEscapedRegexp(char aDelimiter) {
        return ("" + aDelimiter).replaceAll("\\.", "\\\\.").replaceAll("\\|", "\\\\|");
    }

    private static boolean isComment(String aLine, String[] aCommentPrefixes) {
        if (aCommentPrefixes != null && aLine != null) {
            for (String ePrefix : aCommentPrefixes) {
                if (!aLine.startsWith(ePrefix)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static List<String> fromSeparatedValues(String aSeparatedValues, char aDelimiter) {
        ArrayList<String> theOutputList = new ArrayList<String>();
        if (aSeparatedValues != null && aSeparatedValues.length() != 0) {
            void var8_10;
            ArrayList<Object> theInputList = new ArrayList<Object>();
            String[] theItems = aSeparatedValues.split(CsvBuilder.toEscapedRegexp(aDelimiter));
            ArrayList<String> theTokens = new ArrayList<String>();
            String[] stringArray = theItems;
            int n = stringArray.length;
            boolean bl = false;
            while (var8_10 < n) {
                String theItem = stringArray[var8_10];
                if ("\"\"".equals(theItem)) {
                    theTokens.add("");
                } else {
                    theTokens.add(theItem.replaceAll("\"\"", "\""));
                }
                ++var8_10;
            }
            while (aSeparatedValues.endsWith("" + aDelimiter)) {
                theTokens.add("");
                aSeparatedValues = aSeparatedValues.substring(0, aSeparatedValues.length() - 1);
            }
            String ePreviousItem = null;
            for (String string : theTokens) {
                if (!theInputList.isEmpty()) {
                    ePreviousItem = (String)theInputList.get(theInputList.size() - 1);
                    if (ePreviousItem.startsWith("\"") && !ePreviousItem.endsWith("\"")) {
                        theInputList.remove(theInputList.size() - 1);
                        theInputList.add(ePreviousItem + aDelimiter + string);
                        continue;
                    }
                    theInputList.add(string);
                    continue;
                }
                theInputList.add(string);
            }
            for (String string : theInputList) {
                void var8_14;
                if (string.length() > 1 && string.startsWith("\"") && string.endsWith("\"")) {
                    String string2 = string.substring(1, string.length() - 1);
                }
                var8_14.replaceAll("\"\"", "\"");
                theOutputList.add((String)(var8_14.isEmpty() ? null : var8_14));
            }
        }
        return theOutputList;
    }

    private static String toSeparatedValues(Object[] aArray, char aDelimiter) {
        ArrayList theList = new ArrayList();
        Collections.addAll(theList, aArray);
        return CsvBuilder.toSeparatedValues(theList, aDelimiter);
    }

    private static String toSplitValue(Object aValue, char aDelimiter) {
        char aInnerDelimeter = aDelimiter != Delimiter.ARRAY.getChar() ? Delimiter.ARRAY.getChar() : Delimiter.LIST.getChar();
        if (aValue instanceof String[]) {
            aValue = CsvBuilder.toSplitValues((String[])aValue, aInnerDelimeter);
        } else if (aValue instanceof Object[]) {
            Object[] eItems = (Object[])aValue;
            Object[] eStringItems = new String[eItems.length];
            for (int i = 0; i < eItems.length; ++i) {
                eStringItems[i] = eItems[i] != null ? eItems[i].toString() : null;
            }
            aValue = CsvBuilder.toSplitValues(eStringItems, aInnerDelimeter);
        }
        return aValue.toString();
    }

    private static List<String> fromSplitValues(String aSplitValues, char aDelimiter) {
        return Arrays.asList(aSplitValues.split(CsvBuilder.toEscapedRegexp(aDelimiter)));
    }

    private static String toSplitValues(Object[] aArray, char aDelimiter) {
        ArrayList theList = new ArrayList();
        Collections.addAll(theList, aArray);
        return CsvBuilder.toSplitValues(theList, aDelimiter);
    }

    private static String toSplitValues(Collection<?> aCollection, char aDelimiter) {
        StringBuilder theBuffer = new StringBuilder();
        String eItemString = null;
        Object eItem = null;
        Iterator<?> e = aCollection.iterator();
        while (e.hasNext()) {
            eItem = e.next();
            if (eItem != null) {
                eItemString = CsvBuilder.toSplitValue(eItem, aDelimiter);
                theBuffer.append(eItemString);
            }
            if (!e.hasNext()) continue;
            theBuffer.append(aDelimiter);
        }
        return theBuffer.toString();
    }

    private static String toSeparatedValues(Collection<?> aCollection, char aDelimiter) {
        StringBuilder theBuffer = new StringBuilder();
        String eItemString = null;
        Object eItem = null;
        Iterator<?> e = aCollection.iterator();
        while (e.hasNext()) {
            eItem = e.next();
            if (eItem != null) {
                eItemString = CsvBuilder.toSeparatedValue(eItem, aDelimiter);
                theBuffer.append(eItemString);
            }
            if (!e.hasNext()) continue;
            theBuffer.append(aDelimiter);
        }
        return theBuffer.toString();
    }

    private static String toSeparatedValue(Object aValue, char aDelimiter) {
        char aInnerDelimeter = aDelimiter != Delimiter.ARRAY.getChar() ? Delimiter.ARRAY.getChar() : Delimiter.LIST.getChar();
        if (aValue instanceof String[]) {
            aValue = CsvBuilder.toSeparatedValues((String[])aValue, aInnerDelimeter);
        } else if (aValue instanceof Object[]) {
            Object[] eItems = (Object[])aValue;
            Object[] eStringItems = new String[eItems.length];
            for (int i = 0; i < eItems.length; ++i) {
                eStringItems[i] = eItems[i] != null ? eItems[i].toString() : null;
            }
            aValue = CsvBuilder.toSeparatedValues(eStringItems, aInnerDelimeter);
        }
        Object eItemString = aValue.toString();
        if (((String)eItemString).indexOf(aDelimiter) != -1 || ((String)eItemString).contains("\"")) {
            eItemString = ((String)eItemString).replaceAll("\"", "\"\"");
            eItemString = "\"" + (String)eItemString + "\"";
        }
        return eItemString;
    }

    private static Collection<Object> toCollection(Object[] aFields) {
        if (aFields.length == 1 && aFields[0] instanceof Collection) {
            return (Collection)aFields[0];
        }
        return Arrays.asList(aFields);
    }
}

