/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.Delimiter;
import org.refcodes.mixin.TextAccessor;
import org.refcodes.runtime.Configuration;
import org.refcodes.textual.Case;
import org.refcodes.textual.CaseAccessor;

public class CaseStyleBuilder
implements TextAccessor.TextProperty,
TextAccessor.TextBuilder<CaseStyleBuilder>,
CaseAccessor.CaseProperty,
CaseAccessor.CaseBuilder<CaseStyleBuilder> {
    private String _text = null;
    private Case _case = Case.UPPER;

    public String getText() {
        return this._text;
    }

    public void setText(String aText) {
        this._text = aText;
    }

    public CaseStyleBuilder withText(String aText) {
        this.setText(aText);
        return this;
    }

    @Override
    public Case getCase() {
        return this._case;
    }

    @Override
    public void setCase(Case aCase) {
        this._case = aCase;
    }

    public String toCamelCase() {
        return this.toCamelCase(this.getText());
    }

    public String toSnakeCase() {
        return this.toSnakeCase(this.getText());
    }

    public String toPascalCase() {
        return this.toPascalCase(this.getText());
    }

    public String toKebabCase() {
        return this.toKebabCase(this.getText());
    }

    public String toCamelCase(String aText) {
        return CaseStyleBuilder.asCamelCase(aText);
    }

    public String toSnakeCase(String aText) {
        Case theCase = this._case;
        return CaseStyleBuilder.asSnakeCase(aText, theCase);
    }

    public String toPascalCase(String aText) {
        return CaseStyleBuilder.asPascalCase(aText);
    }

    public String toKebabCase(String aText) {
        Case theCase = this._case;
        return CaseStyleBuilder.asKebabCase(aText, theCase);
    }

    @Override
    public CaseStyleBuilder withCase(Case aCase) {
        this.setCase(aCase);
        return this;
    }

    public static String asCamelCase(String aText) {
        if (aText == null || aText.isEmpty()) {
            return aText;
        }
        String theText = NormalizeCaseUtility.toNormalized(aText, Delimiter.SNAKE_CASE.getChar()).replaceAll("_\u00e4", "\u00c4").replaceAll("_\u00f6", "\u00d6").replaceAll("_\u00fc", "\u00dc").replaceAll("_a", "A").replaceAll("_b", "B").replaceAll("_c", "C").replaceAll("_d", "D").replaceAll("_e", "E").replaceAll("_f", "F").replaceAll("_g", "G").replaceAll("_h", "H").replaceAll("_i", "I").replaceAll("_j", "J").replaceAll("_k", "K").replaceAll("_l", "L").replaceAll("_m", "M").replaceAll("_n", "N").replaceAll("_o", "O").replaceAll("_p", "P").replaceAll("_q", "Q").replaceAll("_r", "R").replaceAll("_s", "S").replaceAll("_t", "T").replaceAll("_u", "U").replaceAll("_v", "V").replaceAll("_w", "W").replaceAll("_x", "X").replaceAll("_y", "Y").replaceAll("_z", "Z").replaceAll("_0", "0").replaceAll("_1", "1").replaceAll("_2", "2").replaceAll("_3", "3").replaceAll("_4", "4").replaceAll("_5", "5").replaceAll("_6", "6").replaceAll("_7", "7").replaceAll("_8", "8").replaceAll("_9", "9");
        return theText;
    }

    public static String asSnakeCase(String aText) {
        return CaseStyleBuilder.asSnakeCase(aText, Case.UPPER);
    }

    public static String asSnakeCase(String aText, Case aCase) {
        if (aText == null || aText.isEmpty()) {
            return aText;
        }
        return aCase.toCase(NormalizeCaseUtility.toNormalized(aText, Delimiter.SNAKE_CASE.getChar()));
    }

    public static String asPascalCase(String aText) {
        if (aText == null || ((String)aText).isEmpty()) {
            return aText;
        }
        aText = CaseStyleBuilder.asCamelCase((String)aText);
        aText = Character.toUpperCase(((String)aText).charAt(0)) + ((String)aText).substring(1);
        return aText;
    }

    public static String asKebabCase(String aText) {
        return CaseStyleBuilder.asKebabCase(aText, Case.UPPER);
    }

    public static String asKebabCase(String aText, Case aCase) {
        if (aText == null || aText.isEmpty()) {
            return aText;
        }
        return aCase.toCase(NormalizeCaseUtility.toNormalized(aText, Delimiter.KEBAB_CASE.getChar()));
    }

    static class NormalizeCaseUtility
    extends Configuration {
        NormalizeCaseUtility() {
        }

        protected static String toNormalized(String aText, char aSeparator) {
            return Configuration.asNormalized((String)aText, (char)aSeparator);
        }
    }
}

