/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.refcodes.struct.Property;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.EscapeTextMode;

public class EscapeTextBuilder
extends AbstractText<EscapeTextBuilder> {
    private List<Property> _properties;
    private EscapeTextMode _escapeTextMode = EscapeTextMode.ESCAPE;

    public EscapeTextMode getEscapeTextMode() {
        return this._escapeTextMode;
    }

    public void setEscapeTextMode(EscapeTextMode aEscapeTextMode) {
        this._escapeTextMode = aEscapeTextMode;
    }

    public Property[] getEscapeProperties() {
        return this._properties.toArray(new Property[this._properties.size()]);
    }

    public void setEscapeProperties(Property ... aProperties) {
        this._properties = new ArrayList<Property>();
        Collections.addAll(this._properties, aProperties);
    }

    public EscapeTextBuilder addEscapeProperty(Property aProperty) {
        if (this._properties == null) {
            this._properties = new ArrayList<Property>();
        }
        this._properties.add(aProperty);
        return this;
    }

    public EscapeTextBuilder addEscapeProperty(String aKey, String aValue) {
        return this.addEscapeProperty((Property)new PropertyImpl(aKey, aValue));
    }

    @Override
    public String[] toStrings() {
        return this.toEscaped(this.getText(), this._properties, this._escapeTextMode);
    }

    @Override
    public String[] toStrings(String ... aText) {
        return this.toEscaped(aText, this._properties, this._escapeTextMode);
    }

    public EscapeTextBuilder withEscapeTextMode(EscapeTextMode aEscapeTextMode) {
        this.setEscapeTextMode(aEscapeTextMode);
        return this;
    }

    public EscapeTextBuilder withEscapeProperties(Property ... aProperties) {
        this.setEscapeProperties(aProperties);
        return this;
    }

    protected String[] toEscaped(String[] aText, List<Property> aProperties, EscapeTextMode aEscapeTextMode) {
        String[] theResult = new String[aText.length];
        for (int i = 0; i < aText.length; ++i) {
            theResult[i] = this.toEscaped(aText[i], aProperties, aEscapeTextMode);
        }
        return theResult;
    }

    protected String toEscaped(String aText, List<Property> aProperties, EscapeTextMode aEscapeTextMode) {
        switch (aEscapeTextMode) {
            case ESCAPE: {
                return EscapeTextBuilder.toEscaped(aText, EscapeTextBuilder.toEscapeMatrix(aProperties));
            }
            case UNESCAPE: {
                return EscapeTextBuilder.toUnEscaped(aText, EscapeTextBuilder.toEscapeMatrix(aProperties));
            }
        }
        throw new IllegalArgumentException("You must pass a valid escape text mode, though you actually passed <" + String.valueOf((Object)aEscapeTextMode) + ">!");
    }

    public static String toEscaped(String aUnEscaped, String[][] aEscapeMatrix) {
        if (aEscapeMatrix != null) {
            for (String[] anAEscapeMatrix : aEscapeMatrix) {
                aUnEscaped = aUnEscaped.replaceAll(EscapeTextBuilder.toRegExEscaped(anAEscapeMatrix[0]), anAEscapeMatrix[1]);
            }
            return aUnEscaped;
        }
        return EscapeTextBuilder.asEscaped(aUnEscaped);
    }

    public static String toUnEscaped(String aEscaped, String[][] aEscapeMatrix) {
        if (aEscapeMatrix != null) {
            for (String[] anAEscapeMatrix : aEscapeMatrix) {
                aEscaped = aEscaped.replaceAll(EscapeTextBuilder.toRegExEscaped(anAEscapeMatrix[1]), anAEscapeMatrix[0]);
            }
            return aEscaped;
        }
        return EscapeTextBuilder.asUnEscaped(aEscaped);
    }

    public static String asEscaped(String aUnEscapedText) {
        StringBuilder theBuffer = new StringBuilder();
        int theLength = aUnEscapedText.length();
        block13: for (int i = 0; i < theLength; ++i) {
            char eChar = aUnEscapedText.charAt(i);
            if (eChar > '\u0fff') {
                theBuffer.append("\\u" + Integer.toHexString(eChar).toUpperCase());
                continue;
            }
            if (eChar > '\u00ff') {
                theBuffer.append("\\u0" + Integer.toHexString(eChar).toUpperCase());
                continue;
            }
            if (eChar > '\u007f') {
                theBuffer.append("\\u00" + Integer.toHexString(eChar).toUpperCase());
                continue;
            }
            if (eChar < ' ') {
                switch (eChar) {
                    case '\b': {
                        theBuffer.append('\\');
                        theBuffer.append('b');
                        break;
                    }
                    case '\n': {
                        theBuffer.append('\\');
                        theBuffer.append('n');
                        break;
                    }
                    case '\t': {
                        theBuffer.append('\\');
                        theBuffer.append('t');
                        break;
                    }
                    case '\f': {
                        theBuffer.append('\\');
                        theBuffer.append('f');
                        break;
                    }
                    case '\r': {
                        theBuffer.append('\\');
                        theBuffer.append('r');
                        break;
                    }
                    default: {
                        if (eChar > '\u000f') {
                            theBuffer.append("\\u00" + Integer.toHexString(eChar).toUpperCase());
                            break;
                        }
                        theBuffer.append("\\u000" + Integer.toHexString(eChar).toUpperCase());
                        break;
                    }
                }
                continue;
            }
            switch (eChar) {
                case '\'': {
                    theBuffer.append('\'');
                    continue block13;
                }
                case '\"': {
                    theBuffer.append('\\');
                    theBuffer.append('\"');
                    continue block13;
                }
                case '\\': {
                    theBuffer.append('\\');
                    theBuffer.append('\\');
                    continue block13;
                }
                case '/': {
                    theBuffer.append('/');
                    continue block13;
                }
                default: {
                    theBuffer.append(eChar);
                }
            }
        }
        return theBuffer.toString();
    }

    public static String asUnEscaped(String aEscapedText) {
        StringBuilder theBuffer = new StringBuilder();
        int theLength = aEscapedText.length();
        StringBuilder theTemp = new StringBuilder();
        boolean hasSlash = false;
        boolean isUnicode = false;
        for (int i = 0; i < theLength; ++i) {
            char eChar = aEscapedText.charAt(i);
            if (isUnicode) {
                theTemp.append(eChar);
                if (theTemp.length() != 4) continue;
                try {
                    int eValue = Integer.parseInt(theTemp.toString(), 16);
                    theBuffer.append((char)eValue);
                    theTemp.setLength(0);
                    isUnicode = false;
                    hasSlash = false;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Unable to parse unicode: " + String.valueOf(theTemp), e);
                }
            }
            if (hasSlash) {
                hasSlash = false;
                switch (eChar) {
                    case '\\': {
                        theBuffer.append('\\');
                        break;
                    }
                    case '\'': {
                        theBuffer.append('\'');
                        break;
                    }
                    case '\"': {
                        theBuffer.append('\"');
                        break;
                    }
                    case 'r': {
                        theBuffer.append('\r');
                        break;
                    }
                    case 'f': {
                        theBuffer.append('\f');
                        break;
                    }
                    case 't': {
                        theBuffer.append('\t');
                        break;
                    }
                    case 'n': {
                        theBuffer.append('\n');
                        break;
                    }
                    case 'b': {
                        theBuffer.append('\b');
                        break;
                    }
                    case 'u': {
                        isUnicode = true;
                        break;
                    }
                    default: {
                        theBuffer.append(eChar);
                        break;
                    }
                }
                continue;
            }
            if (eChar == '\\') {
                hasSlash = true;
                continue;
            }
            theBuffer.append(eChar);
        }
        if (hasSlash) {
            theBuffer.append('\\');
        }
        return theBuffer.toString();
    }

    protected static String toEscapedRegexp(char aDelimiter) {
        return ("" + aDelimiter).replaceAll("\\.", "\\\\.").replaceAll("\\|", "\\\\|");
    }

    protected static String toRegExEscaped(String aText) {
        aText = aText.replaceAll("\\+", "\\\\+").replaceAll("\\*", "\\\\*").replaceAll("\\.", "\\\\.");
        return aText;
    }

    private static String[][] toEscapeMatrix(List<Property> aProperties) {
        if (aProperties != null) {
            String[][] theStrings = new String[aProperties.size()][2];
            for (int i = 0; i < aProperties.size(); ++i) {
                theStrings[i][0] = (String)aProperties.get(i).getKey();
                theStrings[i][1] = (String)aProperties.get(i).getValue();
            }
            return theStrings;
        }
        return null;
    }
}

