/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.data.ConsoleDimension;
import org.refcodes.mixin.EscapeCodesStatusAccessor;
import org.refcodes.mixin.RowHeightAccessor;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.Text;
import org.refcodes.textual.TextLineBuilder;
import org.refcodes.textual.VertAlignTextMode;
import org.refcodes.textual.VertAlignTextModeAccessor;

public class VertAlignTextBuilder
extends AbstractText<VertAlignTextBuilder>
implements RowHeightAccessor.RowHeightBuilder<VertAlignTextBuilder>,
RowHeightAccessor.RowHeightProperty,
Text<VertAlignTextBuilder>,
VertAlignTextModeAccessor.VertAlignTextModeProperty,
VertAlignTextModeAccessor.VertAlignTextModeBuilder<VertAlignTextBuilder>,
EscapeCodesStatusAccessor.EscapeCodeStatusProperty,
EscapeCodesStatusAccessor.EscapeCodeStatusBuilder<VertAlignTextBuilder> {
    private int _rowHeight = ConsoleDimension.MIN_HEIGHT.getValue();
    private VertAlignTextMode _alignTextMode = VertAlignTextMode.TOP;
    private char _fillChar = (char)32;
    private boolean _isEscapeCodesEnabled = false;

    public VertAlignTextBuilder build() {
        return new VertAlignTextBuilder();
    }

    public char getFillChar() {
        return this._fillChar;
    }

    public int getRowHeight() {
        return this._rowHeight;
    }

    @Override
    public VertAlignTextMode getVertAlignTextMode() {
        return this._alignTextMode;
    }

    public boolean isEscapeCodesEnabled() {
        return this._isEscapeCodesEnabled;
    }

    public void setEscapeCodesEnabled(boolean bl) {
        this._isEscapeCodesEnabled = bl;
    }

    public void setFillChar(char c) {
        this._fillChar = c;
    }

    public void setRowHeight(int n) {
        this._rowHeight = n;
    }

    @Override
    public void setVertAlignTextMode(VertAlignTextMode vertAlignTextMode) {
        this._alignTextMode = vertAlignTextMode;
    }

    @Override
    public String[] toStrings() {
        return VertAlignTextBuilder.asAligned(this.getText(), this._rowHeight, this._fillChar, this._alignTextMode, this._isEscapeCodesEnabled);
    }

    @Override
    public String[] toStrings(String ... stringArray) {
        return VertAlignTextBuilder.asAligned(stringArray, this._rowHeight, this._fillChar, this._alignTextMode, this._isEscapeCodesEnabled);
    }

    public VertAlignTextBuilder withEscapeCodesEnabled(boolean bl) {
        this.setEscapeCodesEnabled(bl);
        return this;
    }

    public VertAlignTextBuilder withFillChar(char c) {
        this.setFillChar(c);
        return this;
    }

    public VertAlignTextBuilder withRowHeight(int n) {
        this.setRowHeight(n);
        return this;
    }

    @Override
    public VertAlignTextBuilder withVertAlignTextMode(VertAlignTextMode vertAlignTextMode) {
        this.setVertAlignTextMode(vertAlignTextMode);
        return this;
    }

    public static String[] asAligned(String[] stringArray, int n, char c, VertAlignTextMode vertAlignTextMode) {
        return VertAlignTextBuilder.asAligned(stringArray, n, c, vertAlignTextMode, false);
    }

    public static String[] asAligned(String[] stringArray, int n, VertAlignTextMode vertAlignTextMode) {
        return VertAlignTextBuilder.asAligned(stringArray, n, ' ', vertAlignTextMode, false);
    }

    public static String[] asAligned(String[] stringArray, int n, VertAlignTextMode vertAlignTextMode, boolean bl) {
        return VertAlignTextBuilder.asAligned(stringArray, n, ' ', vertAlignTextMode, bl);
    }

    public static String[] asAligned(String[] stringArray, int n, char c, VertAlignTextMode vertAlignTextMode, boolean bl) {
        if (stringArray == null || n == stringArray.length) {
            return stringArray;
        }
        String string = null;
        String[] stringArray2 = new String[n];
        int n2 = AnsiEscapeCode.toLength((String)stringArray[0], (boolean)bl);
        switch (vertAlignTextMode) {
            case BOTTOM: {
                throw new RuntimeException(org.refcodes.data.Text.NOT_YET_IMPLEMENTED.getText());
            }
            case MIDDLE: {
                throw new RuntimeException(org.refcodes.data.Text.NOT_YET_IMPLEMENTED.getText());
            }
            case TOP: {
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (i < stringArray.length) {
                        stringArray2[i] = stringArray[i];
                        continue;
                    }
                    if (string == null && stringArray != null && stringArray.length > 0) {
                        string = new TextLineBuilder().withColumnWidth(n2).withLineChar(c).toString();
                    }
                    stringArray2[i] = string;
                }
                return stringArray2;
            }
        }
        throw new IllegalArgumentException("You must provided a supported value for the vertical align mode, though you provided <" + vertAlignTextMode + ">. The code seems to be out of date, please participate in getting the code even better. See <http://www.refcodes.org> and <https://birbucket.org/refcodes>.");
    }
}

