/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.TextBorder;
import org.refcodes.graphical.BoxBorderMode;
import org.refcodes.graphical.BoxBorderModeAccessor;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.Text;
import org.refcodes.textual.TextBoxGrid;
import org.refcodes.textual.TextBoxGridAccessor;
import org.refcodes.textual.TextBoxStyle;

public class TextBorderBuilder
extends AbstractText<TextBorderBuilder>
implements Text<TextBorderBuilder>,
BoxBorderModeAccessor.BoxBorderModeProperty,
BoxBorderModeAccessor.BoxBorderModeBuilder<TextBorderBuilder>,
TextBoxGridAccessor.TextBoxGridProperty,
TextBoxGridAccessor.TextBoxGridBuilder<TextBorderBuilder> {
    private char _borderChar = (char)35;
    private BoxBorderMode _boxBorderMode = BoxBorderMode.ALL;
    private TextBoxGrid _textBoxGrid = TextBoxStyle.ASCII.getTextBoxGrid();
    private int _borderWidth = 1;

    public void setTextBoxStyle(TextBoxStyle textBoxStyle) {
        this.setTextBoxGrid(textBoxStyle.getTextBoxGrid());
    }

    public TextBorderBuilder withTextBoxStyle(TextBoxStyle textBoxStyle) {
        this.setTextBoxGrid(textBoxStyle.getTextBoxGrid());
        return this;
    }

    public TextBorderBuilder withBorderChar(char c) {
        this.setBorderChar(c);
        return this;
    }

    public TextBorderBuilder withBorderWidth(int n) {
        this.setBorderWidth(n);
        return this;
    }

    static TextBorderBuilder build() {
        return new TextBorderBuilder();
    }

    public BoxBorderMode getBoxBorderMode() {
        return this._boxBorderMode;
    }

    public void setBoxBorderMode(BoxBorderMode boxBorderMode) {
        this._boxBorderMode = boxBorderMode;
    }

    public TextBorderBuilder withBoxBorderMode(BoxBorderMode boxBorderMode) {
        this.setBoxBorderMode(boxBorderMode);
        return this;
    }

    @Override
    public TextBoxGrid getTextBoxGrid() {
        return this._textBoxGrid;
    }

    @Override
    public void setTextBoxGrid(TextBoxGrid textBoxGrid) {
        this._textBoxGrid = textBoxGrid;
        this._borderChar = '\u0000';
    }

    @Override
    public TextBorderBuilder withTextBoxGrid(TextBoxGrid textBoxGrid) {
        this.setTextBoxGrid(textBoxGrid);
        return this;
    }

    public char getBorderChar() {
        return this._borderChar;
    }

    public void setBorderChar(char c) {
        this._borderChar = c;
        this._textBoxGrid = null;
    }

    public int getBorderWidth() {
        return this._borderWidth;
    }

    public void setBorderWidth(int n) {
        this._borderWidth = n;
    }

    @Override
    public String[] toStrings() {
        return this.toStrings(this.getText());
    }

    @Override
    public String[] toStrings(String ... stringArray) {
        if (this._textBoxGrid != null) {
            return TextBorderBuilder.toBorder(stringArray, ((Character)this._textBoxGrid.getTopLeftEdge()).charValue(), ((Character)this._textBoxGrid.getTopRightEdge()).charValue(), ((Character)this._textBoxGrid.getBottomLeftEdge()).charValue(), ((Character)this._textBoxGrid.getBottomRightEdge()).charValue(), ((Character)this._textBoxGrid.getTopLine()).charValue(), ((Character)this._textBoxGrid.getRightLine()).charValue(), ((Character)this._textBoxGrid.getTopLine()).charValue(), ((Character)this._textBoxGrid.getLeftLine()).charValue(), this._boxBorderMode);
        }
        return TextBorderBuilder.toBorder(stringArray, this._borderWidth, this._borderChar, this._boxBorderMode);
    }

    protected static String[] toLeftBorder(String[] stringArray, int n, char c) {
        String string = TextBorderBuilder.toLine(n, c);
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = string + stringArray[i];
        }
        return stringArray2;
    }

    protected static String[] toRightBorder(String[] stringArray, int n, char c) {
        String string = TextBorderBuilder.toLine(n, c);
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i] + string;
        }
        return stringArray2;
    }

    protected static String[] toTopBorder(String[] stringArray, int n, char c) {
        int n2;
        String[] stringArray2 = new String[stringArray.length + n];
        String string = TextBorderBuilder.toLine(stringArray[0].length(), c);
        for (n2 = 0; n2 < n; ++n2) {
            stringArray2[n2] = string;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringArray2[n2 + n] = stringArray[n2];
        }
        return stringArray2;
    }

    protected static String[] toBottomBorder(String[] stringArray, int n, char c) {
        String[] stringArray2 = new String[stringArray.length + n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        String string = TextBorderBuilder.toLine(stringArray[stringArray.length - 1].length(), c);
        for (int i = 0; i < n; ++i) {
            stringArray2[stringArray.length + i] = string;
        }
        return stringArray2;
    }

    public static String[] toBorder(String[] stringArray, int n, char c, BoxBorderMode boxBorderMode) {
        if (boxBorderMode.isLeftBorder()) {
            stringArray = TextBorderBuilder.toLeftBorder(stringArray, n, c);
        }
        if (boxBorderMode.isRightBorder()) {
            stringArray = TextBorderBuilder.toRightBorder(stringArray, n, c);
        }
        if (boxBorderMode.isTopBorder()) {
            stringArray = TextBorderBuilder.toTopBorder(stringArray, n, c);
        }
        if (boxBorderMode.isBottomBorder()) {
            stringArray = TextBorderBuilder.toBottomBorder(stringArray, n, c);
        }
        return stringArray;
    }

    protected static String[] toBorder(String[] stringArray, char c, char c2, char c3, char c4, char c5, char c6, char c7, char c8, BoxBorderMode boxBorderMode) {
        if (boxBorderMode.isLeftBorder()) {
            stringArray = TextBorderBuilder.toLeftBorder(stringArray, 1, c8);
        }
        if (boxBorderMode.isRightBorder()) {
            stringArray = TextBorderBuilder.toRightBorder(stringArray, 1, c6);
        }
        if (boxBorderMode.isTopBorder()) {
            stringArray = TextBorderBuilder.toTopBorder(stringArray, 1, c5);
        }
        if (boxBorderMode.isBottomBorder()) {
            stringArray = TextBorderBuilder.toBottomBorder(stringArray, 1, c7);
        }
        if (boxBorderMode.isLeftBorder() && boxBorderMode.isTopBorder()) {
            stringArray[0] = c + stringArray[0].substring(1);
        }
        if (boxBorderMode.isLeftBorder() && boxBorderMode.isBottomBorder()) {
            stringArray[stringArray.length - 1] = c3 + stringArray[stringArray.length - 1].substring(1);
        }
        if (boxBorderMode.isRightBorder() && boxBorderMode.isTopBorder()) {
            stringArray[0] = stringArray[0].substring(0, stringArray[0].length() - 1) + c2;
        }
        if (boxBorderMode.isRightBorder() && boxBorderMode.isBottomBorder()) {
            stringArray[stringArray.length - 1] = stringArray[stringArray.length - 1].substring(0, stringArray[stringArray.length - 1].length() - 1) + c4;
        }
        return stringArray;
    }

    protected static String[] toSingleBorder(String[] stringArray) {
        return TextBorderBuilder.toBorder(stringArray, TextBorder.SINGLE_TOP_LEFT_EDGE.getChar(), TextBorder.SINGLE_TOP_RIGHT_EDGE.getChar(), TextBorder.SINGLE_BOTTOM_LEFT_EDGE.getChar(), TextBorder.SINGLE_BOTTOM_RIGHT_EDGE.getChar(), TextBorder.SINGLE_HORIZONTAL_LINE.getChar(), TextBorder.SINGLE_VERTICAL_LINE.getChar(), TextBorder.SINGLE_HORIZONTAL_LINE.getChar(), TextBorder.SINGLE_VERTICAL_LINE.getChar(), BoxBorderMode.ALL);
    }

    protected static String[] toDoubleBorder(String[] stringArray) {
        return TextBorderBuilder.toBorder(stringArray, TextBorder.DOUBLE_TOP_LEFT_EDGE.getChar(), TextBorder.DOUBLE_TOP_RIGHT_EDGE.getChar(), TextBorder.DOUBLE_BOTTOM_LEFT_EDGE.getChar(), TextBorder.DOUBLE_BOTTOM_RIGHT_EDGE.getChar(), TextBorder.DOUBLE_HORIZONTAL_LINE.getChar(), TextBorder.DOUBLE_VERTICAL_LINE.getChar(), TextBorder.DOUBLE_HORIZONTAL_LINE.getChar(), TextBorder.DOUBLE_VERTICAL_LINE.getChar(), BoxBorderMode.ALL);
    }

    protected static String[] toAsciiBorder(String[] stringArray) {
        return TextBorderBuilder.toBorder(stringArray, TextBorder.ASCII_TOP_LEFT_EDGE.getChar(), TextBorder.ASCII_TOP_RIGHT_EDGE.getChar(), TextBorder.ASCII_BOTTOM_LEFT_EDGE.getChar(), TextBorder.ASCII_BOTTOM_RIGHT_EDGE.getChar(), TextBorder.ASCII_HORIZONTAL_LINE.getChar(), TextBorder.ASCII_VERTICAL_LINE.getChar(), TextBorder.ASCII_HORIZONTAL_LINE.getChar(), TextBorder.ASCII_VERTICAL_LINE.getChar(), BoxBorderMode.ALL);
    }

    protected static String toLine(int n, char c) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (stringBuffer.length() < n) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

