/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.CharSet;
import org.refcodes.mixin.CharSetAccessor;

public enum RandomTextMode implements CharSetAccessor
{
    ASCII(CharSet.ASCII.getCharSet()),
    ALPHABETIC(CharSet.ALPHABETIC.getCharSet()),
    UPPER_CASE(CharSet.UPPER_CASE.getCharSet()),
    LOWER_CASE(CharSet.LOWER_CASE.getCharSet()),
    ALPHANUMERIC(CharSet.ALPHANUMERIC.getCharSet()),
    UPPER_CASE_ALPHANUMERIC(RandomTextMode.asConcat(CharSet.UPPER_CASE.getCharSet(), CharSet.NUMERIC.getCharSet())),
    LOWER_CASE_ALPHANUMERIC(RandomTextMode.asConcat(CharSet.LOWER_CASE.getCharSet(), CharSet.NUMERIC.getCharSet())),
    NUMERIC(CharSet.NUMERIC.getCharSet()),
    BINARY(CharSet.BINARY.getCharSet()),
    HEXADECIMAL(CharSet.HEXADECIMAL.getCharSet());

    private char[] _charSet;

    private RandomTextMode(char[] cArray) {
        this._charSet = cArray;
    }

    public char[] getCharSet() {
        return this._charSet;
    }

    private static char[] asConcat(char[] cArray, char[] cArray2) {
        char[] cArray3 = new char[cArray.length + cArray2.length];
        System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
        System.arraycopy(cArray2, 0, cArray3, cArray.length, cArray2.length);
        return cArray3;
    }
}

