/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.mixin.ColumnWidthAccessor;
import org.refcodes.runtime.Terminal;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.FillCharAccessor;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.HorizAlignTextModeAccessor;
import org.refcodes.textual.Text;

public class HorizAlignTextBuilder
extends AbstractText<HorizAlignTextBuilder>
implements FillCharAccessor.FillCharProperty,
FillCharAccessor.FillCharBuilder<HorizAlignTextBuilder>,
ColumnWidthAccessor.ColumnWidthBuilder<HorizAlignTextBuilder>,
ColumnWidthAccessor.ColumnWidthProperty,
Text<HorizAlignTextBuilder>,
HorizAlignTextModeAccessor.HorizAlignTextModeProperty,
HorizAlignTextModeAccessor.HorizAlignTextModeBuilder<HorizAlignTextBuilder> {
    private int _columnWidth = Terminal.toPreferredTerminalWidth();
    private HorizAlignTextMode _alignTextMode = HorizAlignTextMode.LEFT;
    private char _fillChar = (char)32;

    public HorizAlignTextBuilder withColumnWidth(int n) {
        this.setColumnWidth(n);
        return this;
    }

    public void setColumnWidth(int n) {
        this._columnWidth = n;
    }

    public int getColumnWidth() {
        return this._columnWidth;
    }

    @Override
    public void setHorizAlignTextMode(HorizAlignTextMode horizAlignTextMode) {
        this._alignTextMode = horizAlignTextMode;
    }

    @Override
    public HorizAlignTextMode getHorizAlignTextMode() {
        return this._alignTextMode;
    }

    @Override
    public char getFillChar() {
        return this._fillChar;
    }

    @Override
    public void setFillChar(char c) {
        this._fillChar = c;
    }

    @Override
    public String[] toStrings() {
        return HorizAlignTextBuilder.asAligned(this.getText(), this._columnWidth, this._fillChar, this._alignTextMode);
    }

    @Override
    public String[] toStrings(String ... stringArray) {
        return HorizAlignTextBuilder.asAligned(stringArray, this._columnWidth, this._fillChar, this._alignTextMode);
    }

    @Override
    public HorizAlignTextBuilder withHorizAlignTextMode(HorizAlignTextMode horizAlignTextMode) {
        this.setHorizAlignTextMode(horizAlignTextMode);
        return this;
    }

    @Override
    public HorizAlignTextBuilder withFillChar(char c) {
        this.setFillChar(c);
        return this;
    }

    public static String asAligned(String string, int n, HorizAlignTextMode horizAlignTextMode) {
        return HorizAlignTextBuilder.asAligned(string, n, ' ', horizAlignTextMode, false);
    }

    public static String asAligned(String string, int n, char c, HorizAlignTextMode horizAlignTextMode) {
        return HorizAlignTextBuilder.asAligned(string, n, c, horizAlignTextMode, false);
    }

    public static String[] asAligned(String[] stringArray, int n, char c, HorizAlignTextMode horizAlignTextMode) {
        return HorizAlignTextBuilder.asAligned(stringArray, n, c, horizAlignTextMode, false);
    }

    public static String asAligned(String string, int n, HorizAlignTextMode horizAlignTextMode, boolean bl) {
        return HorizAlignTextBuilder.asAligned(string, n, ' ', horizAlignTextMode, bl);
    }

    public static String asAligned(String string, int n, char c, HorizAlignTextMode horizAlignTextMode, boolean bl) {
        if (horizAlignTextMode == null) {
            return string;
        }
        switch (horizAlignTextMode) {
            case BLOCK: {
                return HorizAlignTextBuilder.toAlignBlock(string, n, c, bl);
            }
            case CENTER: {
                return HorizAlignTextBuilder.toAlignCenter(string, n, c, bl);
            }
            case LEFT: {
                return HorizAlignTextBuilder.toAlignLeft(string, n, c, bl);
            }
            case RIGHT: {
                return HorizAlignTextBuilder.toAlignRight(string, n, c, bl);
            }
        }
        throw new IllegalArgumentException("You must provide a supported value for the horizontal align mode, though you provided <" + horizAlignTextMode + ">. The code seems to be out of date, please participate in getting the code even better. See <http://www.refcodes.org> and <https://birbucket.org/refcodes>.");
    }

    public static String[] asAligned(String[] stringArray, int n, char c, HorizAlignTextMode horizAlignTextMode, boolean bl) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = HorizAlignTextBuilder.asAligned(stringArray[i], n, c, horizAlignTextMode, bl);
        }
        return stringArray2;
    }

    private static String toAlignLeft(String string, int n, char c, boolean bl) {
        if (HorizAlignTextBuilder.toLength(string, bl) == n) {
            return string;
        }
        if (HorizAlignTextBuilder.toLength(string, bl) > n) {
            return string.substring(0, n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        for (int i = 0; i < n - HorizAlignTextBuilder.toLength(string, bl); ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String toAlignRight(String string, int n, char c, boolean bl) {
        if (HorizAlignTextBuilder.toLength(string, bl) == n) {
            return string;
        }
        if (HorizAlignTextBuilder.toLength(string, bl) > n) {
            return string.substring(HorizAlignTextBuilder.toLength(string, bl) - n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n - HorizAlignTextBuilder.toLength(string, bl); ++i) {
            stringBuffer.append(c);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private static String toAlignCenter(String string, int n, char c, boolean bl) {
        if (HorizAlignTextBuilder.toLength(string, bl) == n) {
            return string;
        }
        if (HorizAlignTextBuilder.toLength(string, bl) > n) {
            int n2 = HorizAlignTextBuilder.toLength(string, bl) - n;
            int n3 = n2 / 2;
            int n4 = n2 / 2;
            return string.substring(n3, HorizAlignTextBuilder.toLength(string, bl) - (n4 += n2 % 2));
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        while (stringBuffer.length() < n) {
            stringBuffer.append(c);
            if (stringBuffer.length() >= n) continue;
            stringBuffer.insert(0, c);
        }
        return stringBuffer.toString();
    }

    private static String toAlignBlock(String string, int n, char c, boolean bl) {
        if (HorizAlignTextBuilder.toLength(string, bl) == n) {
            return string;
        }
        if (HorizAlignTextBuilder.toLength(string, bl) > n) {
            int n2 = HorizAlignTextBuilder.toLength(string, bl) - n;
            int n3 = n2 / 2;
            int n4 = n2 / 2;
            return string.substring(n3, HorizAlignTextBuilder.toLength(string, bl) - (n4 += n2 % 2));
        }
        if (string.indexOf(c) == -1) {
            return HorizAlignTextBuilder.toAlignLeft(string, n, c, bl);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        String string2 = new String(new char[]{c});
        int n5 = -1;
        while (stringBuffer.length() < n) {
            if ((n5 = stringBuffer.indexOf(string2, n5 + 1)) == -1) {
                n5 = 0;
                continue;
            }
            stringBuffer.insert(n5, string2);
            while (n5 < stringBuffer.length() - 1 && stringBuffer.charAt(n5) == c) {
                ++n5;
            }
            if (n5 <= n) continue;
            n5 = 0;
        }
        return stringBuffer.toString();
    }

    private static int toLength(String string, boolean bl) {
        if (bl) {
            return AnsiEscapeCode.toUnescapedLength((String)string);
        }
        return string.length();
    }
}

