/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct.ext.factory;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.refcodes.data.Prefix;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.struct.CanonicalMapBuilderImpl;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.ext.factory.AbstractCanonicalMapFactory;
import org.refcodes.struct.ext.factory.DocumentProperty;

public class JavaCanonicalMapFactory
extends AbstractCanonicalMapFactory {
    public static final char COMMENT = '#';

    public CanonicalMap.CanonicalMapBuilder fromMarshaled(InputStream aExternalRepresentation) throws UnmarshalException {
        return this.fromMarshaled(aExternalRepresentation, null);
    }

    public CanonicalMap.CanonicalMapBuilder fromMarshaled(InputStream aExternalRepresentation, Map<String, String> aProperties) throws UnmarshalException {
        char theDelimiter = DocumentProperty.toDelimiter(aProperties, PathMap.DELIMITER);
        char[] theSupportedDelimiters = DocumentProperty.toDelimiters(aProperties);
        Properties theProperties = new Properties();
        try {
            theProperties.load(aExternalRepresentation);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new UnmarshalException("Unable to unmarshal the external representation from input stream <" + String.valueOf(aExternalRepresentation) + ">!", (Throwable)e);
        }
        CanonicalMapBuilderImpl theResult = new CanonicalMapBuilderImpl(theDelimiter);
        for (Object eObj : theProperties.keySet()) {
            String eKey = (String)eObj;
            String eValue = theProperties.getProperty(eKey);
            eKey = theResult.fromExternalPath(eKey, theSupportedDelimiters);
            theResult.put((Object)eKey, (Object)eValue);
        }
        return theResult;
    }

    @Override
    public String toMarshaled(CanonicalMap aDataStructure) throws MarshalException {
        return this.toMarshaled(aDataStructure, null);
    }

    @Override
    public String toMarshaled(CanonicalMap aDataStructure, Map<String, String> aProperties) throws MarshalException {
        char[] theSupportedDelimiters = DocumentProperty.toDelimiters(aProperties);
        Properties theProperties = new Properties();
        ArrayList theKeys = new ArrayList(aDataStructure.sortedKeys());
        for (String eKey : theKeys) {
            String eValue = (String)aDataStructure.get((Object)eKey);
            eKey = aDataStructure.toExternalPath(eKey, theSupportedDelimiters[0]);
            eKey = aDataStructure.toPropertyPath(eKey);
            theProperties.put(eKey, eValue == null ? "" : eValue);
        }
        String theComment = DocumentProperty.toComment(aProperties);
        try {
            StringWriter theWriter = new StringWriter();
            theProperties.store(new PrintWriter(theWriter), theComment);
            String theResult = theWriter.getBuffer().toString();
            if (theComment == null) {
                while (theResult.startsWith(Prefix.JAVA_PROPERTIES_COMMENT.getPrefix())) {
                    theResult = theResult.split("\r\n|\r|\n", 2)[1];
                }
            }
            return theResult;
        }
        catch (IOException e) {
            throw new MarshalException("A problem occurred marshaling an object of type <" + CanonicalMap.class.getName() + ">.", (Throwable)e);
        }
    }

    public InputStream fromUnmarshaled(CanonicalMap aDataStructure) throws MarshalException {
        return this.fromUnmarshaled(aDataStructure, null);
    }

    public InputStream fromUnmarshaled(CanonicalMap aDataStructure, Map<String, String> aProperties) throws MarshalException {
        String theMarshaled = this.toMarshaled(aDataStructure, aProperties);
        ByteArrayInputStream theMarshalledStream = new ByteArrayInputStream(theMarshaled.getBytes());
        return theMarshalledStream;
    }
}

