/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.refcodes.data.Delimiter;
import org.refcodes.data.EnvironmentVariable;
import org.refcodes.data.SystemProperty;
import org.refcodes.data.Text;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.runtime.SystemUtility;

public enum SystemContext {
    APPLICATION(false, false, true, false),
    USER_APPLICATION(false, true, true, false),
    HOST_USER_APPLICATION(true, true, true, false),
    HOST_APPLICATION(true, false, true, false),
    USER(false, true, false, false),
    HOST_USER(true, true, false, false),
    HOST(true, false, false, false),
    SESSION(false, false, false, true),
    APPLICATION_SESSION(false, false, true, true),
    USER_APPLICATION_SESSION(false, true, true, true),
    HOST_USER_APPLICATION_SESSION(true, true, true, true),
    HOST_APPLICATION_SESSION(true, false, true, true),
    USER_SESSION(false, true, false, true),
    HOST_USER_SESSION(true, true, false, true),
    HOST_SESSION(true, false, false, true);

    private static String _hostAddress;
    private static volatile long SESSION_SEED;
    private boolean _isHostLevel;
    private boolean _isUserLevel;
    private boolean _isApplicationLevel;
    private boolean _isSessionLevel;
    private String _ctxSequence = null;

    private SystemContext(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this._isHostLevel = bl;
        this._isUserLevel = bl2;
        this._isApplicationLevel = bl3;
        this._isSessionLevel = bl4;
    }

    public boolean isHostLevel() {
        return this._isHostLevel;
    }

    public boolean isUserLevel() {
        return this._isUserLevel;
    }

    public boolean isApplicationLevel() {
        return this._isApplicationLevel;
    }

    public boolean isSessionLevel() {
        return this._isSessionLevel;
    }

    public String toContextSequence() {
        return this.toContextSequence(null);
    }

    public String toContextSequence(String string) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this._ctxSequence != null) {
            stringBuffer.append(this._ctxSequence);
        } else {
            Object object2;
            Object object3;
            if (this.isSessionLevel()) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(Delimiter.LIST.getChar());
                }
                stringBuffer.append(SESSION_SEED);
                object = System.getenv().keySet().iterator();
                while (object.hasNext()) {
                    object3 = (String)object.next();
                    stringBuffer.append(Delimiter.LIST.getChar());
                    stringBuffer.append(System.getenv((String)object3));
                }
            }
            if (this.isHostLevel()) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(Delimiter.LIST.getChar());
                }
                if (!((object = SystemProperty.OS_ARCH.getValue()) != null && ((String)object).length() != 0 || (object = EnvironmentVariable.PROCESSOR_ARCHITECTURE.getKey()) != null && ((String)object).length() != 0 || (object = EnvironmentVariable.PROCESSOR_ARCHITEW6432.getKey()) != null)) {
                    object = Text.ARECIBO_MESSAGE.getText().substring(32, 48);
                }
                stringBuffer.append((String)object);
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(Delimiter.LIST.getChar());
                }
                if (_hostAddress == null) {
                    try {
                        _hostAddress = Arrays.toString(SystemUtility.toHostMacAddress());
                    }
                    catch (SocketException | UnknownHostException iOException) {
                        // empty catch block
                    }
                    if (_hostAddress == null || _hostAddress.length() == 0) {
                        try {
                            _hostAddress = Arrays.toString(SystemUtility.toHostIpAddress());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (_hostAddress == null || _hostAddress.length() == 0) {
                            _hostAddress = Text.ARECIBO_MESSAGE.getText().substring(64, 80);
                        }
                    }
                }
                stringBuffer.append(_hostAddress);
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(Delimiter.LIST.getChar());
                }
                if ((object3 = SystemUtility.getComputerName()) == null || ((String)object3).length() == 0) {
                    object3 = Text.ARECIBO_MESSAGE.getText().substring(96, 112);
                }
                stringBuffer.append((String)object3);
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(Delimiter.LIST.getChar());
                }
                try {
                    object2 = "" + Runtime.getRuntime().availableProcessors();
                }
                catch (Exception exception) {
                    object2 = EnvironmentVariable.NUMBER_OF_PROCESSORS.getValue();
                }
                if (object2 == null || ((String)object2).length() == 0) {
                    object2 = Text.ARECIBO_MESSAGE.getText().substring(112, 128);
                }
                stringBuffer.append((String)object2);
            }
            if (this.isUserLevel()) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(Delimiter.LIST.getChar());
                }
                if ((object = SystemProperty.USER_NAME.getValue()) == null || ((String)object).length() == 0) {
                    object = Text.ARECIBO_MESSAGE.getText().substring(0, 16);
                }
                stringBuffer.append((String)object);
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(Delimiter.LIST.getChar());
                }
                if ((object3 = SystemProperty.USER_HOME.getValue()) == null || ((String)object3).length() == 0) {
                    object3 = Text.ARECIBO_MESSAGE.getText().substring(16, 32);
                }
                stringBuffer.append((String)object3);
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(Delimiter.LIST.getChar());
                }
                if ((object2 = SystemProperty.TEMP_DIR.getValue()) == null) {
                    object2 = new String(Text.ARECIBO_MESSAGE.getText().substring(48, 64));
                }
                stringBuffer.append((String)object2);
            }
            if (this.isApplicationLevel()) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(Delimiter.LIST.getChar());
                }
                object = (object3 = RuntimeUtility.getMainClass()) != null ? ((Class)object3).getName() : Text.ARECIBO_MESSAGE.getText().substring(128, 144);
                stringBuffer.append((String)object);
            }
            this._ctxSequence = stringBuffer.toString();
        }
        if (string != null && string.length() != 0) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(Delimiter.LIST.getChar());
            }
            stringBuffer.append(string);
        }
        if ((object = EnvironmentVariable.HOST_SEED.getValue()) != null && ((String)object).length() != 0) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(Delimiter.LIST.getChar());
            }
            stringBuffer.append((String)object);
        }
        if ((object = SystemProperty.HOST_SEED.getValue()) != null && ((String)object).length() != 0) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(Delimiter.LIST.getChar());
            }
            stringBuffer.append((String)object);
        }
        return stringBuffer.toString();
    }

    public int toContextId() {
        return this.toContextId(null);
    }

    public int toContextId(String string) {
        String string2 = this.toContextSequence(string);
        return NumericalUtility.toHashCode((String)string2);
    }

    public int[] toContextIds(int n) {
        return this.toContextIds(n, null);
    }

    public int[] toContextIds(int n, String string) {
        String string2 = this.toContextSequence(string);
        return NumericalUtility.toHashCodes((String)string2, (int)n);
    }

    static {
        _hostAddress = null;
        SESSION_SEED = System.currentTimeMillis();
    }
}

