/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.refcodes.data.Folder;
import org.refcodes.data.SystemProperty;
import org.refcodes.runtime.RuntimeUtility;

public enum ConfigLocator {
    DEFAULT(true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, true),
    HOST_ETC(true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_DIR(false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_DIR_CONFIG(false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_DIR_ETC(false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_DIR_SETTINGS(false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_DIR_DOT_CONFIG(false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_DIR_DOT_ETC(false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_DIR_DOT_SETTINGS(false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_DIR_ALL(false, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_PARENT_CONFIG(false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_PARENT_ETC(false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_PARENT_SETTINGS(false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_PARENT_DOT_CONFIG(false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_PARENT_DOT_ETC(false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false),
    APPLICATION_PARENT_DOT_SETTINGS(false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false),
    APPLICATION_PARENT_ALL(false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false),
    APPLICATION_ALL(false, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false),
    USER_HOME(false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false),
    USER_HOME_CONFIG(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false),
    USER_HOME_ETC(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false),
    USER_HOME_SETTINGS(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false),
    USER_HOME_DOT_CONFIG(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false),
    USER_HOME_DOT_ETC(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false),
    USER_HOME_DOT_SETTINGS(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false),
    USER_HOME_ALL(false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, false),
    USER_WORKING_DIRECTORY(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true),
    USER_HOME_WORKING_DIRECTORY_ALL(false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true),
    ALL(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false),
    ABSOLUTE(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);

    private boolean _isHostEtc;
    private boolean _isApplicationBase;
    private boolean _isApplicationBaseConfig;
    private boolean _isApplicationBaseEtc;
    private boolean _isApplicationBaseSettings;
    private boolean _isApplicationBaseDotConfig;
    private boolean _isApplicationBaseDotEtc;
    private boolean _isApplicationBaseDotSettings;
    private boolean _isApplicationParentConfig;
    private boolean _isApplicationParentEtc;
    private boolean _isApplicationParentSettings;
    private boolean _isApplicationParentDotConfig;
    private boolean _isApplicationParentDotEtc;
    private boolean _isApplicationParentDotSettings;
    private boolean _isUserHome;
    private boolean _isUserHomeConfig;
    private boolean _isUserHomeEtc;
    private boolean _isUserHomeSettings;
    private boolean _isUserHomeDotConfig;
    private boolean _isUserHomeDotEtc;
    private boolean _isUserHomeDotSettings;
    private boolean _isUserWorkingDir;

    private ConfigLocator(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14, boolean bl15, boolean bl16, boolean bl17, boolean bl18, boolean bl19, boolean bl20, boolean bl21, boolean bl22) {
        this._isHostEtc = bl;
        this._isApplicationBase = bl2;
        this._isApplicationBaseConfig = bl3;
        this._isApplicationBaseEtc = bl4;
        this._isApplicationBaseSettings = bl5;
        this._isApplicationBaseDotConfig = bl6;
        this._isApplicationBaseDotEtc = bl7;
        this._isApplicationBaseDotSettings = bl8;
        this._isApplicationParentConfig = bl9;
        this._isApplicationParentEtc = bl10;
        this._isApplicationParentSettings = bl11;
        this._isApplicationParentDotConfig = bl12;
        this._isApplicationParentDotEtc = bl13;
        this._isApplicationParentDotSettings = bl14;
        this._isUserHome = bl15;
        this._isUserHomeConfig = bl16;
        this._isUserHomeEtc = bl17;
        this._isUserHomeSettings = bl18;
        this._isUserHomeDotConfig = bl19;
        this._isUserHomeDotEtc = bl20;
        this._isUserHomeDotSettings = bl21;
        this._isUserWorkingDir = bl22;
    }

    public boolean isHostEtc() {
        return this._isHostEtc;
    }

    public boolean isApplicationBase() {
        return this._isApplicationBase;
    }

    public boolean isApplicationBaseConfig() {
        return this._isApplicationBaseConfig;
    }

    public boolean isApplicationBaseEtc() {
        return this._isApplicationBaseEtc;
    }

    public boolean isApplicationBaseSettings() {
        return this._isApplicationBaseSettings;
    }

    public boolean isApplicationBaseDotConfig() {
        return this._isApplicationBaseDotConfig;
    }

    public boolean isApplicationBaseDotEtc() {
        return this._isApplicationBaseDotEtc;
    }

    public boolean isApplicationBaseDotSettings() {
        return this._isApplicationBaseDotSettings;
    }

    public boolean isApplicationParentConfig() {
        return this._isApplicationParentConfig;
    }

    public boolean isApplicationParentEtc() {
        return this._isApplicationParentEtc;
    }

    public boolean isApplicationParentSettings() {
        return this._isApplicationParentSettings;
    }

    public boolean isApplicationParentDotConfig() {
        return this._isApplicationParentDotConfig;
    }

    public boolean isApplicationParentDotEtc() {
        return this._isApplicationParentDotEtc;
    }

    public boolean isApplicationParentDotSettings() {
        return this._isApplicationParentDotSettings;
    }

    public boolean isUserHome() {
        return this._isUserHome;
    }

    public boolean isUserHomeConfig() {
        return this._isUserHomeConfig;
    }

    public boolean isUserHomeEtc() {
        return this._isUserHomeEtc;
    }

    public boolean isUserHomeSettings() {
        return this._isUserHomeSettings;
    }

    public boolean isUserHomeDotConfig() {
        return this._isUserHomeDotConfig;
    }

    public boolean isUserHomeDotEtc() {
        return this._isUserHomeDotEtc;
    }

    public boolean isUserHomeDotSettings() {
        return this._isUserHomeDotSettings;
    }

    public boolean isUserWorkingDir() {
        return this._isUserWorkingDir;
    }

    public File toFile(String string) {
        return this.toFile(string, null);
    }

    public File toFile(String string, File ... fileArray) {
        File file = new File(string);
        if (this == ABSOLUTE) {
            if (file.isAbsolute() && file.exists() && file.isFile() && file.canRead()) {
                return file;
            }
        } else {
            for (File file2 : this.getFolders(fileArray)) {
                file = ConfigLocator.toFile(string, file2);
                if (file == null) continue;
                return file;
            }
        }
        return null;
    }

    public File[] getFolders() {
        return this.getFolders(null);
    }

    public File[] getFolders(File ... fileArray) {
        File file;
        ArrayList<File> arrayList = new ArrayList<File>();
        this.addFolder(ConfigLocator.toFolder(SystemProperty.CONFIG_DIR.getValue()), arrayList);
        if (fileArray != null) {
            for (File file2 : fileArray) {
                this.addFolder(file2, arrayList);
            }
        }
        if (this._isUserWorkingDir) {
            this.addFolder(RuntimeUtility.toUserWorkingDir(), arrayList);
        }
        File file3 = RuntimeUtility.toLauncherDir();
        if (this._isApplicationBase) {
            this.addFolder(file3, arrayList);
        }
        if (this._isApplicationBaseConfig) {
            this.addFolder(file3, Folder.CONFIG, arrayList);
        }
        if (this._isApplicationBaseEtc) {
            this.addFolder(file3, Folder.ETC, arrayList);
        }
        if (this._isApplicationBaseSettings) {
            this.addFolder(file3, Folder.SETTINGS, arrayList);
        }
        if (this._isApplicationBaseDotConfig) {
            this.addFolder(file3, Folder.DOT_CONFIG, arrayList);
        }
        if (this._isApplicationBaseDotEtc) {
            this.addFolder(file3, Folder.DOT_ETC, arrayList);
        }
        if (this._isApplicationBaseDotSettings) {
            this.addFolder(file3, Folder.DOT_SETTINGS, arrayList);
        }
        if (this._isApplicationParentConfig) {
            this.addParentFolder(file3, Folder.CONFIG, arrayList);
        }
        if (this._isApplicationParentEtc) {
            this.addParentFolder(file3, Folder.ETC, arrayList);
        }
        if (this._isApplicationParentSettings) {
            this.addParentFolder(file3, Folder.SETTINGS, arrayList);
        }
        if (this._isApplicationParentDotConfig) {
            this.addParentFolder(file3, Folder.DOT_CONFIG, arrayList);
        }
        if (this._isApplicationParentDotEtc) {
            this.addParentFolder(file3, Folder.DOT_ETC, arrayList);
        }
        if (this._isApplicationParentDotSettings) {
            this.addParentFolder(file3, Folder.DOT_SETTINGS, arrayList);
        }
        if ((file = file3) != null) {
            if (file.getAbsolutePath().endsWith(Folder.TARGET.getName())) {
                this.addFolder(new File(file, Folder.CLASSES.getName()), arrayList);
                this.addFolder(new File(file, Folder.TEST_CLASSES.getName()), arrayList);
            } else {
                this.addFolder(new File(new File(file, Folder.TARGET.getName()), Folder.CLASSES.getName()), arrayList);
                this.addFolder(new File(new File(file, Folder.TARGET.getName()), Folder.TEST_CLASSES.getName()), arrayList);
            }
        }
        if (this._isUserHome) {
            this.addUserHomeFolder(arrayList);
        }
        if (this._isUserHomeConfig) {
            this.addUserHomeFolder(Folder.CONFIG, arrayList);
        }
        if (this._isUserHomeEtc) {
            this.addUserHomeFolder(Folder.ETC, arrayList);
        }
        if (this._isUserHomeSettings) {
            this.addUserHomeFolder(Folder.SETTINGS, arrayList);
        }
        if (this._isUserHomeDotConfig) {
            this.addUserHomeFolder(Folder.DOT_CONFIG, arrayList);
        }
        if (this._isUserHomeDotEtc) {
            this.addUserHomeFolder(Folder.DOT_ETC, arrayList);
        }
        if (this._isUserHomeDotSettings) {
            this.addUserHomeFolder(Folder.DOT_SETTINGS, arrayList);
        }
        if (this._isHostEtc) {
            this.addFolder(new File("/" + Folder.ETC.getName()), arrayList);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private static File toFile(String string, File file) {
        File file2;
        if (file != null && file.isDirectory() && file.canRead() && (file2 = new File(file, string)).exists() && file2.isFile() && file2.canRead()) {
            return file2;
        }
        return null;
    }

    private static File toFolder(String string) {
        File file;
        if (string != null && (file = new File(string)).exists() && file.isDirectory() && file.canRead()) {
            return file;
        }
        return null;
    }

    static File toHomeFolder() {
        File file;
        String string = SystemProperty.USER_HOME.getValue();
        if (string != null && string.length() != 0 && (file = new File(string)).exists() && file.isDirectory() && file.canRead()) {
            return file;
        }
        return null;
    }

    private void addUserHomeFolder(List<File> list) {
        this.addFolder(ConfigLocator.toHomeFolder(), list);
    }

    private void addUserHomeFolder(Folder folder, List<File> list) {
        this.addFolder(ConfigLocator.toHomeFolder(), folder, list);
    }

    private void addFolder(File file, List<File> list) {
        if (file != null && file.exists() && file.isDirectory() && file.canRead()) {
            list.add(file);
        }
    }

    private void addFolder(File file, Folder folder, List<File> list) {
        if (file != null && file.exists() && file.isDirectory() && file.canRead()) {
            file = new File(file, folder.getName());
            this.addFolder(file, list);
        }
    }

    private void addParentFolder(File file, Folder folder, List<File> list) {
        File file2;
        if (file != null && file.exists() && file.isDirectory() && file.canRead() && (file2 = file.getParentFile()) != null && file2.exists() && file2.isDirectory() && file2.canRead()) {
            file2 = new File(file2, folder.getName());
            this.addFolder(file2, list);
        }
    }
}

