/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.ConnectionStatusAccessor;
import org.refcodes.component.LinkComponent;
import org.refcodes.rest.RestEndpoint;
import org.refcodes.rest.RestRequestConsumer;
import org.refcodes.rest.RestRequestEvent;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpMethodAccessor;
import org.refcodes.web.HttpServerResponse;
import org.refcodes.web.HttpStatusException;

public class RestEndpointBuilder
implements RestEndpoint,
HttpMethodAccessor.HttpMethodProperty,
HttpMethodAccessor.HttpMethodBuilder<RestEndpointBuilder>,
LinkComponent.LinkComponentBuilder<RestEndpointBuilder>,
ConnectionStatusAccessor {
    private static final Logger LOGGER = Logger.getLogger(RestEndpointBuilder.class.getName());
    protected RestRequestConsumer _requestObserver = null;
    protected HttpMethod _httpMethod = HttpMethod.GET;
    protected String _locatorPathPattern = null;
    protected Pattern _locatorRegExp = null;
    protected ConnectionStatus _connectionStatus = ConnectionStatus.NONE;

    public RestEndpointBuilder() {
    }

    public RestEndpointBuilder(HttpMethod aHttpMethod, String aLocatorPathPattern, RestRequestConsumer aRequestConsumer) {
        this._httpMethod = aHttpMethod;
        this._locatorPathPattern = aLocatorPathPattern;
        this._requestObserver = aRequestConsumer;
    }

    public RestEndpointBuilder(HttpMethod aHttpMethod, Pattern aLocatorRegExp, RestRequestConsumer aRequestConsumer) {
        this._httpMethod = aHttpMethod;
        this._locatorRegExp = aLocatorRegExp;
        this._requestObserver = aRequestConsumer;
    }

    public RestEndpointBuilder withHttpMethod(HttpMethod aHttpMethod) {
        this.setHttpMethod(aHttpMethod);
        return this;
    }

    public RestEndpointBuilder withLocatorPathPattern(String aLocatorPathPattern) {
        this.setLocatorPathPattern(aLocatorPathPattern);
        return this;
    }

    public RestEndpointBuilder withLocatorRegExp(Pattern aLocatorRegExp) {
        this.setLocatorRegExp(aLocatorRegExp);
        return this;
    }

    public RestEndpointBuilder withRequestObserver(RestRequestConsumer aLambda) {
        this.setRequestObserver(aLambda);
        return this;
    }

    public RestEndpointBuilder withOpen() throws IOException {
        this.open();
        return this;
    }

    public RestEndpointBuilder withClose() throws IOException {
        this.close();
        return this;
    }

    public RestEndpointBuilder withCloseQuietly() {
        this.closeQuietly();
        return this;
    }

    public RestEndpointBuilder withCloseIn(int aCloseMillis) {
        this.closeIn(aCloseMillis);
        return this;
    }

    public void setLocatorPathPattern(String aLocatorPathPattern) {
        this._locatorPathPattern = aLocatorPathPattern;
        this._locatorRegExp = null;
    }

    public void setLocatorRegExp(Pattern aLocatorRegExp) {
        this._locatorRegExp = aLocatorRegExp;
        this._locatorPathPattern = null;
    }

    public void setHttpMethod(HttpMethod aHttpMethod) {
        this._httpMethod = aHttpMethod;
    }

    public void setRequestObserver(RestRequestConsumer aLambda) {
        this._requestObserver = aLambda;
    }

    public RestRequestConsumer getRequestObserver() {
        return this._requestObserver;
    }

    @Override
    public void onRequest(RestRequestEvent aRequest, HttpServerResponse aResponse) throws HttpStatusException {
        if (this._connectionStatus == ConnectionStatus.OPENED) {
            this._requestObserver.onRequest(aRequest, aResponse);
        } else {
            LOGGER.log(Level.WARNING, "Ignoring request <" + String.valueOf((Object)aRequest) + "> as this rest endpoint is in status <" + String.valueOf(this._connectionStatus) + ">, you may not have opened it?");
        }
    }

    public HttpMethod getHttpMethod() {
        return this._httpMethod;
    }

    @Override
    public String getLocatorPathPattern() {
        return this._locatorPathPattern;
    }

    @Override
    public Pattern getLocatorRegExp() {
        return this._locatorRegExp;
    }

    public void open() throws IOException {
        this._connectionStatus = ConnectionStatus.OPENED;
    }

    public void close() throws IOException {
        this._connectionStatus = ConnectionStatus.CLOSED;
    }

    public ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }
}

