/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.controlflow.RetryCounter;
import org.refcodes.data.IoRetryCount;
import org.refcodes.data.IoTimeout;
import org.refcodes.data.RecoverySleepTime;
import org.refcodes.rest.HttpRestClient;
import org.refcodes.rest.RestRequestBuilder;
import org.refcodes.rest.RestResponse;
import org.refcodes.rest.RestfulHttpClient;
import org.refcodes.web.BasicAuthCredentials;
import org.refcodes.web.FormFields;
import org.refcodes.web.GrantType;
import org.refcodes.web.HttpBodyMap;
import org.refcodes.web.HttpMediaType;
import org.refcodes.web.HttpStatusException;
import org.refcodes.web.MediaType;
import org.refcodes.web.OauthField;
import org.refcodes.web.OauthToken;
import org.refcodes.web.Url;

public class OauthTokenHandler
extends OauthToken {
    private static final Logger LOGGER = Logger.getLogger(OauthTokenHandler.class.getName());
    private static final double DELAY_COEFFICIENT = 0.99;
    private static final int DEFAULT_EXPIRES_IN_SECONDS = 180;
    private static final int TOKEN_REFRESH_RETRIES = IoRetryCount.MIN.getValue();
    private static final long TOKEN_REFRESH_RETRY_WAIT_TIME_MILLIS = IoTimeout.MIN.getTimeMillis();
    private static final long SERVER_RECOVERY_WAIT_TIME_MILLIS = RecoverySleepTime.NORM.getTimeMillis();
    private Timer _timer = null;
    private String _url;
    private RestfulHttpClient _restClient;
    private RetryCounter _tokenRefreshRetryCounter;
    private long _serverRecoveryWaitTimeMillis;

    public OauthTokenHandler(Url aUrl, String aClientId, String aClientSecret, String aUserName, String aUserPassword) throws HttpStatusException, IOException {
        this(aUrl.toHttpUrl(), (RestfulHttpClient)new HttpRestClient().withOpen(), aClientId, aClientSecret, aUserName, aUserPassword, (GrantType)null);
    }

    public OauthTokenHandler(Url aUrl, RestfulHttpClient aHttpRestClient, String aClientId, String aClientSecret, String aUserName, String aUserPassword) throws HttpStatusException, MalformedURLException {
        this(aUrl.toHttpUrl(), aHttpRestClient, aClientId, aClientSecret, aUserName, aUserPassword, (GrantType)null);
    }

    public OauthTokenHandler(Url aUrl, RestfulHttpClient aHttpRestClient, String aClientId, String aClientSecret, String aUserName, String aUserPassword, String aGrantType) throws HttpStatusException, MalformedURLException {
        this(aUrl.toHttpUrl(), aHttpRestClient, aClientId, aClientSecret, aUserName, aUserPassword, aGrantType);
    }

    public OauthTokenHandler(Url aUrl, RestfulHttpClient aHttpRestClient, String aClientId, String aClientSecret, String aUserName, String aUserPassword, GrantType aGrantType) throws HttpStatusException, MalformedURLException {
        this(aUrl.toHttpUrl(), aHttpRestClient, aClientId, aClientSecret, aUserName, aUserPassword, aGrantType);
    }

    public OauthTokenHandler(String aUrl, String aClientId, String aClientSecret, String aUserName, String aUserPassword) throws HttpStatusException, IOException {
        this(aUrl, (RestfulHttpClient)new HttpRestClient().withOpen(), aClientId, aClientSecret, aUserName, aUserPassword, (GrantType)null);
    }

    public OauthTokenHandler(String aUrl, String aClientId, String aClientSecret, String aUserName, String aUserPassword, String aGrantType) throws HttpStatusException, IOException {
        this(aUrl, (RestfulHttpClient)new HttpRestClient().withOpen(), aClientId, aClientSecret, aUserName, aUserPassword, GrantType.fromName((String)aGrantType));
    }

    public OauthTokenHandler(String aUrl, String aClientId, String aClientSecret, String aUserName, String aUserPassword, GrantType aGrantType) throws HttpStatusException, IOException {
        this(aUrl, (RestfulHttpClient)new HttpRestClient().withOpen(), aClientId, aClientSecret, aUserName, aUserPassword, aGrantType);
    }

    public OauthTokenHandler(String aUrl, RestfulHttpClient aHttpRestClient, String aClientId, String aClientSecret, String aUserName, String aUserPassword) throws HttpStatusException, MalformedURLException {
        this(aUrl, aHttpRestClient, aClientId, aClientSecret, aUserName, aUserPassword, (GrantType)null);
    }

    public OauthTokenHandler(String aUrl, RestfulHttpClient aHttpRestClient, String aClientId, String aClientSecret, String aUserName, String aUserPassword, String aGrantType) throws HttpStatusException, MalformedURLException {
        this(aUrl, aHttpRestClient, OauthTokenHandler.toOauthToken(aUrl, aHttpRestClient, aClientId, aClientSecret, aUserName, aUserPassword, null, aGrantType));
    }

    public OauthTokenHandler(String aUrl, RestfulHttpClient aHttpRestClient, String aClientId, String aClientSecret, String aUserName, String aUserPassword, GrantType aGrantType) throws HttpStatusException, MalformedURLException {
        this(aUrl, aHttpRestClient, OauthTokenHandler.toOauthToken(aUrl, aHttpRestClient, aClientId, aClientSecret, aUserName, aUserPassword, aGrantType, null));
    }

    public OauthTokenHandler(String aUrl, String aAccessToken, String aRefreshToken, String aTokenType, Integer aExpiresIn, String aScope) throws IOException {
        super(aAccessToken, aRefreshToken, aTokenType, aExpiresIn, aScope);
        this.initialize(aUrl, new HttpRestClient().withOpen(), new RetryCounter(TOKEN_REFRESH_RETRIES, TOKEN_REFRESH_RETRY_WAIT_TIME_MILLIS), SERVER_RECOVERY_WAIT_TIME_MILLIS);
    }

    public OauthTokenHandler(Url aUrl, String aAccessToken, String aRefreshToken, String aTokenType, Integer aExpiresIn, String aScope) throws IOException {
        super(aAccessToken, aRefreshToken, aTokenType, aExpiresIn, aScope);
        this.initialize(aUrl.toHttpUrl(), new HttpRestClient().withOpen(), new RetryCounter(TOKEN_REFRESH_RETRIES, TOKEN_REFRESH_RETRY_WAIT_TIME_MILLIS), SERVER_RECOVERY_WAIT_TIME_MILLIS);
    }

    public OauthTokenHandler(Url aUrl, HttpBodyMap aOauthToken) throws IOException {
        super(aOauthToken);
        this.initialize(aUrl.toHttpUrl(), new HttpRestClient().withOpen(), new RetryCounter(TOKEN_REFRESH_RETRIES, TOKEN_REFRESH_RETRY_WAIT_TIME_MILLIS), SERVER_RECOVERY_WAIT_TIME_MILLIS);
    }

    public OauthTokenHandler(Url aUrl, OauthToken aOauthToken) throws IOException {
        super(aOauthToken);
        this.initialize(aUrl.toHttpUrl(), new HttpRestClient().withOpen(), new RetryCounter(TOKEN_REFRESH_RETRIES, TOKEN_REFRESH_RETRY_WAIT_TIME_MILLIS), SERVER_RECOVERY_WAIT_TIME_MILLIS);
    }

    public OauthTokenHandler(String aUrl, OauthToken aOauthToken) throws IOException {
        super(aOauthToken);
        this.initialize(aUrl, new HttpRestClient().withOpen(), new RetryCounter(TOKEN_REFRESH_RETRIES, TOKEN_REFRESH_RETRY_WAIT_TIME_MILLIS), SERVER_RECOVERY_WAIT_TIME_MILLIS);
    }

    public OauthTokenHandler(Url aUrl, RestfulHttpClient aHttpRestClient, String aAccessToken, String aRefreshToken, String aTokenType, Integer aExpiresIn, String aScope) {
        super(aAccessToken, aRefreshToken, aTokenType, aExpiresIn, aScope);
        this.initialize(aUrl.toHttpUrl(), aHttpRestClient, new RetryCounter(TOKEN_REFRESH_RETRIES, TOKEN_REFRESH_RETRY_WAIT_TIME_MILLIS), SERVER_RECOVERY_WAIT_TIME_MILLIS);
    }

    public OauthTokenHandler(Url aUrl, RestfulHttpClient aHttpRestClient, HttpBodyMap aOauthToken) {
        super(aOauthToken);
        this.initialize(aUrl.toHttpUrl(), aHttpRestClient, new RetryCounter(TOKEN_REFRESH_RETRIES, TOKEN_REFRESH_RETRY_WAIT_TIME_MILLIS), SERVER_RECOVERY_WAIT_TIME_MILLIS);
    }

    public OauthTokenHandler(String aUrl, RestfulHttpClient aHttpRestClient, OauthToken aOauthToken) {
        super(aOauthToken);
        this.initialize(aUrl, aHttpRestClient, new RetryCounter(TOKEN_REFRESH_RETRIES, TOKEN_REFRESH_RETRY_WAIT_TIME_MILLIS), SERVER_RECOVERY_WAIT_TIME_MILLIS);
    }

    public OauthTokenHandler(Url aUrl, RestfulHttpClient aHttpRestClient, OauthToken aOauthToken) {
        super(aOauthToken);
        this.initialize(aUrl.toHttpUrl(), aHttpRestClient, new RetryCounter(TOKEN_REFRESH_RETRIES, TOKEN_REFRESH_RETRY_WAIT_TIME_MILLIS), SERVER_RECOVERY_WAIT_TIME_MILLIS);
    }

    public OauthTokenHandler(String aUrl, RestfulHttpClient aHttpRestClient, String aAccessToken, String aRefreshToken, String aTokenType, Integer aExpiresIn, String aScope) {
        super(aAccessToken, aRefreshToken, aTokenType, aExpiresIn, aScope);
        this.initialize(aUrl, aHttpRestClient, new RetryCounter(TOKEN_REFRESH_RETRIES, TOKEN_REFRESH_RETRY_WAIT_TIME_MILLIS), SERVER_RECOVERY_WAIT_TIME_MILLIS);
    }

    public OauthTokenHandler(Url aUrl, String aClientId, String aClientSecret, String aUserName, String aUserPassword, int aTokenRefreshRetries, long aTokenRefreshRetryWaitTimeMillis, long aServerRecoveryWaitTimeMillis) throws HttpStatusException, IOException {
        this(aUrl.toHttpUrl(), (RestfulHttpClient)new HttpRestClient().withOpen(), aClientId, aClientSecret, aUserName, aUserPassword, (GrantType)null, new RetryCounter(aTokenRefreshRetries, aTokenRefreshRetryWaitTimeMillis), aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(Url aUrl, RestfulHttpClient aHttpRestClient, String aClientId, String aClientSecret, String aUserName, String aUserPassword, int aTokenRefreshRetries, long aTokenRefreshRetryWaitTimeMillis, long aServerRecoveryWaitTimeMillis) throws HttpStatusException, MalformedURLException {
        this(aUrl.toHttpUrl(), aHttpRestClient, aClientId, aClientSecret, aUserName, aUserPassword, (GrantType)null, new RetryCounter(aTokenRefreshRetries, aTokenRefreshRetryWaitTimeMillis), aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(Url aUrl, RestfulHttpClient aHttpRestClient, String aClientId, String aClientSecret, String aUserName, String aUserPassword, String aGrantType, int aTokenRefreshRetries, long aTokenRefreshRetryWaitTimeMillis, long aServerRecoveryWaitTimeMillis) throws HttpStatusException, MalformedURLException {
        this(aUrl.toHttpUrl(), aHttpRestClient, aClientId, aClientSecret, aUserName, aUserPassword, aGrantType, new RetryCounter(aTokenRefreshRetries, aTokenRefreshRetryWaitTimeMillis), aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(Url aUrl, RestfulHttpClient aHttpRestClient, String aClientId, String aClientSecret, String aUserName, String aUserPassword, GrantType aGrantType, int aTokenRefreshRetries, long aTokenRefreshRetryWaitTimeMillis, long aServerRecoveryWaitTimeMillis) throws HttpStatusException, MalformedURLException {
        this(aUrl.toHttpUrl(), aHttpRestClient, aClientId, aClientSecret, aUserName, aUserPassword, aGrantType, new RetryCounter(aTokenRefreshRetries, aTokenRefreshRetryWaitTimeMillis), aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(String aUrl, String aClientId, String aClientSecret, String aUserName, String aUserPassword, int aTokenRefreshRetries, long aTokenRefreshRetryWaitTimeMillis, long aServerRecoveryWaitTimeMillis) throws HttpStatusException, IOException {
        this(aUrl, (RestfulHttpClient)new HttpRestClient().withOpen(), aClientId, aClientSecret, aUserName, aUserPassword, (GrantType)null, new RetryCounter(aTokenRefreshRetries, aTokenRefreshRetryWaitTimeMillis), aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(String aUrl, String aClientId, String aClientSecret, String aUserName, String aUserPassword, String aGrantType, int aTokenRefreshRetries, long aTokenRefreshRetryWaitTimeMillis, long aServerRecoveryWaitTimeMillis) throws HttpStatusException, IOException {
        this(aUrl, (RestfulHttpClient)new HttpRestClient().withOpen(), aClientId, aClientSecret, aUserName, aUserPassword, GrantType.fromName((String)aGrantType), new RetryCounter(aTokenRefreshRetries, aTokenRefreshRetryWaitTimeMillis), aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(String aUrl, String aClientId, String aClientSecret, String aUserName, String aUserPassword, GrantType aGrantType, int aTokenRefreshRetries, long aTokenRefreshRetryWaitTimeMillis, long aServerRecoveryWaitTimeMillis) throws HttpStatusException, IOException {
        this(aUrl, (RestfulHttpClient)new HttpRestClient().withOpen(), aClientId, aClientSecret, aUserName, aUserPassword, aGrantType, new RetryCounter(aTokenRefreshRetries, aTokenRefreshRetryWaitTimeMillis), aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(String aUrl, RestfulHttpClient aHttpRestClient, String aClientId, String aClientSecret, String aUserName, String aUserPassword, int aTokenRefreshRetries, long aTokenRefreshRetryWaitTimeMillis, long aServerRecoveryWaitTimeMillis) throws HttpStatusException, MalformedURLException {
        this(aUrl, aHttpRestClient, aClientId, aClientSecret, aUserName, aUserPassword, (GrantType)null, new RetryCounter(aTokenRefreshRetries, aTokenRefreshRetryWaitTimeMillis), aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(String aUrl, RestfulHttpClient aHttpRestClient, String aClientId, String aClientSecret, String aUserName, String aUserPassword, String aGrantType, int aTokenRefreshRetries, long aTokenRefreshRetryWaitTimeMillis, long aServerRecoveryWaitTimeMillis) throws HttpStatusException, MalformedURLException {
        this(aUrl, aHttpRestClient, OauthTokenHandler.toOauthToken(aUrl, aHttpRestClient, aClientId, aClientSecret, aUserName, aUserPassword, null, aGrantType), new RetryCounter(aTokenRefreshRetries, aTokenRefreshRetryWaitTimeMillis), aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(String aUrl, RestfulHttpClient aHttpRestClient, String aClientId, String aClientSecret, String aUserName, String aUserPassword, GrantType aGrantType, int aTokenRefreshRetries, long aTokenRefreshRetryWaitTimeMillis, long aServerRecoveryWaitTimeMillis) throws HttpStatusException, MalformedURLException {
        this(aUrl, aHttpRestClient, OauthTokenHandler.toOauthToken(aUrl, aHttpRestClient, aClientId, aClientSecret, aUserName, aUserPassword, aGrantType, null), new RetryCounter(aTokenRefreshRetries, aTokenRefreshRetryWaitTimeMillis), aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(String aUrl, String aAccessToken, String aRefreshToken, String aTokenType, Integer aExpiresIn, String aScope, int aTokenRefreshRetries, long aTokenRefreshRetryWaitTimeMillis, long aServerRecoveryWaitTimeMillis) throws IOException {
        super(aAccessToken, aRefreshToken, aTokenType, aExpiresIn, aScope);
        this.initialize(aUrl, new HttpRestClient().withOpen(), new RetryCounter(aTokenRefreshRetries, aTokenRefreshRetryWaitTimeMillis), aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(Url aUrl, String aAccessToken, String aRefreshToken, String aTokenType, Integer aExpiresIn, String aScope, int aTokenRefreshRetries, long aTokenRefreshRetryWaitTimeMillis, long aServerRecoveryWaitTimeMillis) throws IOException {
        super(aAccessToken, aRefreshToken, aTokenType, aExpiresIn, aScope);
        this.initialize(aUrl.toHttpUrl(), new HttpRestClient().withOpen(), new RetryCounter(aTokenRefreshRetries, aTokenRefreshRetryWaitTimeMillis), aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(Url aUrl, HttpBodyMap aOauthToken, int aTokenRefreshRetries, long aTokenRefreshRetryWaitTimeMillis, long aServerRecoveryWaitTimeMillis) throws IOException {
        super(aOauthToken);
        this.initialize(aUrl.toHttpUrl(), new HttpRestClient().withOpen(), new RetryCounter(aTokenRefreshRetries, aTokenRefreshRetryWaitTimeMillis), aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(Url aUrl, OauthToken aOauthToken, int aTokenRefreshRetries, long aTokenRefreshRetryWaitTimeMillis, long aServerRecoveryWaitTimeMillis) throws IOException {
        super(aOauthToken);
        this.initialize(aUrl.toHttpUrl(), new HttpRestClient().withOpen(), new RetryCounter(aTokenRefreshRetries, aTokenRefreshRetryWaitTimeMillis), aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(String aUrl, OauthToken aOauthToken, int aTokenRefreshRetries, long aTokenRefreshRetryWaitTimeMillis, long aServerRecoveryWaitTimeMillis) throws IOException {
        super(aOauthToken);
        this.initialize(aUrl, new HttpRestClient().withOpen(), new RetryCounter(aTokenRefreshRetries, aTokenRefreshRetryWaitTimeMillis), aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(Url aUrl, RestfulHttpClient aHttpRestClient, String aAccessToken, String aRefreshToken, String aTokenType, Integer aExpiresIn, String aScope, int aTokenRefreshRetries, long aTokenRefreshRetryWaitTimeMillis, long aServerRecoveryWaitTimeMillis) {
        super(aAccessToken, aRefreshToken, aTokenType, aExpiresIn, aScope);
        this.initialize(aUrl.toHttpUrl(), aHttpRestClient, new RetryCounter(aTokenRefreshRetries, aTokenRefreshRetryWaitTimeMillis), aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(Url aUrl, RestfulHttpClient aHttpRestClient, HttpBodyMap aOauthToken, int aTokenRefreshRetries, long aTokenRefreshRetryWaitTimeMillis, long aServerRecoveryWaitTimeMillis) {
        super(aOauthToken);
        this.initialize(aUrl.toHttpUrl(), aHttpRestClient, new RetryCounter(aTokenRefreshRetries, aTokenRefreshRetryWaitTimeMillis), aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(String aUrl, RestfulHttpClient aHttpRestClient, OauthToken aOauthToken, int aTokenRefreshRetries, long aTokenRefreshRetryWaitTimeMillis, long aServerRecoveryWaitTimeMillis) {
        super(aOauthToken);
        this.initialize(aUrl, aHttpRestClient, new RetryCounter(aTokenRefreshRetries, aTokenRefreshRetryWaitTimeMillis), aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(Url aUrl, RestfulHttpClient aHttpRestClient, OauthToken aOauthToken, int aTokenRefreshRetries, long aTokenRefreshRetryWaitTimeMillis, long aServerRecoveryWaitTimeMillis) {
        super(aOauthToken);
        this.initialize(aUrl.toHttpUrl(), aHttpRestClient, new RetryCounter(aTokenRefreshRetries, aTokenRefreshRetryWaitTimeMillis), aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(String aUrl, RestfulHttpClient aHttpRestClient, String aAccessToken, String aRefreshToken, String aTokenType, Integer aExpiresIn, String aScope, int aTokenRefreshRetries, long aTokenRefreshRetryWaitTimeMillis, long aServerRecoveryWaitTimeMillis) {
        super(aAccessToken, aRefreshToken, aTokenType, aExpiresIn, aScope);
        this.initialize(aUrl, aHttpRestClient, new RetryCounter(aTokenRefreshRetries, aTokenRefreshRetryWaitTimeMillis), aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(Url aUrl, String aClientId, String aClientSecret, String aUserName, String aUserPassword, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) throws HttpStatusException, IOException {
        this(aUrl.toHttpUrl(), (RestfulHttpClient)new HttpRestClient().withOpen(), aClientId, aClientSecret, aUserName, aUserPassword, (GrantType)null, aTokenRefreshRetryCounter, aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(Url aUrl, RestfulHttpClient aHttpRestClient, String aClientId, String aClientSecret, String aUserName, String aUserPassword, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) throws HttpStatusException, MalformedURLException {
        this(aUrl.toHttpUrl(), aHttpRestClient, aClientId, aClientSecret, aUserName, aUserPassword, (GrantType)null, aTokenRefreshRetryCounter, aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(Url aUrl, RestfulHttpClient aHttpRestClient, String aClientId, String aClientSecret, String aUserName, String aUserPassword, String aGrantType, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) throws HttpStatusException, MalformedURLException {
        this(aUrl.toHttpUrl(), aHttpRestClient, aClientId, aClientSecret, aUserName, aUserPassword, aGrantType, aTokenRefreshRetryCounter, aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(Url aUrl, RestfulHttpClient aHttpRestClient, String aClientId, String aClientSecret, String aUserName, String aUserPassword, GrantType aGrantType, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) throws HttpStatusException, MalformedURLException {
        this(aUrl.toHttpUrl(), aHttpRestClient, aClientId, aClientSecret, aUserName, aUserPassword, aGrantType, aTokenRefreshRetryCounter, aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(String aUrl, String aClientId, String aClientSecret, String aUserName, String aUserPassword, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) throws HttpStatusException, IOException {
        this(aUrl, (RestfulHttpClient)new HttpRestClient().withOpen(), aClientId, aClientSecret, aUserName, aUserPassword, (GrantType)null, aTokenRefreshRetryCounter, aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(String aUrl, String aClientId, String aClientSecret, String aUserName, String aUserPassword, String aGrantType, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) throws HttpStatusException, IOException {
        this(aUrl, (RestfulHttpClient)new HttpRestClient().withOpen(), aClientId, aClientSecret, aUserName, aUserPassword, GrantType.fromName((String)aGrantType), aTokenRefreshRetryCounter, aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(String aUrl, String aClientId, String aClientSecret, String aUserName, String aUserPassword, GrantType aGrantType, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) throws HttpStatusException, IOException {
        this(aUrl, (RestfulHttpClient)new HttpRestClient().withOpen(), aClientId, aClientSecret, aUserName, aUserPassword, aGrantType, aTokenRefreshRetryCounter, aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(String aUrl, RestfulHttpClient aHttpRestClient, String aClientId, String aClientSecret, String aUserName, String aUserPassword, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) throws HttpStatusException, MalformedURLException {
        this(aUrl, aHttpRestClient, aClientId, aClientSecret, aUserName, aUserPassword, (GrantType)null, aTokenRefreshRetryCounter, aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(String aUrl, RestfulHttpClient aHttpRestClient, String aClientId, String aClientSecret, String aUserName, String aUserPassword, String aGrantType, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) throws HttpStatusException, MalformedURLException {
        this(aUrl, aHttpRestClient, OauthTokenHandler.toOauthToken(aUrl, aHttpRestClient, aClientId, aClientSecret, aUserName, aUserPassword, null, aGrantType), aTokenRefreshRetryCounter, aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(String aUrl, RestfulHttpClient aHttpRestClient, String aClientId, String aClientSecret, String aUserName, String aUserPassword, GrantType aGrantType, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) throws HttpStatusException, MalformedURLException {
        this(aUrl, aHttpRestClient, OauthTokenHandler.toOauthToken(aUrl, aHttpRestClient, aClientId, aClientSecret, aUserName, aUserPassword, aGrantType, null), aTokenRefreshRetryCounter, aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(String aUrl, String aAccessToken, String aRefreshToken, String aTokenType, Integer aExpiresIn, String aScope, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) throws IOException {
        super(aAccessToken, aRefreshToken, aTokenType, aExpiresIn, aScope);
        this.initialize(aUrl, new HttpRestClient().withOpen(), aTokenRefreshRetryCounter, aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(Url aUrl, String aAccessToken, String aRefreshToken, String aTokenType, Integer aExpiresIn, String aScope, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) throws IOException {
        super(aAccessToken, aRefreshToken, aTokenType, aExpiresIn, aScope);
        this.initialize(aUrl.toHttpUrl(), new HttpRestClient().withOpen(), aTokenRefreshRetryCounter, aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(Url aUrl, HttpBodyMap aOauthToken, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) throws IOException {
        super(aOauthToken);
        this.initialize(aUrl.toHttpUrl(), new HttpRestClient().withOpen(), aTokenRefreshRetryCounter, aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(Url aUrl, OauthToken aOauthToken, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) throws IOException {
        super(aOauthToken);
        this.initialize(aUrl.toHttpUrl(), new HttpRestClient().withOpen(), aTokenRefreshRetryCounter, aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(String aUrl, OauthToken aOauthToken, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) throws IOException {
        super(aOauthToken);
        this.initialize(aUrl, new HttpRestClient().withOpen(), aTokenRefreshRetryCounter, aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(Url aUrl, RestfulHttpClient aHttpRestClient, String aAccessToken, String aRefreshToken, String aTokenType, Integer aExpiresIn, String aScope, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) {
        super(aAccessToken, aRefreshToken, aTokenType, aExpiresIn, aScope);
        this.initialize(aUrl.toHttpUrl(), aHttpRestClient, aTokenRefreshRetryCounter, aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(Url aUrl, RestfulHttpClient aHttpRestClient, HttpBodyMap aOauthToken, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) {
        super(aOauthToken);
        this.initialize(aUrl.toHttpUrl(), aHttpRestClient, aTokenRefreshRetryCounter, aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(String aUrl, RestfulHttpClient aHttpRestClient, OauthToken aOauthToken, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) {
        super(aOauthToken);
        this.initialize(aUrl, aHttpRestClient, aTokenRefreshRetryCounter, aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(Url aUrl, RestfulHttpClient aHttpRestClient, OauthToken aOauthToken, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) {
        super(aOauthToken);
        this.initialize(aUrl.toHttpUrl(), aHttpRestClient, aTokenRefreshRetryCounter, aServerRecoveryWaitTimeMillis);
    }

    public OauthTokenHandler(String aUrl, RestfulHttpClient aHttpRestClient, String aAccessToken, String aRefreshToken, String aTokenType, Integer aExpiresIn, String aScope, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) {
        super(aAccessToken, aRefreshToken, aTokenType, aExpiresIn, aScope);
        this.initialize(aUrl, aHttpRestClient, aTokenRefreshRetryCounter, aServerRecoveryWaitTimeMillis);
    }

    private void initialize(String aUrl, RestfulHttpClient aHttpRestClient, RetryCounter aTokenRefreshRetryCounter, long aServerRecoveryWaitTimeMillis) {
        if (aHttpRestClient != null && !aHttpRestClient.isOpened()) {
            LOGGER.log(Level.WARNING, "The provided <" + aHttpRestClient.getClass().getSimpleName() + "> being in status <" + String.valueOf(aHttpRestClient.getConnectionStatus()) + "> must be in status <" + String.valueOf(ConnectionStatus.OPENED) + "> when provided for the token refresh loop to get set up!");
        }
        if (this._refreshToken != null) {
            Integer theExpiresIn = this._expiresIn;
            if (theExpiresIn == null || theExpiresIn == -1) {
                theExpiresIn = 180;
            }
            this._url = aUrl;
            this._restClient = aHttpRestClient;
            this._timer = new Timer(true);
            this._timer.schedule((TimerTask)new RefreshTask(), this.toDelayMillis(theExpiresIn));
        }
        this._tokenRefreshRetryCounter = aTokenRefreshRetryCounter != null ? aTokenRefreshRetryCounter : new RetryCounter(TOKEN_REFRESH_RETRIES, TOKEN_REFRESH_RETRY_WAIT_TIME_MILLIS);
        this._serverRecoveryWaitTimeMillis = aServerRecoveryWaitTimeMillis > 0L ? aServerRecoveryWaitTimeMillis : SERVER_RECOVERY_WAIT_TIME_MILLIS;
    }

    public synchronized void dispose() {
        if (this._timer != null) {
            this._timer.cancel();
        }
        super.dispose();
    }

    private long toDelayMillis(Integer aExpiresInSecs) {
        Double theTimeout = (double)aExpiresInSecs.intValue() * 1000.0 * 0.99;
        long theDelay = theTimeout.longValue();
        return theDelay;
    }

    private static OauthToken toOauthToken(String aUrl, RestfulHttpClient aHttpRestClient, String aClientId, String aClientSecret, String aUserName, String aUserPassword, GrantType aGrantType, String aCustomGrant) throws MalformedURLException, HttpStatusException {
        String theGrantType;
        RestRequestBuilder theRequestBuilder = aHttpRestClient.buildPost(aUrl);
        theRequestBuilder.getHeaderFields().putAcceptTypes(new HttpMediaType[]{MediaType.APPLICATION_JSON});
        String string = theGrantType = aGrantType != null ? aGrantType.getValue() : aCustomGrant;
        if (aClientId != null && aClientId.length() != 0) {
            theFormFields = new FormFields();
            theFormFields.put(OauthField.CLIENT_ID.getName(), aClientId);
            if (aClientSecret != null && aClientSecret.length() != 0) {
                theFormFields.put(OauthField.CLIENT_SECRET.getName(), aClientSecret);
            }
            if (aUserName != null && aUserName.length() != 0) {
                theFormFields.put(OauthField.USER_NAME.getName(), aUserName);
            }
            if (aUserPassword != null && aUserPassword.length() != 0) {
                theFormFields.put(OauthField.PASSWORD.getName(), aUserPassword);
            }
            theFormFields.put(OauthField.GRANT_TYPE.getName(), theGrantType != null ? theGrantType : GrantType.PASSWORD.getValue());
            theRequestBuilder.setRequest(theFormFields);
        } else {
            if (theGrantType != null) {
                theFormFields = new FormFields();
                theFormFields.put(theGrantType, new String[0]);
                theRequestBuilder.setRequest(theFormFields);
            }
            BasicAuthCredentials theCredentials = new BasicAuthCredentials(aUserName, aUserPassword);
            theRequestBuilder.getHeaderFields().putBasicAuthCredentials(theCredentials);
        }
        RestResponse theResponse = theRequestBuilder.toRestResponse();
        if (theResponse.getHttpStatusCode().isErrorStatus()) {
            throw theResponse.getHttpStatusCode().toHttpStatusException(theResponse.getHttpBody());
        }
        OauthToken theToken = new OauthToken(theResponse.getResponse());
        return theToken;
    }

    private class RefreshTask
    extends TimerTask {
        private RefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!OauthTokenHandler.this._isDisposed) {
                OauthTokenHandler oauthTokenHandler = OauthTokenHandler.this;
                synchronized (oauthTokenHandler) {
                    if (!OauthTokenHandler.this._restClient.isOpened()) {
                        LOGGER.log(Level.WARNING, "The rest client, being in status <" + String.valueOf(OauthTokenHandler.this._restClient.getConnectionStatus()) + ">, must be in status <" + String.valueOf(ConnectionStatus.OPENED) + "> (waiting for <" + OauthTokenHandler.this._serverRecoveryWaitTimeMillis + "> milliseconds before next retry)!");
                        OauthTokenHandler.this._timer.schedule((TimerTask)new RefreshTask(), OauthTokenHandler.this._serverRecoveryWaitTimeMillis);
                    } else {
                        if (OauthTokenHandler.this._refreshToken == null) {
                            LOGGER.log(Level.WARNING, "No refresh token available, aborting refresh timer!");
                            if (OauthTokenHandler.this._timer != null) {
                                OauthTokenHandler.this._timer.cancel();
                            }
                            return;
                        }
                        Exception theException = null;
                        String theUrl = OauthTokenHandler.this._url;
                        OauthTokenHandler.this._tokenRefreshRetryCounter.restart();
                        while (OauthTokenHandler.this._tokenRefreshRetryCounter.nextRetry()) {
                            try {
                                RestResponse theResponse;
                                RestRequestBuilder theBuilder = OauthTokenHandler.this._restClient.buildPost(theUrl);
                                theBuilder.getHeaderFields().putAcceptTypes(new HttpMediaType[]{MediaType.APPLICATION_JSON});
                                theBuilder.getHeaderFields().putContentType((HttpMediaType)MediaType.APPLICATION_X_WWW_FORM_URLENCODED);
                                theBuilder.setRedirectDepth(3);
                                FormFields theFormFields = new FormFields();
                                theFormFields.put(OauthField.GRANT_TYPE.getName(), GrantType.REFRESH_TOKEN.getValue());
                                theFormFields.put(OauthField.REFRESH_TOKEN.getName(), OauthTokenHandler.this.getRefreshToken());
                                theBuilder.setRequest(theFormFields);
                                if (OauthTokenHandler.this.getScope() != null) {
                                    theFormFields.put(OauthField.SCOPE.getName(), OauthTokenHandler.this.getScope());
                                }
                                if ((theResponse = theBuilder.toRestResponse()).getHttpStatusCode().isSuccessStatus()) {
                                    HttpBodyMap theBody = theResponse.getResponse();
                                    OauthTokenHandler.this.updateToken(theBody);
                                    Integer theExpiresInSeconds = OauthTokenHandler.this._expiresIn;
                                    if (theExpiresInSeconds == null || theExpiresInSeconds == -1) {
                                        theExpiresInSeconds = 180;
                                    }
                                    OauthTokenHandler.this._timer.schedule((TimerTask)new RefreshTask(), OauthTokenHandler.this.toDelayMillis(theExpiresInSeconds));
                                    return;
                                }
                                if (!theResponse.getHttpStatusCode().isClientErrorStatus()) continue;
                                LOGGER.log(Level.WARNING, "Client can not refresh tokens, aborting refresh timer as of client error <" + theResponse.getHttpStatusCode().getStatusCode() + "> (" + String.valueOf(theResponse.getHttpStatusCode()) + "): " + theResponse.getHttpBody());
                                if (OauthTokenHandler.this._timer != null) {
                                    OauthTokenHandler.this._timer.cancel();
                                }
                                return;
                            }
                            catch (Exception e) {
                                if (theException != null) continue;
                                theException = e;
                            }
                        }
                        LOGGER.log(Level.WARNING, "Unable to refresh token within <" + OauthTokenHandler.this._tokenRefreshRetryCounter.getRetryNumber() + "> tries and a delay of <" + OauthTokenHandler.this._tokenRefreshRetryCounter.getTotalRetryDelayMillis() + "> milliseconds altogether (waiting for <" + OauthTokenHandler.this._serverRecoveryWaitTimeMillis + "> milliseconds before next retry)" + (String)(theException != null ? " as of: " + theException.getLocalizedMessage() : "!"), theException);
                        OauthTokenHandler.this._timer.schedule((TimerTask)new RefreshTask(), OauthTokenHandler.this._serverRecoveryWaitTimeMillis);
                    }
                }
            }
        }
    }
}

