/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import org.refcodes.component.Configurable;
import org.refcodes.component.InitializeException;
import org.refcodes.component.LifecycleComponent;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;
import org.refcodes.data.Scheme;
import org.refcodes.mixin.AliasAccessor;
import org.refcodes.mixin.InstanceIdAccessor;
import org.refcodes.net.IpAddressAccessor;
import org.refcodes.rest.HttpRegistryContext;
import org.refcodes.rest.HttpRegistryUrlAccessor;
import org.refcodes.rest.HttpServerDescriptor;
import org.refcodes.rest.HttpServerDescriptorAccessor;
import org.refcodes.rest.HttpServerDescriptorFactory;
import org.refcodes.rest.PingPathAccessor;
import org.refcodes.security.TrustStoreDescriptor;
import org.refcodes.security.TrustStoreDescriptorAccessor;
import org.refcodes.web.HostAccessor;
import org.refcodes.web.Url;
import org.refcodes.web.VirtualHostAccessor;

public interface HttpRegistry<DESC extends HttpServerDescriptor, B extends HttpRegistry<DESC, B>>
extends Configurable<HttpRegistryContext<DESC>>,
HttpServerDescriptorAccessor.HttpServerDescriptorProperty<DESC>,
HttpServerDescriptorAccessor.HttpServerDescriptorBuilder<DESC, B>,
PingPathAccessor.PingPathProperty,
PingPathAccessor.PingPathBuilder<B>,
HostAccessor.HostProperty,
HostAccessor.HostBuilder<B>,
VirtualHostAccessor.VirtualHostProperty,
VirtualHostAccessor.VirtualHostBuilder<B>,
IpAddressAccessor.IpAddressProperty,
IpAddressAccessor.IpAddressBuilder<B>,
InstanceIdAccessor.InstanceIdProperty,
InstanceIdAccessor.InstanceIdBuilder<B>,
AliasAccessor.AliasProperty,
AliasAccessor.AliasBuilder<B>,
LifecycleComponent.LifecycleAutomaton,
HttpRegistryUrlAccessor.HttpRegistryUrlProperty,
HttpRegistryUrlAccessor.HttpRegistryUrlBuilder<B>,
TrustStoreDescriptorAccessor.TrustStoreDescriptorProperty,
TrustStoreDescriptorAccessor.TrustStoreDescriptorBuilder<B>,
HttpServerDescriptorFactory<DESC> {
    default public B withAlias(String aAlias) {
        this.setAlias(aAlias);
        return (B)this;
    }

    @Override
    default public B withPingPath(String aPingPath) {
        this.setPingPath(aPingPath);
        return (B)this;
    }

    @Override
    default public B withHttpRegistryUrl(Url aUrl) {
        this.setHttpRegistryUrl(aUrl);
        return (B)this;
    }

    @Override
    default public B withHttpServerDescriptor(DESC aServerDescriptor) {
        this.setHttpServerDescriptor((HttpServerDescriptor)aServerDescriptor);
        return (B)this;
    }

    default public B withHost(String aHost) {
        this.setHost(aHost);
        return (B)this;
    }

    default public B withVirtualHost(String aVirtualHost) {
        this.setVirtualHost(aVirtualHost);
        return (B)this;
    }

    default public B withIpAddress(int[] aIpAddress) {
        this.setIpAddress(aIpAddress);
        return (B)this;
    }

    default public B withCidrNotation(String aCidrNotation) {
        this.fromCidrNotation(aCidrNotation);
        return (B)this;
    }

    default public B withTrustStoreDescriptor(TrustStoreDescriptor aStoreDescriptor) {
        this.setTrustStoreDescriptor(aStoreDescriptor);
        return (B)this;
    }

    default public B withInstanceId(String aInstanceId) {
        this.setInstanceId(aInstanceId);
        return (B)this;
    }

    default public void initialize() throws InitializeException {
        this.initialize(null, null, null);
    }

    default public void initialize(HttpRegistryContext<DESC> aRegistryContext) throws InitializeException {
        this.initialize(aRegistryContext.getHttpServerDescriptor(), aRegistryContext.getHttpRegistryUrl(), aRegistryContext.getTrustStoreDescriptor());
    }

    default public void initialize(DESC aServerDescriptor, Url aRegistryUrl) throws InitializeException {
        this.initialize(aServerDescriptor, aRegistryUrl, null);
    }

    public void initialize(DESC var1, Url var2, TrustStoreDescriptor var3) throws InitializeException;

    default public void initialize(String aAlias, String aInstanceId, Scheme aScheme, int aPort, Url aRegistryUrl) throws InitializeException {
        this.initialize(aAlias, aInstanceId, aScheme, null, null, null, aPort, null, aRegistryUrl);
    }

    default public void initialize(String aAlias, Scheme aScheme, String aHost, int aPort, Url aRegistryUrl) throws InitializeException {
        this.initialize(aAlias, null, aScheme, aHost, null, null, aPort, null, aRegistryUrl);
    }

    default public void initialize(String aAlias, Scheme aScheme, String aHost, String aVirtualHost, int[] aIpAddress, int aPort, String aPingPath, Url aRegistryUrl) throws InitializeException {
        this.initialize(this.toHttpServerDescriptor(aAlias, aScheme, aHost, aVirtualHost, aIpAddress, aPort, aPingPath), aRegistryUrl);
    }

    default public void initialize(String aAlias, String aInstanceId, Scheme aScheme, String aHost, String aVirtualHost, int[] aIpAddress, int aPort, String aPingPath, Url aRegistryUrl) throws InitializeException {
        this.initialize(this.toHttpServerDescriptor(aAlias, aInstanceId, aScheme, aHost, aVirtualHost, aIpAddress, aPort, aPingPath), aRegistryUrl);
    }

    public void start() throws StartException;

    public void pause() throws PauseException;

    public void resume() throws ResumeException;

    public void stop() throws StopException;

    public void destroy();
}

