/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.refcodes.component.InitializeException;
import org.refcodes.component.LifecycleMachine;
import org.refcodes.component.LifecycleStatus;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;
import org.refcodes.data.Scheme;
import org.refcodes.mixin.AliasAccessor;
import org.refcodes.mixin.InstanceIdAccessor;
import org.refcodes.mixin.PortAccessor;
import org.refcodes.net.IpAddress;
import org.refcodes.net.IpAddressAccessor;
import org.refcodes.rest.HttpRegistrySidecar;
import org.refcodes.rest.HttpRegistryUrlAccessor;
import org.refcodes.rest.HttpServerDescriptor;
import org.refcodes.rest.HttpServerDescriptorAccessor;
import org.refcodes.rest.PingPathAccessor;
import org.refcodes.rest.RestRequestConsumer;
import org.refcodes.security.TrustStoreDescriptor;
import org.refcodes.security.TrustStoreDescriptorAccessor;
import org.refcodes.web.HostAccessor;
import org.refcodes.web.SchemeAccessor;
import org.refcodes.web.Url;
import org.refcodes.web.VirtualHostAccessor;

public abstract class AbstractHttpRegistrySidecar<DESC extends HttpServerDescriptor, B extends HttpRegistrySidecar<DESC, B>>
implements HttpRegistrySidecar<DESC, B> {
    protected LifecycleMachine.ManualLifecycleMachine _lifeCycleAutomaton = new LifecycleMachine.ManualLifecycleMachine();
    private Url _serviceRegistryUrl;
    private DESC _serverDescriptor;
    private TrustStoreDescriptor _storeDescriptor;
    private String _alias;
    private String _instanceId;
    private String _host;
    private String _virtualHost;
    private int[] _ipAddress;
    private String _pingPath;
    protected RestRequestConsumer _pingRequestObserver = null;

    public boolean isRunning() {
        return this._lifeCycleAutomaton.isRunning();
    }

    public boolean isInitialized() {
        return this._lifeCycleAutomaton.isInitialized();
    }

    public LifecycleStatus getLifecycleStatus() {
        return this._lifeCycleAutomaton.getLifecycleStatus();
    }

    @Override
    public void pause() throws PauseException {
        this._lifeCycleAutomaton.pause();
    }

    @Override
    public void stop() throws StopException {
        this._lifeCycleAutomaton.stop();
    }

    @Override
    public void start() throws StartException {
        this._lifeCycleAutomaton.start();
    }

    @Override
    public void resume() throws ResumeException {
        this._lifeCycleAutomaton.resume();
    }

    @Override
    public void initialize() throws InitializeException {
        this._lifeCycleAutomaton.initialize();
    }

    public boolean isStoppable() {
        return this._lifeCycleAutomaton.isStoppable();
    }

    public boolean isPausable() {
        return this._lifeCycleAutomaton.isPausable();
    }

    public boolean isStartable() {
        return this._lifeCycleAutomaton.isStartable();
    }

    public boolean isResumable() {
        return this._lifeCycleAutomaton.isResumable();
    }

    public boolean isStopped() {
        return this._lifeCycleAutomaton.isStopped();
    }

    public boolean isPaused() {
        return this._lifeCycleAutomaton.isPaused();
    }

    public boolean isInitalizable() {
        return this._lifeCycleAutomaton.isInitalizable();
    }

    @Override
    public void destroy() {
        this._lifeCycleAutomaton.destroy();
    }

    public boolean isDestroyable() {
        return this._lifeCycleAutomaton.isDestroyable();
    }

    public boolean isDestroyed() {
        return this._lifeCycleAutomaton.isDestroyed();
    }

    public void setInstanceId(String aInstanceId) {
        this._instanceId = aInstanceId;
    }

    public String getInstanceId() {
        return this._instanceId;
    }

    public void setHost(String aHost) {
        this._host = aHost;
    }

    public String getHost() {
        return this._host;
    }

    public String getVirtualHost() {
        return this._virtualHost;
    }

    public void setVirtualHost(String aVirtualHost) {
        this._virtualHost = aVirtualHost;
    }

    public int[] getIpAddress() {
        return this._ipAddress;
    }

    public void setIpAddress(int[] aIpAddress) {
        this._ipAddress = aIpAddress;
    }

    public TrustStoreDescriptor getTrustStoreDescriptor() {
        return this._storeDescriptor;
    }

    public void setTrustStoreDescriptor(TrustStoreDescriptor aTrustStoreDescriptor) {
        this._storeDescriptor = aTrustStoreDescriptor;
    }

    @Override
    public DESC getHttpServerDescriptor() {
        return this._serverDescriptor;
    }

    @Override
    public void setHttpServerDescriptor(DESC aServerDescriptor) {
        this._serverDescriptor = aServerDescriptor;
    }

    @Override
    public Url getHttpRegistryUrl() {
        return this._serviceRegistryUrl;
    }

    @Override
    public void setHttpRegistryUrl(Url aRegistryUrl) {
        this._serviceRegistryUrl = aRegistryUrl;
    }

    public String getAlias() {
        return this._alias;
    }

    public void setAlias(String aAlias) {
        this._alias = aAlias;
    }

    @Override
    public String getPingPath() {
        return this._pingPath;
    }

    @Override
    public void setPingPath(String aPingPath) {
        this._pingPath = aPingPath;
    }

    protected static String toHost(String aHost, HostAccessor.HostProperty aProperty) throws UnknownHostException {
        if (aHost != null) {
            aProperty.setHost(aHost);
        } else {
            aHost = aProperty.getHost();
            if (aHost == null) {
                aHost = InetAddress.getLocalHost().getHostName();
                aProperty.setHost(aHost);
            }
        }
        return aHost;
    }

    protected static String toVirtualHost(String aVirtualHost, VirtualHostAccessor.VirtualHostProperty aProperty) {
        if (aVirtualHost != null) {
            aProperty.setVirtualHost(aVirtualHost);
        } else {
            aVirtualHost = aProperty.getVirtualHost();
        }
        return aVirtualHost;
    }

    protected static int[] toIpAddress(int[] aIpAddress, IpAddressAccessor.IpAddressProperty aProperty) throws IOException {
        if (aIpAddress != null) {
            aProperty.setIpAddress(aIpAddress);
        } else {
            aIpAddress = IpAddress.toHostIpAddress();
            aProperty.setIpAddress(aIpAddress);
        }
        return aIpAddress;
    }

    protected static String toAlias(String aAlias, AliasAccessor.AliasProperty aProperty) {
        if (aAlias != null) {
            aProperty.setAlias(aAlias);
        } else {
            aAlias = aProperty.getAlias();
        }
        return aAlias;
    }

    protected static Scheme toScheme(Scheme aScheme, SchemeAccessor.SchemeProperty aProperty) {
        if (aScheme != null) {
            aProperty.setScheme(aScheme);
        } else {
            aScheme = aProperty.getScheme();
        }
        return aScheme;
    }

    protected static int toPort(int aPort, PortAccessor.PortProperty aProperty) {
        if (aPort != -1) {
            aProperty.setPort(aPort);
        } else {
            aPort = aProperty.getPort();
        }
        return aPort;
    }

    protected static String toInstanceId(String aInstanceId, String aHost, InstanceIdAccessor.InstanceIdProperty aProperty) {
        if (aInstanceId != null) {
            aProperty.setInstanceId(aInstanceId);
        } else {
            aInstanceId = aProperty.getInstanceId();
            if (aInstanceId == null) {
                aInstanceId = aHost;
                aProperty.setInstanceId(aInstanceId);
            }
        }
        return aInstanceId;
    }

    protected static String toPingPath(String aPingPath, String aDefaultPingPath, PingPathAccessor.PingPathProperty aProperty) {
        if (aPingPath != null) {
            aProperty.setPingPath(aPingPath);
        } else {
            aPingPath = aProperty.getPingPath();
            if (aPingPath == null) {
                aPingPath = aDefaultPingPath;
                aProperty.setPingPath(aPingPath);
            }
        }
        return aPingPath;
    }

    protected static TrustStoreDescriptor toTrustStoreDescriptor(TrustStoreDescriptor aStoreDescriptor, TrustStoreDescriptorAccessor.TrustStoreDescriptorProperty aProperty) {
        if (aStoreDescriptor != null) {
            aProperty.setTrustStoreDescriptor(aStoreDescriptor);
        } else {
            aStoreDescriptor = aProperty.getTrustStoreDescriptor();
        }
        return aStoreDescriptor;
    }

    protected static Url toHttpRegistryUrl(Url aRegistryUrl, HttpRegistryUrlAccessor.HttpRegistryUrlProperty aProperty) {
        if (aRegistryUrl != null) {
            aProperty.setHttpRegistryUrl(aRegistryUrl);
        } else {
            aRegistryUrl = aProperty.getHttpRegistryUrl();
        }
        return aRegistryUrl;
    }

    protected static <DESC extends HttpServerDescriptor> DESC toHttpServerDescriptor(DESC aServerDescriptor, HttpServerDescriptorAccessor.HttpServerDescriptorProperty<DESC> aProperty) {
        if (aServerDescriptor != null) {
            aProperty.setHttpServerDescriptor(aServerDescriptor);
        } else {
            aServerDescriptor = aProperty.getHttpServerDescriptor();
        }
        return aServerDescriptor;
    }
}

