/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.util.Map;
import org.refcodes.mixin.Dumpable;
import org.refcodes.rest.RestClient;
import org.refcodes.rest.RestRequest;
import org.refcodes.rest.RestResponse;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.HeaderFieldsAccessor;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpMethodAccessor;
import org.refcodes.web.HttpRequestBuilder;
import org.refcodes.web.HttpResponseException;
import org.refcodes.web.RedirectDepthAccessor;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.Url;
import org.refcodes.web.UrlAccessor;
import org.refcodes.web.UrlBuilder;

public class RestRequestBuilder
extends RestRequest
implements HeaderFieldsAccessor.HeaderFieldsProperty<RequestHeaderFields>,
Dumpable,
RedirectDepthAccessor.RedirectDepthBuilder<RestRequestBuilder>,
HttpRequestBuilder<RestRequestBuilder>,
HttpMethodAccessor.HttpMethodProperty,
HttpMethodAccessor.HttpMethodBuilder<RestRequestBuilder>,
HeaderFieldsAccessor.HeaderFieldsBuilder<RequestHeaderFields, RestRequestBuilder> {
    private RestClient _restClient;

    protected RestRequestBuilder(HttpMethod httpMethod, Url url, RequestHeaderFields requestHeaderFields, Object object, RestClient restClient) {
        this(httpMethod, (Url)(url instanceof UrlBuilder ? url : new UrlBuilder(url)), requestHeaderFields, object, -1, restClient);
    }

    protected RestRequestBuilder(HttpMethod httpMethod, Url url, RestClient restClient) {
        this(httpMethod, url, null, null, restClient);
    }

    protected RestRequestBuilder(RestClient restClient) {
        this(null, null, null, null, restClient);
    }

    protected RestRequestBuilder(HttpMethod httpMethod, Url url, Object object, RestClient restClient) {
        this(httpMethod, url, null, object, restClient);
    }

    protected RestRequestBuilder(HttpMethod httpMethod, Url url, int n, RestClient restClient) {
        this(httpMethod, url, null, null, n, restClient);
    }

    protected RestRequestBuilder(HttpMethod httpMethod, Url url, Object object, int n, RestClient restClient) {
        this(httpMethod, url, null, object, n, restClient);
    }

    protected RestRequestBuilder(HttpMethod httpMethod, Url url, RequestHeaderFields requestHeaderFields, Object object, int n, RestClient restClient) {
        super(httpMethod, (Url)(url instanceof UrlAccessor.UrlBuilder ? url : new UrlBuilder(url)), requestHeaderFields, object, n, restClient);
        this._restClient = restClient;
    }

    public RestRequestBuilder withUrl(Url url) {
        this.setUrl(url);
        return this;
    }

    public RestRequestBuilder withHttpMethod(HttpMethod httpMethod) {
        this.setHttpMethod(httpMethod);
        return this;
    }

    public <REQ> RestRequestBuilder withRequest(REQ REQ) {
        this.setRequest(REQ);
        return this;
    }

    public RestRequestBuilder withHeaderFields(RequestHeaderFields requestHeaderFields) {
        this.setHeaderFields(requestHeaderFields);
        return this;
    }

    public RestRequestBuilder withRedirectDepth(int n) {
        this.setRedirectDepth(n);
        return this;
    }

    @Override
    public RestRequestBuilder build(RestClient restClient) {
        return new RestRequestBuilder(restClient);
    }

    @Override
    public UrlBuilder getUrl() {
        return (UrlBuilder)this._url;
    }

    public void setUrl(Url url) {
        this._url = url;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this._httpMethod;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this._httpMethod = httpMethod;
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this._httpMethod + ": " + this._url.toHttpUrl() + "?" + new VerboseTextBuilder().withElements((Map)this._url.getQueryFields()).toString() + ")@" + ((Object)((Object)this)).hashCode();
    }

    @Override
    public void setHeaderFields(RequestHeaderFields requestHeaderFields) {
        this._headerFields = requestHeaderFields;
    }

    @Override
    public RestResponse toRestResponse() throws HttpResponseException {
        return this._restClient.doRequest(this.getHttpMethod(), (Url)this.getUrl(), this.getHeaderFields(), this.getRequest(), this.getRedirectDepth());
    }
}

